/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.mcp.internal.tracing;

import com.mulesoft.connectors.mcp.internal.server.connection.observer.InboundRequestContext;
import com.mulesoft.connectors.mcp.internal.tracing.InboundSpanCustomizer;
import com.mulesoft.connectors.mcp.internal.tracing.OutboundSpanCustomizer;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.sdk.api.runtime.source.DistributedTraceContextManager;

public final class TracingUtils {
    private TracingUtils() {
    }

    public static void traceInboundRequest(InboundRequestContext context, DistributedTraceContextManager traceManager) {
        new InboundSpanCustomizer(traceManager, context.getPath(), context.getIp(), context.getPort(), context.getHttpVersion(), context.getScheme(), context.getAdditionalProperties(), context.getMethod()).customizeSpan();
    }

    public static void traceOutboundRequest(HttpRequest request, DistributedTraceContextManager traceContextManager) {
        if (traceContextManager != null) {
            new OutboundSpanCustomizer(traceContextManager, request).customizeSpan();
        }
    }

    public static HttpRequestBuilder propagateTraceContext(HttpRequestBuilder builder, DistributedTraceContextManager traceContextManager) {
        if (traceContextManager != null) {
            traceContextManager.getRemoteTraceContextMap().forEach((arg_0, arg_1) -> ((HttpRequestBuilder)builder).addHeader(arg_0, arg_1));
        }
        return builder;
    }
}

