/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.mcp.internal.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mulesoft.connectors.mcp.internal.McpUtils;
import com.mulesoft.connectors.mcp.internal.error.McpErrorTypes;
import com.mulesoft.connectors.mcp.internal.jackson.ObjectMapperFactory;
import com.mulesoft.connectors.mcp.internal.server.connection.MuleServerSession;
import com.mulesoft.connectors.mcp.internal.server.connection.observer.InboundRequestContext;
import com.mulesoft.connectors.mcp.internal.server.connection.observer.InternalNewSessionRequest;
import com.mulesoft.connectors.mcp.internal.util.CertificateUtils;
import io.modelcontextprotocol.spec.McpSchema;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Optional;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.runtime.http.api.domain.request.HttpRequestContext;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.ServerAddress;
import org.mule.runtime.http.api.server.async.HttpResponseReadyCallback;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.mule.runtime.http.api.sse.server.SseClient;
import org.mule.runtime.http.api.sse.server.SseClientConfig;
import org.mule.sdk.api.error.ErrorTypeDefinition;
import org.mule.sdk.api.exception.ModuleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpTransportUtils {
    private static Logger LOGGER = LoggerFactory.getLogger(HttpTransportUtils.class);
    public static final String APPLICATION_JSON = "application/json";
    public static final String TEXT_EVENT_STREAM = "text/event-stream";
    public static final String STREAMABLE_SESSION_ID_HEADER = "Mcp-Session-Id";
    private static final ObjectMapper OBJECT_MAPPER = ObjectMapperFactory.get();
    private static final String MESSAGE_EVENT_NAME = "message";

    private HttpTransportUtils() {
    }

    public static InternalNewSessionRequest createNewSessionRequest(MuleServerSession session, HttpRequestContext requestContext) {
        return new InternalNewSessionRequest(session, HttpTransportUtils.extractAdditionalProperties(requestContext), () -> CertificateUtils.buildCertificateData(requestContext.getClientConnection()), requestContext.getServerConnection().getLocalHostAddress().toString(), requestContext.getClientConnection().getRemoteHostAddress().toString());
    }

    public static Optional<InboundRequestContext> asInboundRequestContext(McpSchema.JSONRPCMessage message, String sessionId, HttpRequestContext requestContext, HttpServer httpServer) {
        if (message instanceof McpSchema.JSONRPCRequest) {
            McpSchema.JSONRPCRequest rpc = (McpSchema.JSONRPCRequest)message;
            ServerAddress serverAddress = httpServer.getServerAddress();
            return Optional.of(new InboundRequestContext(rpc, sessionId, HttpTransportUtils.extractAdditionalProperties(requestContext), requestContext.getRequest().getPath(), serverAddress.getIp(), serverAddress.getPort(), httpServer.getProtocol().toString(), httpServer.getProtocol().getScheme(), requestContext.getRequest().getMethod(), () -> CertificateUtils.buildCertificateData(requestContext.getClientConnection())));
        }
        return Optional.empty();
    }

    private static MultiMap<String, String> extractAdditionalProperties(HttpRequestContext requestContext) {
        MultiMap additionalProperties = new MultiMap(requestContext.getRequest().getHeaders());
        additionalProperties.putAll(requestContext.getRequest().getQueryParams());
        return additionalProperties.toImmutableMultiMap();
    }

    public static void sendHttpResponse(int statusCode, String body, HttpResponseReadyCallback callback) {
        HttpTransportUtils.sendHttpResponse(statusCode, body, (MultiMap<String, String>)MultiMap.emptyMultiMap(), callback);
    }

    public static void sendHttpResponse(int statusCode, String body, MultiMap<String, String> headers, HttpResponseReadyCallback callback) {
        HttpTransportUtils.sendHttpResponse(((HttpResponseBuilder)((HttpResponseBuilder)HttpResponse.builder().statusCode(Integer.valueOf(statusCode)).headers(headers)).entity((HttpEntity)new ByteArrayHttpEntity(body.getBytes()))).build(), callback);
    }

    public static void sendHttpResponse(int statusCode, McpSchema.JSONRPCMessage message, HttpResponseReadyCallback callback) {
        HttpTransportUtils.sendHttpResponse(statusCode, message, (MultiMap<String, String>)MultiMap.emptyMultiMap(), callback);
    }

    public static void sendHttpResponse(int statusCode, McpSchema.JSONRPCMessage message, MultiMap<String, String> headers, HttpResponseReadyCallback callback) {
        String body;
        try {
            body = OBJECT_MAPPER.writeValueAsString((Object)message);
        }
        catch (JsonProcessingException e) {
            McpSchema.JSONRPCResponse.JSONRPCError error;
            McpSchema.JSONRPCResponse.JSONRPCError jSONRPCError = error = message instanceof McpSchema.JSONRPCResponse ? ((McpSchema.JSONRPCResponse)message).error() : null;
            if (error != null) {
                LOGGER.error("Failed to serialize JSON RPC error response. Defaulting to message", (Throwable)e);
                body = error.message();
            }
            LOGGER.error("Failed to serialize JSON RPC error message. Responding with error message", (Throwable)e);
            statusCode = HttpConstants.HttpStatus.INTERNAL_SERVER_ERROR.getStatusCode();
            body = e.getMessage();
        }
        HttpTransportUtils.sendHttpResponse(((HttpResponseBuilder)((HttpResponseBuilder)HttpResponse.builder().statusCode(Integer.valueOf(statusCode)).entity((HttpEntity)new ByteArrayHttpEntity(body.getBytes()))).headers(headers)).build(), callback);
    }

    public static void sendHttpResponse(HttpResponse response, HttpResponseReadyCallback callback) {
        callback.responseReady(response, new ResponseStatusCallback(){

            public void responseSendFailure(Throwable throwable) {
                LOGGER.error("Failed to send message response", throwable);
            }

            public void responseSendSuccessfully() {
            }
        });
    }

    public static void sendHttpInternalErrorResponse(Throwable t, McpSchema.JSONRPCMessage originalMessage, HttpResponseReadyCallback responseCallback) {
        try {
            HttpTransportUtils.sendHttpResponse(((HttpResponseBuilder)((HttpResponseBuilder)HttpResponse.builder().statusCode(Integer.valueOf(HttpConstants.HttpStatus.INTERNAL_SERVER_ERROR.getStatusCode())).addHeader("Content-Type", APPLICATION_JSON)).entity((HttpEntity)new ByteArrayHttpEntity(OBJECT_MAPPER.writeValueAsBytes((Object)McpUtils.rpcErrorResponse(originalMessage, McpErrorTypes.SERVER_ERROR, t.getMessage()))))).build(), responseCallback);
        }
        catch (Exception e) {
            LOGGER.error("Error serializing error message", (Throwable)e);
            HttpTransportUtils.sendHttpResponse(HttpConstants.HttpStatus.INTERNAL_SERVER_ERROR.getStatusCode(), "Error sending error response: " + e.getMessage(), responseCallback);
        }
    }

    public static void sendMessageEvent(SseClient client, McpSchema.JSONRPCMessage message) {
        HttpTransportUtils.sendMessageEvent(client, MESSAGE_EVENT_NAME, message);
    }

    public static void sendMessageEvent(SseClient client, String eventType, McpSchema.JSONRPCMessage message) {
        String json;
        try {
            json = OBJECT_MAPPER.writeValueAsString((Object)message);
        }
        catch (JsonProcessingException e) {
            throw new ModuleException("Could not serialize outbound message", (ErrorTypeDefinition)McpErrorTypes.INTERNAL_ERROR, (Throwable)e);
        }
        HttpTransportUtils.sendMessageEvent(client, eventType, json);
    }

    public static void sendMessageEvent(SseClient client, String eventType, String message) {
        try {
            client.sendEvent(eventType, message);
        }
        catch (Exception e) {
            throw new ModuleException("Found exception sending '%s' event to session %s".formatted(MESSAGE_EVENT_NAME, client.getClientId()), (ErrorTypeDefinition)McpErrorTypes.INTERNAL_ERROR, (Throwable)e);
        }
    }

    public static void discardAndClose(HttpResponse response) {
        IOUtils.closeQuietly((Closeable)response.getEntity().getContent());
    }

    public static HttpResponseReadyCallback afterSent(final HttpResponseReadyCallback callback, final Runnable runnable) {
        return new HttpResponseReadyCallback(){

            public void responseReady(HttpResponse response, ResponseStatusCallback responseStatusCallback) {
                callback.responseReady(response, responseStatusCallback);
                runnable.run();
            }

            public Writer startResponse(HttpResponse response, ResponseStatusCallback responseStatusCallback, Charset encoding) {
                return callback.startResponse(response, responseStatusCallback, encoding);
            }

            public SseClient startSseResponse(SseClientConfig config) {
                return callback.startSseResponse(config);
            }
        };
    }

    public static String normalizePath(String path, String pathName) {
        if (StringUtils.isBlank((String)path)) {
            throw new IllegalArgumentException(pathName + " cannot be blank");
        }
        if (!((String)path).startsWith("/")) {
            path = "/" + (String)path;
        }
        return path;
    }

    public static McpSchema.JSONRPCMessage parseMessageFromBody(HttpRequest request) throws IOException {
        return HttpTransportUtils.parseMessageFromBody(request.getEntity());
    }

    public static McpSchema.JSONRPCMessage parseMessageFromBody(HttpResponse response) throws IOException {
        return HttpTransportUtils.parseMessageFromBody(response.getEntity());
    }

    public static McpSchema.JSONRPCMessage parseMessageFromBody(HttpEntity entity) throws IOException {
        return McpSchema.deserializeJsonRpcMessage((ObjectMapper)OBJECT_MAPPER, (String)IOUtils.toString((InputStream)entity.getContent()));
    }
}

