/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.mcp.internal.client.connection.provider.sse;

import com.mulesoft.connectors.mcp.internal.client.connection.provider.AbstractHttpClientConnectionProvider;
import com.mulesoft.connectors.mcp.internal.client.connection.transport.sse.SseClientTransport;
import io.modelcontextprotocol.spec.McpClientTransport;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.util.MultiMap;
import org.mule.sdk.api.annotation.Alias;
import org.mule.sdk.api.annotation.param.Optional;
import org.mule.sdk.api.annotation.param.Parameter;
import org.mule.sdk.api.annotation.param.display.Summary;

@Alias(value="sse-client")
public class SseClientConnectionProvider
extends AbstractHttpClientConnectionProvider {
    @Parameter
    @Summary(value="The base URL for the target MCP server")
    private String serverUrl;
    @Parameter
    @Optional(defaultValue="/sse")
    private String sseEndpointPath;
    @Parameter
    @Optional(defaultValue="500")
    @Summary(value="Specifies how long to wait before reinitializing the SSE connection when it times out or closes.")
    private long reconnectionDelay;
    @Parameter
    @Optional(defaultValue="MILLISECONDS")
    @Summary(value="Time Unit for the reconnectionDelay")
    private TimeUnit reconnectionDelayUnit;

    @Override
    protected McpClientTransport createClientTransport() {
        return new SseClientTransport(this.serverUrl, this.sseEndpointPath, this.reconnectionDelay, this.reconnectionDelayUnit, (int)this.requestTimeoutUnit.toMillis(this.requestTimeout.intValue()), this.httpClient, this.authentication, (MultiMap<String, String>)this.defaultRequestHeaders, this.messagingManager);
    }
}

