/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.mcp.internal.design.vp;

import io.modelcontextprotocol.client.McpAsyncClient;
import io.modelcontextprotocol.spec.McpSchema;
import java.util.LinkedHashSet;
import java.util.Set;
import org.mule.sdk.api.annotation.param.Connection;
import org.mule.sdk.api.values.Value;
import org.mule.sdk.api.values.ValueBuilder;
import org.mule.sdk.api.values.ValueProvider;
import org.mule.sdk.api.values.ValueResolvingException;

public class ResourceUriValueProvider
implements ValueProvider {
    @Connection
    private McpAsyncClient client;

    public Set<Value> resolve() throws ValueResolvingException {
        String nextCursor = null;
        LinkedHashSet<Value> values = new LinkedHashSet<Value>();
        do {
            try {
                McpSchema.ListResourcesResult response = (McpSchema.ListResourcesResult)this.client.listResources(nextCursor).block();
                response.resources().forEach(r -> values.add(ValueBuilder.newValue((String)r.uri()).withDisplayName(r.name()).build()));
                nextCursor = response.nextCursor();
            }
            catch (Exception e) {
                throw new ValueResolvingException(e.getMessage(), "", (Throwable)e);
            }
        } while (nextCursor != null);
        return values;
    }

    public String getId() {
        return this.getClass().getName();
    }
}

