/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.mcp.internal.error;

import com.mulesoft.connectors.mcp.internal.error.McpErrorTypes;
import io.modelcontextprotocol.spec.McpError;
import io.modelcontextprotocol.spec.McpSchema;
import java.util.concurrent.TimeoutException;
import org.mule.runtime.extension.api.runtime.exception.ExceptionHandler;
import org.mule.sdk.api.error.ErrorTypeDefinition;
import org.mule.sdk.api.exception.ModuleException;
import reactor.core.Exceptions;

public class McpExceptionHandler
extends ExceptionHandler {
    public Exception enrichException(Exception e) {
        if ((e = this.unwrap(e)) instanceof ModuleException) {
            return e;
        }
        if (e instanceof McpError) {
            McpError mcpException = (McpError)e;
            McpSchema.JSONRPCResponse.JSONRPCError rpcError = mcpException.getJsonRpcError();
            if (rpcError != null) {
                return new ModuleException(e.getMessage(), (ErrorTypeDefinition)McpErrorTypes.fromRpcErrorCode(rpcError.code()), (Throwable)e);
            }
        } else if (e instanceof TimeoutException) {
            return new ModuleException(e.getMessage(), (ErrorTypeDefinition)McpErrorTypes.REQUEST_TIMEOUT, (Throwable)e);
        }
        return e;
    }

    private Exception unwrap(Exception e) {
        Throwable t = Exceptions.unwrap((Throwable)e);
        return t instanceof Exception ? (Exception)t : new RuntimeException(e);
    }
}

