/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.mcp.internal.server.connection;

import io.modelcontextprotocol.spec.McpSchema;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public final class ClientCapabilitiesSerializable
implements Serializable {
    private final Map<String, Object> experimental;
    private final RootCapabilities roots;
    private final Sampling sampling;

    public ClientCapabilitiesSerializable() {
        this.experimental = null;
        this.roots = new RootCapabilities();
        this.sampling = new Sampling();
    }

    public ClientCapabilitiesSerializable(Map<String, Object> experimental, RootCapabilities roots, Sampling sampling) {
        this.experimental = experimental;
        this.roots = roots;
        this.sampling = sampling;
    }

    public Map<String, Object> experimental() {
        return this.experimental;
    }

    public RootCapabilities roots() {
        return this.roots;
    }

    public Sampling sampling() {
        return this.sampling;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ClientCapabilitiesSerializable that = (ClientCapabilitiesSerializable)obj;
        return Objects.equals(this.experimental, that.experimental) && Objects.equals(this.roots, that.roots) && Objects.equals(this.sampling, that.sampling);
    }

    public int hashCode() {
        return Objects.hash(this.experimental, this.roots, this.sampling);
    }

    public String toString() {
        return "ClientCapabilitiesSerializable[experimental=" + String.valueOf(this.experimental) + ", roots=" + String.valueOf(this.roots) + ", sampling=" + String.valueOf(this.sampling) + "]";
    }

    public static ClientCapabilitiesSerializable fromOriginal(McpSchema.ClientCapabilities original) {
        if (original == null) {
            return null;
        }
        Map<String, Object> experimentalCopy = original.experimental() != null ? original.experimental().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)) : null;
        RootCapabilities newRoots = original.roots() != null ? new RootCapabilities(original.roots().listChanged()) : null;
        Sampling newSampling = original.sampling() != null ? new Sampling() : null;
        return new ClientCapabilitiesSerializable(experimentalCopy, newRoots, newSampling);
    }

    public McpSchema.ClientCapabilities toOriginal() {
        McpSchema.ClientCapabilities.Builder builder = McpSchema.ClientCapabilities.builder();
        if (this.experimental != null) {
            builder.experimental(this.experimental);
        }
        if (this.roots != null && this.roots.listChanged() != null) {
            builder.roots(this.roots.listChanged());
        }
        if (this.sampling != null) {
            builder.sampling();
        }
        return builder.build();
    }

    public static final class RootCapabilities
    implements Serializable {
        private final Boolean listChanged;

        public RootCapabilities() {
            this.listChanged = null;
        }

        public RootCapabilities(Boolean listChanged) {
            this.listChanged = listChanged;
        }

        public Boolean listChanged() {
            return this.listChanged;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            RootCapabilities that = (RootCapabilities)obj;
            return Objects.equals(this.listChanged, that.listChanged);
        }

        public int hashCode() {
            return Objects.hash(this.listChanged);
        }

        public String toString() {
            return "RootCapabilities[listChanged=" + this.listChanged + "]";
        }
    }

    public static final class Sampling
    implements Serializable {
        public boolean equals(Object obj) {
            return obj != null && this.getClass() == obj.getClass();
        }

        public int hashCode() {
            return 1;
        }

        public String toString() {
            return "Sampling[]";
        }
    }
}

