/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.mcp.internal.server.connection;

import com.fasterxml.jackson.core.type.TypeReference;
import com.mulesoft.connectors.mcp.internal.error.McpErrorTypes;
import com.mulesoft.connectors.mcp.internal.server.connection.ClientCapabilitiesSerializable;
import com.mulesoft.connectors.mcp.internal.server.connection.ImplementationSerializable;
import com.mulesoft.connectors.mcp.internal.server.connection.McpSessionDecorator;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.spec.McpServerSession;
import io.modelcontextprotocol.spec.McpServerTransport;
import io.modelcontextprotocol.spec.McpSession;
import java.io.Serializable;
import org.mule.sdk.api.error.ErrorTypeDefinition;
import org.mule.sdk.api.exception.ModuleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class MuleServerSession
extends McpSessionDecorator
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MuleServerSession.class);
    private final String id;
    private ClientCapabilitiesSerializable clientCapabilities = null;
    private ImplementationSerializable clientInfo = null;
    private final transient boolean restored;
    private final transient McpServerSession delegate;
    private transient McpServerTransport transport;
    private transient Runnable onInitialize = null;
    private boolean initialized = false;

    public MuleServerSession(McpServerSession delegate, McpServerTransport transport) {
        this(delegate.getId(), delegate, transport, null, null, false, false);
    }

    private MuleServerSession(String rewrittenId, McpServerSession delegate, McpServerTransport transport, ClientCapabilitiesSerializable clientCapabilities, ImplementationSerializable clientInfo, boolean restored, boolean initialized) {
        super((McpSession)delegate);
        this.id = rewrittenId;
        this.delegate = delegate;
        this.transport = transport;
        this.clientCapabilities = clientCapabilities;
        this.clientInfo = clientInfo;
        this.initialized = initialized;
        this.restored = restored;
    }

    public Mono<Void> handle(McpSchema.JSONRPCMessage message) {
        McpSchema.JSONRPCNotification notification;
        McpSchema.JSONRPCRequest request;
        boolean initializationRequired;
        boolean bl = initializationRequired = !this.initialized;
        if (message instanceof McpSchema.JSONRPCRequest && "initialize".equals((request = (McpSchema.JSONRPCRequest)message).method())) {
            McpSchema.InitializeRequest initializeRequest = (McpSchema.InitializeRequest)this.transport.unmarshalFrom(request.params(), (TypeReference)new TypeReference<McpSchema.InitializeRequest>(){});
            this.clientCapabilities = ClientCapabilitiesSerializable.fromOriginal(initializeRequest.capabilities());
            this.clientInfo = ImplementationSerializable.fromOriginal(initializeRequest.clientInfo());
            this.initialized = true;
            initializationRequired = false;
            if (this.onInitialize != null) {
                try {
                    this.onInitialize.run();
                }
                catch (Exception e) {
                    LOGGER.error("Failed to execute onInitialize callback for session", (Throwable)e);
                    return Mono.error((Throwable)new ModuleException("Session initialization failed: " + e.getMessage(), (ErrorTypeDefinition)McpErrorTypes.INTERNAL_ERROR, (Throwable)e));
                }
            }
        } else if (message instanceof McpSchema.JSONRPCNotification && (notification = (McpSchema.JSONRPCNotification)message).method().equals("notifications/initialized")) {
            initializationRequired = false;
        }
        if (initializationRequired && !this.initialized) {
            return Mono.error((Throwable)new ModuleException("Cannot process message because this session hasn't been initialized yet", (ErrorTypeDefinition)McpErrorTypes.INVALID_REQUEST));
        }
        return this.delegate.handle(message);
    }

    public MuleServerSession restoreFrom(McpServerSession newDelegate, McpServerTransport transport) {
        if (this.clientCapabilities != null || this.clientInfo != null) {
            newDelegate.init(this.clientCapabilities != null ? this.clientCapabilities.toOriginal() : null, this.clientInfo != null ? this.clientInfo.toOriginal() : null);
            newDelegate.handle((McpSchema.JSONRPCMessage)new McpSchema.JSONRPCNotification("2.0", "notifications/initialized", null)).block();
            this.initialized = true;
        }
        return new MuleServerSession(this.id, newDelegate, transport, this.clientCapabilities, this.clientInfo, true, this.initialized);
    }

    public String getId() {
        return this.id;
    }

    public McpServerTransport getTransport() {
        return this.transport;
    }

    public void onInitialize(Runnable onInitialize) {
        this.onInitialize = onInitialize;
    }
}

