/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.mcp.internal.server.connection.provider.sse;

import com.mulesoft.connectors.mcp.internal.server.connection.provider.BaseServerTransportProvider;
import com.mulesoft.connectors.mcp.internal.server.connection.provider.McpServerConnectionProvider;
import com.mulesoft.connectors.mcp.internal.server.connection.provider.sse.SSEServerTransportProvider;
import io.modelcontextprotocol.server.McpAsyncServer;
import javax.inject.Inject;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.annotation.param.reference.ConfigReference;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.ServerNotFoundException;
import org.mule.sdk.api.annotation.Alias;
import org.mule.sdk.api.annotation.Expression;
import org.mule.sdk.api.annotation.param.NullSafe;
import org.mule.sdk.api.annotation.param.Optional;
import org.mule.sdk.api.annotation.param.Parameter;
import org.mule.sdk.api.connectivity.NoConnectivityTest;
import org.mule.sdk.api.meta.ExpressionSupport;

@Alias(value="sse-server")
public class SSEServerConnectionProvider
extends McpServerConnectionProvider
implements NoConnectivityTest {
    @Inject
    private HttpService httpService;
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ConfigReference(name="LISTENER_CONFIG", namespace="HTTP")
    @Summary(value="Reference to the <http:listener-config> used to expose the inbound endpoint")
    private String listenerConfig;
    @Parameter
    @Optional(defaultValue="/sse")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private String sseEndpointPath;
    @Parameter
    @Optional(defaultValue="/message")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private String messagesPath;
    @Parameter
    @Optional
    @NullSafe
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private MultiMap<String, String> defaultSseResponseHeaders = MultiMap.emptyMultiMap();
    @Parameter
    @Optional
    @NullSafe
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private MultiMap<String, String> defaultMessageResponseHeaders = MultiMap.emptyMultiMap();

    @Override
    protected BaseServerTransportProvider createTransportProvider() throws ConnectionException {
        try {
            HttpServer httpServer = this.httpService.getServerFactory().lookup(this.listenerConfig);
            return new SSEServerTransportProvider(this.configName, httpServer, this.getScheduler(), this.sseEndpointPath, this.messagesPath, this.defaultSseResponseHeaders, this.defaultMessageResponseHeaders);
        }
        catch (ServerNotFoundException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Could not find <http:listener-config> named '%s'".formatted(this.listenerConfig), (Object[])new Object[]{e}));
        }
    }

    public ConnectionValidationResult validate(McpAsyncServer server) {
        return ConnectionValidationResult.success();
    }
}

