/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.mcp.internal.server.session;

import com.mulesoft.connectors.mcp.internal.server.connection.MuleServerSession;
import com.mulesoft.connectors.mcp.internal.server.session.SessionManager;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class InMemorySessionManager
implements SessionManager {
    private final Map<String, MuleServerSession> sessions = new ConcurrentHashMap<String, MuleServerSession>();

    @Override
    public boolean unregisterAndClose(String sessionId) {
        MuleServerSession session = this.sessions.remove(sessionId);
        if (session != null) {
            session.close();
            return true;
        }
        return false;
    }

    @Override
    public Collection<MuleServerSession> getLocalSessions() {
        return this.sessions.values();
    }

    @Override
    public void close() {
        this.sessions.clear();
    }

    @Override
    public void upsert(MuleServerSession session) {
        this.sessions.put(session.getId(), session);
    }

    @Override
    public Optional<MuleServerSession> recoverSession(String sessionId) {
        return Optional.ofNullable(this.sessions.get(sessionId));
    }
}

