/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.mcp.internal.server.source.resource;

import com.mulesoft.connectors.mcp.api.server.resource.BlobResource;
import com.mulesoft.connectors.mcp.api.server.resource.ResourceVisitor;
import com.mulesoft.connectors.mcp.api.server.resource.TextResource;
import com.mulesoft.connectors.mcp.internal.McpUtils;
import io.modelcontextprotocol.spec.McpSchema;

public class ResourceContentTransformer
implements ResourceVisitor {
    private final String uri;
    private final String mimeType;
    private McpSchema.ResourceContents content;

    public ResourceContentTransformer(String uri, String mimeType) {
        this.uri = uri;
        this.mimeType = mimeType;
    }

    @Override
    public void visit(TextResource resource) {
        this.content = new McpSchema.TextResourceContents(this.uri, this.mimeType, resource.getText());
    }

    @Override
    public void visit(BlobResource resource) {
        this.content = new McpSchema.BlobResourceContents(this.uri, this.mimeType, McpUtils.toBase64(resource.getBlob()));
    }

    public McpSchema.ResourceContents getContent() {
        return this.content;
    }
}

