/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.microsoft.dynamics.nav.internal.datasense;

import com.mulesoft.connectors.microsoft.dynamics.nav.internal.connection.DynamicsNavConnection;
import com.mulesoft.connectors.microsoft.dynamics.nav.internal.datasense.SOAPServicesMetadata;
import com.mulesoft.connectors.microsoft.dynamics.nav.internal.service.connection.soap.XmlTypeField;
import com.mulesoft.connectors.microsoft.dynamics.nav.internal.service.connection.soap.client.DynamicsNavSoapClient;
import com.mulesoft.connectors.microsoft.dynamics.nav.internal.service.utils.BeanUtils;
import com.mulesoft.connectors.microsoft.dynamics.nav.internal.utils.ServiceOperationParam;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeyBuilder;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.metadata.resolving.InputTypeResolver;
import org.mule.runtime.api.metadata.resolving.OutputTypeResolver;
import org.mule.runtime.api.metadata.resolving.TypeKeysResolver;

public class CodeUnitMetadataResolver
extends SOAPServicesMetadata
implements TypeKeysResolver,
OutputTypeResolver<ServiceOperationParam>,
InputTypeResolver<ServiceOperationParam> {
    public Set<MetadataKey> getKeys(MetadataContext metadataContext) throws MetadataResolvingException, ConnectionException {
        HashSet<MetadataKey> result = new HashSet<MetadataKey>();
        DynamicsNavConnection connection = CodeUnitMetadataResolver.extractConnection(metadataContext);
        this.getDiscoveryClient(connection).getCodeunitServices().forEach(service -> {
            List<String> operations = this.getCodeUnitServiceClient(connection, (String)service).getOperationsNames();
            if (!operations.isEmpty()) {
                MetadataKeyBuilder firstLevelKey = MetadataKeyBuilder.newKey((String)service).withDisplayName(service);
                operations.forEach(operation -> {
                    MetadataKeyBuilder secondLevelKey = MetadataKeyBuilder.newKey((String)operation).withDisplayName(operation);
                    firstLevelKey.withChild(secondLevelKey);
                });
                result.add(firstLevelKey.build());
            }
        });
        return result;
    }

    public String getResolverName() {
        return CodeUnitMetadataResolver.class.getName();
    }

    public MetadataType getInputMetadata(MetadataContext metadataContext, ServiceOperationParam serviceOperationParam) throws MetadataResolvingException, ConnectionException {
        String service = serviceOperationParam.getService();
        String operation = serviceOperationParam.getOperation();
        DynamicsNavConnection connection = CodeUnitMetadataResolver.extractConnection(metadataContext);
        Class operationInputType = this.getCodeUnitServiceClient(connection, service).getOperationInputType(operation);
        List<XmlTypeField> fields = BeanUtils.getXmlTypeFields(operationInputType);
        if (fields.size() == 1 && Objects.equals(BeanUtils.isListOrPojo(fields.get(0).getType()), "List") || Objects.equals(BeanUtils.isListOrPojo(fields.get(0).getType()), "Pojo")) {
            operationInputType = fields.get(0).getType();
        }
        ObjectTypeBuilder builder = metadataContext.getTypeBuilder().objectType().id(operationInputType.getSimpleName());
        return this.getMetadataType(builder, operationInputType, fields);
    }

    public String getCategoryName() {
        return "CodeUnitMetadataCategory";
    }

    public MetadataType getOutputType(MetadataContext context, ServiceOperationParam serviceOperationParam) throws MetadataResolvingException, ConnectionException {
        String service = serviceOperationParam.getService();
        String operation = serviceOperationParam.getOperation();
        DynamicsNavConnection connection = CodeUnitMetadataResolver.extractConnection(context);
        Class type = this.getCodeUnitServiceClient(connection, service).getOperationOutputType(operation);
        type = this.getOutputFieldType(type);
        ObjectTypeBuilder builder = context.getTypeBuilder().objectType().id(type.getSimpleName());
        return this.getMetadataType(builder, type, BeanUtils.getXmlTypeFields(type));
    }

    private static DynamicsNavConnection extractConnection(MetadataContext metadataContext) throws ConnectionException, MetadataResolvingException {
        Optional optionalConnection = metadataContext.getConnection();
        return (DynamicsNavConnection)optionalConnection.orElseThrow(() -> new MetadataResolvingException("No connection available.", FailureCode.CONNECTION_FAILURE));
    }

    private DynamicsNavSoapClient getCodeUnitServiceClient(DynamicsNavConnection connection, String service) {
        return connection.getSoapClientProvider().getCodeUnitClient(service);
    }
}

