/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.microsoft.dynamics.nav.internal.paging;

import com.mulesoft.connectors.microsoft.dynamics.nav.internal.connection.DynamicsNavConnection;
import com.mulesoft.connectors.microsoft.dynamics.nav.internal.error.DynamicsNavErrorType;
import com.mulesoft.connectors.microsoft.dynamics.nav.internal.exception.DynamicsNavAuthenticationException;
import com.mulesoft.connectors.microsoft.dynamics.nav.internal.exception.DynamicsNavConnectionException;
import com.mulesoft.connectors.microsoft.dynamics.nav.internal.utils.ConnectorUtils;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.ws.rs.core.UriBuilder;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;

public class DynamicsNavPagingProvider
implements PagingProvider<DynamicsNavConnection, Map<String, Object>> {
    private final String query;
    private final String entityName;
    private final int top;
    private final int skip;
    private int fetchSize;
    private int amountFetched;

    public DynamicsNavPagingProvider(String query, int fetchSize) {
        this.query = query;
        this.entityName = ConnectorUtils.substringBefore(query, "?");
        this.fetchSize = fetchSize;
        String topParam = ConnectorUtils.substringBetween(query, "$top=", "&");
        topParam = topParam == null ? ConnectorUtils.substringAfterLast(query, "$top=") : topParam;
        String skipParam = ConnectorUtils.substringBetween(query, "$skip=", "&");
        skipParam = skipParam == null ? ConnectorUtils.substringAfterLast(query, "$skip=") : skipParam;
        this.top = !topParam.equals("") ? Integer.valueOf(topParam) : 0;
        this.skip = !skipParam.equals("") ? Integer.valueOf(skipParam) : 0;
    }

    public List<Map<String, Object>> getPage(DynamicsNavConnection connection) {
        int n = this.fetchSize = this.top != 0 && this.top - this.amountFetched < this.fetchSize ? this.top - this.amountFetched : this.fetchSize;
        if (this.fetchSize <= 0) {
            return new ArrayList<Map<String, Object>>();
        }
        String queryParams = ConnectorUtils.substringAfter(this.query, "?");
        URI uri = UriBuilder.fromUri((String)this.entityName).replaceQuery(queryParams).replaceQueryParam("$skip", new Object[]{this.skip + this.amountFetched}).replaceQueryParam("$top", new Object[]{this.fetchSize}).build(new Object[0]);
        this.amountFetched += this.fetchSize;
        queryParams = uri.getQuery();
        try {
            return connection.getoDataClient().executeODataQuery(this.entityName, queryParams);
        }
        catch (DynamicsNavAuthenticationException ex) {
            throw new ModuleException((ErrorTypeDefinition)DynamicsNavErrorType.INCORRECT_CREDENTIALS, (Throwable)ex);
        }
        catch (DynamicsNavConnectionException ex) {
            throw new ModuleException((ErrorTypeDefinition)DynamicsNavErrorType.CONNECTIVITY, (Throwable)ex);
        }
        catch (Exception ex) {
            throw new ModuleException((ErrorTypeDefinition)DynamicsNavErrorType.UNKNOWN, (Throwable)ex);
        }
    }

    public Optional<Integer> getTotalResults(DynamicsNavConnection connection) {
        return Optional.empty();
    }

    public void close(DynamicsNavConnection connection) throws MuleException {
    }
}

