/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.microsoft.dynamics.nav.internal.query;

import com.mulesoft.connectors.microsoft.dynamics.nav.internal.utils.ConnectorUtils;
import java.util.ArrayList;
import java.util.List;
import org.mule.runtime.extension.api.dsql.Direction;
import org.mule.runtime.extension.api.dsql.EntityType;
import org.mule.runtime.extension.api.dsql.Field;
import org.mule.runtime.extension.api.dsql.OperatorTranslator;
import org.mule.runtime.extension.api.dsql.QueryTranslator;
import org.mule.runtime.extension.api.dsql.Value;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class DsqlToNativeQueryTranslator
implements QueryTranslator {
    private String service;
    private UriComponentsBuilder uriComponentsBuilder;
    private StringBuilder filterStringBuilder = new StringBuilder();

    public DsqlToNativeQueryTranslator() {
        this.uriComponentsBuilder = UriComponentsBuilder.fromPath((String)"{service}");
    }

    public OperatorTranslator operatorTranslator() {
        return new DsqlToNativeOperatorTranslator();
    }

    public void translateFields(List<Field> fields) {
        if (!fields.isEmpty()) {
            ArrayList<String> names = new ArrayList<String>();
            for (Field field : fields) {
                names.add(field.getName());
            }
            String select = ConnectorUtils.join(names, ",");
            this.uriComponentsBuilder.queryParam("$select", new Object[]{select});
        }
    }

    public void translateTypes(EntityType types) {
        this.service = types.getName();
    }

    public void translateOrderByFields(List<Field> orderByFields, Direction direction) {
        if (!orderByFields.isEmpty()) {
            ArrayList<String> fieldNames = new ArrayList<String>();
            for (Field field : orderByFields) {
                String fieldName = field.getName();
                String orderedFieldName = direction.equals((Object)Direction.ASC) ? fieldName + " asc" : fieldName + " desc";
                fieldNames.add(orderedFieldName);
            }
            String orderedBy = ConnectorUtils.join(fieldNames, ",");
            this.uriComponentsBuilder.queryParam("$orderby", new Object[]{orderedBy});
        }
    }

    public void translateAnd() {
        this.filterStringBuilder.append(" and ");
    }

    public void translateOR() {
        this.filterStringBuilder.append(" or ");
    }

    public void translateComparison(String operator, Field field, Value<?> value) {
        OperatorTranslator operatorVisitor = this.operatorTranslator();
        String fieldName = field.getName();
        fieldName = fieldName.replace(".", "/");
        if (operatorVisitor.likeOperator().equalsIgnoreCase(operator)) {
            String valueString = value.toString();
            if (!valueString.startsWith("'")) {
                valueString = "'" + valueString;
            }
            if (!valueString.endsWith("'")) {
                valueString = valueString + "'";
            }
            this.filterStringBuilder.append(operator).append("(").append(valueString).append(",").append(fieldName).append(")");
        } else {
            this.filterStringBuilder.append(fieldName).append(operator).append(value.toString());
        }
    }

    public void translateBeginExpression() {
    }

    public void translateInitPrecedence() {
        this.filterStringBuilder.append("(");
    }

    public void translateEndPrecedence() {
        this.filterStringBuilder.append(")");
    }

    public void translateLimit(int limit) {
        this.uriComponentsBuilder.queryParam("$top", new Object[]{limit});
    }

    public void translateOffset(int offset) {
        this.uriComponentsBuilder.queryParam("$skip", new Object[]{offset});
    }

    public String getTranslation() {
        if (this.filterStringBuilder.length() > 0) {
            this.uriComponentsBuilder.queryParam("$filter", new Object[]{this.filterStringBuilder.toString()});
        }
        UriComponents odataQuery = this.uriComponentsBuilder.build().expand(new Object[]{this.service});
        return odataQuery.toUriString();
    }

    public class DsqlToNativeOperatorTranslator
    implements OperatorTranslator {
        public String lessOperator() {
            return " lt ";
        }

        public String greaterOperator() {
            return " gt ";
        }

        public String lessOrEqualsOperator() {
            return " le ";
        }

        public String equalsOperator() {
            return " eq ";
        }

        public String notEqualsOperator() {
            return " ne ";
        }

        public String greaterOrEqualsOperator() {
            return " ge ";
        }

        public String likeOperator() {
            return "substringof";
        }
    }
}

