/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.microsoft.dynamics.nav.internal.service.connection.soap;

import com.mulesoft.connectors.microsoft.dynamics.nav.internal.connection.Credentials;
import com.mulesoft.connectors.microsoft.dynamics.nav.internal.exception.DynamicsNavAuthenticationException;
import com.mulesoft.connectors.microsoft.dynamics.nav.internal.exception.DynamicsNavConnectionException;
import com.mulesoft.connectors.microsoft.dynamics.nav.internal.exception.DynamicsNavException;
import com.mulesoft.connectors.microsoft.dynamics.nav.internal.service.connection.HttpClientService;
import com.mulesoft.connectors.microsoft.dynamics.nav.internal.service.connection.soap.client.DynamicsNavSoapClient;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.ws.rs.core.UriBuilder;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.binding.soap.interceptor.Soap11FaultInInterceptor;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.jaxws.endpoint.dynamic.JaxWsDynamicClientFactory;
import org.apache.cxf.transport.http.HTTPConduit;
import org.mule.runtime.core.api.util.ExceptionUtils;
import org.mule.runtime.core.api.util.FileUtils;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;

public class DynamicsNavSoapClientProvider {
    private static final String PAGE = "Page";
    private static final String CODEUNIT = "Codeunit";
    private final Credentials credentials;
    private final HttpClientService httpClientService;
    private Map<String, DynamicsNavSoapClient> wsClients = new HashMap<String, DynamicsNavSoapClient>();
    private static final String SYSTEM_SERVICE_INPUT_CLASS = "schemas.dynamics.microsoft.nav.system.Companies";

    public DynamicsNavSoapClientProvider(HttpClientService httpClientService, Credentials credentials) {
        this.credentials = credentials;
        this.httpClientService = httpClientService;
    }

    public synchronized DynamicsNavSoapClient getPageClient(String serviceName) {
        String key = PAGE + serviceName;
        if (!this.wsClients.containsKey(key)) {
            this.wsClients.put(key, new DynamicsNavSoapClient(this.createPageClient(serviceName)));
        }
        return this.wsClients.get(key);
    }

    public synchronized DynamicsNavSoapClient getCodeUnitClient(String serviceName) {
        String key = CODEUNIT + serviceName;
        if (!this.wsClients.containsKey(key)) {
            this.wsClients.put(key, new DynamicsNavSoapClient(this.createCodeunitClient(serviceName)));
        }
        return this.wsClients.get(key);
    }

    private Client createPageClient(String serviceName) {
        return this.createSoapClient(serviceName, PAGE);
    }

    private Client createCodeunitClient(String serviceName) {
        return this.createSoapClient(serviceName, CODEUNIT);
    }

    private Client createSoapClient(String serviceName, String serviceType) {
        String uri = UriBuilder.fromUri((String)this.credentials.getSoapUrl()).path(this.credentials.getCompanyName()).path(serviceType).path(serviceName).build(new Object[0]).toString();
        File file = this.downloadWsdlToFile(uri);
        Bus bus = BusFactory.getDefaultBus();
        Client wsClient = JaxWsDynamicClientFactory.newInstance((Bus)bus).createClient(file.getAbsolutePath());
        this.configureSoapClient(wsClient);
        return wsClient;
    }

    private void configureSoapClient(Client wsClient) {
        HTTPConduit asyncHTTPConduit = (HTTPConduit)wsClient.getConduit();
        asyncHTTPConduit.getClient().setAllowChunking(false);
        asyncHTTPConduit.getClient().setAutoRedirect(true);
        asyncHTTPConduit.setAuthorization(this.createAuthorization());
        if (this.credentials.isDisableCnCheck()) {
            TLSClientParameters params = new TLSClientParameters();
            params.setDisableCNCheck(true);
            params.setTrustManagers(new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            }});
            asyncHTTPConduit.setTlsClientParameters(params);
        }
    }

    private AuthorizationPolicy createAuthorization() {
        AuthorizationPolicy policy = new AuthorizationPolicy();
        policy.setUserName(this.credentials.getAuthUsername());
        policy.setPassword(this.credentials.getAuthPassword());
        return policy;
    }

    private File downloadWsdlToFile(String url) {
        try {
            HttpResponse httpResponse = this.httpClientService.sendGet(url);
            this.checkStatusCode(httpResponse, url);
            File tmpFile = File.createTempFile("nav", "");
            tmpFile.deleteOnExit();
            FileUtils.copyStreamToFile((InputStream)httpResponse.getEntity().getContent(), (File)tmpFile);
            return tmpFile;
        }
        catch (IOException | TimeoutException e) {
            throw new DynamicsNavException("Error getting wsdl from " + url, e);
        }
    }

    private void checkStatusCode(HttpResponse httpResponse, String url) {
        int statusCode = httpResponse.getStatusCode();
        if (statusCode >= HttpConstants.HttpStatus.BAD_REQUEST.getStatusCode()) {
            this.throwException(httpResponse, statusCode, url);
        }
    }

    private void throwException(HttpResponse response, int statusCode, String url) throws DynamicsNavAuthenticationException {
        HttpConstants.HttpStatus httpStatus = HttpConstants.HttpStatus.getStatusByCode((int)statusCode);
        if (httpStatus != null) {
            switch (httpStatus) {
                case UNAUTHORIZED: 
                case FORBIDDEN: {
                    throw new DynamicsNavAuthenticationException("Access unauthorized. " + this.extractFaultString(response));
                }
                case INTERNAL_SERVER_ERROR: {
                    throw new DynamicsNavException("Error getting wsdl: " + this.extractFaultString(response));
                }
            }
            throw new DynamicsNavException("Error getting wsdl with status code: " + statusCode + " from " + url);
        }
    }

    private String extractFaultString(HttpResponse response) {
        InputStream inputStream = response.getEntity().getContent();
        XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
        xmlInputFactory.setProperty("javax.xml.stream.supportDTD", false);
        xmlInputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        try {
            XMLStreamReader streamReader = xmlInputFactory.createXMLStreamReader(inputStream);
            return Soap11FaultInInterceptor.unmarshalFault(null, (XMLStreamReader)streamReader).getReason();
        }
        catch (XMLStreamException e) {
            throw new DynamicsNavException("Failed to extract fault String from response", e);
        }
    }

    public void testConnectivity() throws DynamicsNavConnectionException {
        try {
            URL soap = new URL(this.credentials.getSoapUrl());
        }
        catch (MalformedURLException e) {
            throw new DynamicsNavConnectionException("Soap URL is not a valid URL");
        }
        try {
            Client wsClient = this.createSoapClient("SystemService", "");
            Object instance = Thread.currentThread().getContextClassLoader().loadClass(SYSTEM_SERVICE_INPUT_CLASS).newInstance();
            wsClient.invokeWrapped("Companies", new Object[]{instance});
        }
        catch (DynamicsNavAuthenticationException e) {
            throw new DynamicsNavConnectionException(e.getMessage(), e);
        }
        catch (DynamicsNavException e) {
            throw this.buildConnectionException(e);
        }
        catch (Exception e) {
            throw new DynamicsNavConnectionException(e.getMessage(), e);
        }
    }

    private DynamicsNavConnectionException buildConnectionException(DynamicsNavException e) {
        DynamicsNavConnectionException exception = ExceptionUtils.containsType((Throwable)e, UnknownHostException.class) ? new DynamicsNavConnectionException("Unknown host", e) : (ExceptionUtils.containsType((Throwable)e, SSLHandshakeException.class) ? new DynamicsNavConnectionException("Error with SSL Certificate", e) : new DynamicsNavConnectionException("Error trying to connect", e));
        return exception;
    }

    public HttpClientService getHttpClientService() {
        return this.httpClientService;
    }
}

