/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.microsoft.dynamics.nav.internal.utils;

import java.util.Iterator;
import java.util.Objects;
import org.mule.metadata.api.builder.ObjectTypeBuilder;

public class ConnectorUtils {
    private static final String EMPTY = "";
    private static final String KEY_SEPARATOR = "||";

    private ConnectorUtils() {
    }

    public static boolean isStringNullOrEmpty(String text) {
        return text == null || text.length() == 0;
    }

    public static String substringBefore(String str, String separator) {
        if (!str.isEmpty() && separator != null) {
            if (ConnectorUtils.isEmpty(separator)) {
                return EMPTY;
            }
            int pos = str.indexOf(separator);
            return pos == -1 ? str : str.substring(0, pos);
        }
        return str;
    }

    public static String substringBetween(String str, String open, String close) {
        int end;
        if (str == null || open == null || close == null) {
            return null;
        }
        int start = str.indexOf(open);
        if (start != -1 && (end = str.indexOf(close, start + open.length())) != -1) {
            return str.substring(start + open.length(), end);
        }
        return null;
    }

    public static String substringAfter(String str, String separator) {
        if (ConnectorUtils.isEmpty(str)) {
            return str;
        }
        if (separator == null) {
            return EMPTY;
        }
        int pos = str.indexOf(separator);
        if (pos == -1) {
            return EMPTY;
        }
        return str.substring(pos + separator.length());
    }

    public static boolean isBlank(CharSequence cs) {
        int strLen;
        if (cs == null || (strLen = cs.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(String str) {
        return !ConnectorUtils.isBlank(str);
    }

    public static String join(Iterable<?> iterable, String separator) {
        if (iterable == null) {
            return null;
        }
        return ConnectorUtils.join(iterable.iterator(), separator);
    }

    public static String removeStart(String str, String remove) {
        if (ConnectorUtils.isEmpty(str) || ConnectorUtils.isEmpty(remove)) {
            return str;
        }
        if (str.startsWith(remove)) {
            return str.substring(remove.length());
        }
        return str;
    }

    public static String removeEnd(String str, String remove) {
        if (ConnectorUtils.isEmpty(str) || ConnectorUtils.isEmpty(remove)) {
            return str;
        }
        if (str.endsWith(remove)) {
            return str.substring(0, str.length() - remove.length());
        }
        return str;
    }

    public static String join(Iterator<?> iterator, String separator) {
        if (iterator == null) {
            return null;
        }
        if (!iterator.hasNext()) {
            return EMPTY;
        }
        Object first = iterator.next();
        if (!iterator.hasNext()) {
            return Objects.toString(first, EMPTY);
        }
        StringBuilder buf = new StringBuilder(256);
        if (first != null) {
            buf.append(first);
        }
        while (iterator.hasNext()) {
            Object obj;
            if (separator != null) {
                buf.append(separator);
            }
            if ((obj = iterator.next()) == null) continue;
            buf.append(obj);
        }
        return buf.toString();
    }

    public static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public static boolean isNotEmpty(CharSequence cs) {
        return !ConnectorUtils.isEmpty(cs);
    }

    public static String substringAfterLast(String str, String separator) {
        if (ConnectorUtils.isEmpty(str)) {
            return str;
        }
        if (ConnectorUtils.isEmpty(separator)) {
            return EMPTY;
        }
        int pos = str.lastIndexOf(separator);
        if (pos == -1 || pos == str.length() - separator.length()) {
            return EMPTY;
        }
        return str.substring(pos + separator.length());
    }

    public static String extractServiceFromMetaDataKeyId(String keyId) {
        return ConnectorUtils.substringBefore(keyId, KEY_SEPARATOR);
    }

    public static String extractOperationFromMetaDataKeyId(String keyId) {
        return ConnectorUtils.substringAfter(keyId, KEY_SEPARATOR);
    }

    public static void addSimpleField(ObjectTypeBuilder objectTypeBuilder, String attributeType, String logicalName) {
        switch (attributeType) {
            case "String": 
            case "Edm.String": 
            case "EntityName": 
            case "Memo": 
            case "Uniqueidentifier": 
            case "Edm.Guid": {
                objectTypeBuilder.addField().key(logicalName).label(logicalName).value().stringType().id(logicalName);
                break;
            }
            case "Double": 
            case "Integer": 
            case "Decimal": 
            case "BigInt": 
            case "Money": 
            case "Int32": 
            case "Int64": 
            case "Edm.Decimal": 
            case "Edm.Double": 
            case "Edm.Int32": 
            case "Edm.Int64": {
                objectTypeBuilder.addField().key(logicalName).label(logicalName).value().numberType().id(logicalName);
                break;
            }
            case "DateTime": 
            case "Edm.DateTime": 
            case "Edm.DateTimeOffset": {
                objectTypeBuilder.addField().key(logicalName).label(logicalName).value().dateTimeType().id(logicalName);
                break;
            }
            case "Boolean": 
            case "Edm.Boolean": {
                objectTypeBuilder.addField().key(logicalName).label(logicalName).value().booleanType().id(logicalName);
                break;
            }
            case "List": {
                objectTypeBuilder.addField().key(logicalName).label(logicalName).value().arrayType().of().stringType().id(logicalName);
                break;
            }
            default: {
                objectTypeBuilder.addField().key(logicalName).label(logicalName).value().objectType().id(logicalName);
            }
        }
    }
}

