/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.microsoft.dynamics.nav.internal.datasense;

import com.mulesoft.connectors.microsoft.dynamics.nav.internal.connection.DynamicsNavConnection;
import com.mulesoft.connectors.microsoft.dynamics.nav.internal.service.connection.HttpClientService;
import com.mulesoft.connectors.microsoft.dynamics.nav.internal.service.connection.odata.EdmReader;
import com.mulesoft.connectors.microsoft.dynamics.nav.internal.utils.ConnectorUtils;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmTyped;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeyBuilder;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.metadata.resolving.OutputTypeResolver;
import org.mule.runtime.api.metadata.resolving.QueryEntityResolver;

public class ODataQueryEntityResolver
implements QueryEntityResolver,
OutputTypeResolver<String> {
    private static final String SEPARATOR = ",";
    private static final String QUESTION_MARK = "?";
    private static final String SELECT = "$select=";
    private static final String AND = "&";
    private EdmReader edmReader;
    private DynamicsNavConnection dynamicsNavConnection = null;

    public String getResolverName() {
        return "OdataQueryResolver";
    }

    public Set<MetadataKey> getEntityKeys(MetadataContext metadataContext) throws MetadataResolvingException, ConnectionException {
        this.dynamicsNavConnection = this.extractConnection(metadataContext);
        List<String> entityNames = this.getEdmReader().getEntityNames();
        return entityNames.stream().map(entity -> MetadataKeyBuilder.newKey((String)entity).withDisplayName(entity).build()).collect(Collectors.toSet());
    }

    public MetadataType getEntityMetadata(MetadataContext metadataContext, String entityName) throws MetadataResolvingException, ConnectionException {
        this.dynamicsNavConnection = this.extractConnection(metadataContext);
        ObjectTypeBuilder objectTypeBuilder = new ObjectTypeBuilder(MetadataFormat.JAVA);
        try {
            for (EdmTyped property : this.getEdmReader().getEntityProperties(entityName)) {
                ConnectorUtils.addSimpleField(objectTypeBuilder, property.getType().toString(), property.getName());
            }
        }
        catch (EdmException e) {
            throw new MetadataResolvingException("Unable to fetch metadata for entity", FailureCode.UNKNOWN);
        }
        return objectTypeBuilder.build();
    }

    public String getCategoryName() {
        return "ResolverCategory";
    }

    private EdmReader getEdmReader() throws ConnectionException {
        if (this.edmReader == null) {
            URL odataUrl;
            try {
                odataUrl = new URL(this.dynamicsNavConnection.getCredentials().getOdataUrl());
            }
            catch (Exception e) {
                throw new ConnectionException("Could not create url from " + this.dynamicsNavConnection.getCredentials().getOdataUrl());
            }
            HttpClientService httpClientService = this.dynamicsNavConnection.getoDataClient().getHttpClientService();
            this.edmReader = new EdmReader(httpClientService, odataUrl);
        }
        return this.edmReader;
    }

    private DynamicsNavConnection extractConnection(MetadataContext context) throws ConnectionException, MetadataResolvingException {
        Optional connection = context.getConnection();
        return (DynamicsNavConnection)connection.orElseThrow(() -> new MetadataResolvingException("No connections avaible", FailureCode.UNKNOWN));
    }

    public MetadataType getOutputType(MetadataContext context, String query) throws MetadataResolvingException, ConnectionException {
        this.dynamicsNavConnection = this.extractConnection(context);
        String key = ConnectorUtils.substringBefore(query, QUESTION_MARK);
        List<EdmTyped> returnTypes = this.getEdmReturnTypes(key, this.getFieldNames(query));
        ObjectTypeBuilder objectTypeBuilder = context.getTypeBuilder().objectType();
        this.addFieldsToBuilder(objectTypeBuilder, returnTypes);
        return objectTypeBuilder.build();
    }

    private void addFieldsToBuilder(ObjectTypeBuilder objectTypeBuilder, List<EdmTyped> returnTypes) throws MetadataResolvingException {
        try {
            for (EdmTyped edmTyped : returnTypes) {
                ConnectorUtils.addSimpleField(objectTypeBuilder, edmTyped.getType().toString(), edmTyped.getName());
            }
        }
        catch (EdmException e) {
            throw new MetadataResolvingException("Could not fetch metadata", FailureCode.UNKNOWN);
        }
    }

    private List<String> getFieldNames(String query) {
        String queryParams = ConnectorUtils.substringAfter(query, SELECT);
        String fields = ConnectorUtils.substringBefore(queryParams, AND);
        return Arrays.asList(fields.split(SEPARATOR));
    }

    private List<EdmTyped> getEdmReturnTypes(String key, List<String> fieldNames) throws MetadataResolvingException {
        List<EdmTyped> returnTypes;
        try {
            returnTypes = this.getEdmReader().getEntityProperties(key).stream().filter(returnType -> this.checkIfListContains(fieldNames, (EdmTyped)returnType)).collect(Collectors.toList());
        }
        catch (Throwable e) {
            throw new MetadataResolvingException("Could not fetch metadata", FailureCode.UNKNOWN);
        }
        return returnTypes;
    }

    private boolean checkIfListContains(List<String> fieldNames, EdmTyped returnType) {
        try {
            return fieldNames.contains(returnType.getName());
        }
        catch (EdmException e) {
            throw new RuntimeException("Could not fetch metadata", e);
        }
    }
}

