/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.microsoft.dynamics.nav.internal.service.connection.soap.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.exc.UnrecognizedPropertyException;
import com.google.common.collect.ImmutableMap;
import com.mulesoft.connectors.microsoft.dynamics.nav.internal.exception.DynamicsNavException;
import com.mulesoft.connectors.microsoft.dynamics.nav.internal.service.connection.soap.XmlElementNameNamingStrategy;
import com.mulesoft.connectors.microsoft.dynamics.nav.internal.service.connection.soap.XmlTypeField;
import com.mulesoft.connectors.microsoft.dynamics.nav.internal.service.connection.soap.client.utils.SoapClientUtils;
import com.mulesoft.connectors.microsoft.dynamics.nav.internal.service.utils.BeanUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.MessagePartInfo;

public class DynamicsNavSoapClient {
    private Client wsClient;
    private ObjectMapper objectMapper;

    public DynamicsNavSoapClient(Client wsClient) {
        this.wsClient = wsClient;
        this.objectMapper = new ObjectMapper();
        this.objectMapper.setPropertyNamingStrategy((PropertyNamingStrategy)new XmlElementNameNamingStrategy());
    }

    public Object executeSoapOperation(String operation, Map<String, Object> entity) {
        try {
            Object input = this.convertToInput(entity, this.getOperationInputType(operation));
            Object[] response = this.wsClient.invokeWrapped(operation, new Object[]{input});
            return response != null && response.length > 0 ? this.convertFromOutput(response[0]) : null;
        }
        catch (DynamicsNavException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DynamicsNavException(e.getMessage(), e);
        }
    }

    private Object convertToInput(Map<String, Object> entity, Class type) {
        List<XmlTypeField> fields = BeanUtils.getXmlTypeFields(type);
        ImmutableMap input = entity;
        if (fields.size() == 1 && BeanUtils.isListOrPojo(fields.get(0).getType()).equals("Pojo")) {
            input = ImmutableMap.of((Object)fields.get(0).getName(), entity);
        }
        try {
            return this.objectMapper.convertValue(input, type);
        }
        catch (IllegalArgumentException e) {
            UnrecognizedPropertyException upe = SoapClientUtils.getDeepestOccurenceOfType(e, UnrecognizedPropertyException.class);
            throw upe != null ? new DynamicsNavException(this.buildExceptionMessage(upe), e) : e;
        }
    }

    public List<String> getOperationsNames() {
        ArrayList<String> operationsNames = new ArrayList<String>();
        Endpoint endpoint = this.wsClient.getEndpoint();
        for (BindingOperationInfo operation : endpoint.getBinding().getBindingInfo().getOperations()) {
            operationsNames.add(operation.getName().getLocalPart());
        }
        return operationsNames;
    }

    public Class getOperationInputType(String operationName) {
        return ((MessagePartInfo)this.getBindingOperationInfo(operationName).getInput().getMessageParts().get(0)).getTypeClass();
    }

    public Class getOperationOutputType(String operationName) {
        return ((MessagePartInfo)this.getBindingOperationInfo(operationName).getOutput().getMessageParts().get(0)).getTypeClass();
    }

    private String buildExceptionMessage(UnrecognizedPropertyException exception) {
        String entityName = exception.getReferringClass().getSimpleName();
        Collection knownProperties = exception.getKnownPropertyIds();
        String unknownProperty = exception.getPropertyName();
        return String.format("The NAV Type '" + entityName + "' does not contain a property called '" + unknownProperty + "'. Known properties are: " + String.valueOf(knownProperties), new Object[0]);
    }

    private Object convertFromOutput(Object object) {
        return BeanUtils.isListOrPojo(object.getClass()).equals("Pojo") ? this.objectMapper.convertValue(object, Map.class) : object;
    }

    private BindingOperationInfo getBindingOperationInfo(String operationName) {
        Endpoint endpoint = this.wsClient.getEndpoint();
        QName qName = new QName(endpoint.getService().getName().getNamespaceURI(), operationName);
        BindingOperationInfo operationInfo = endpoint.getBinding().getBindingInfo().getOperation(qName);
        if (operationInfo == null) {
            throw new DynamicsNavException("Selected operation does not exist in current Service");
        }
        return operationInfo;
    }
}

