/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.microsoft.dynamics.nav.internal.connection.provider;

import com.mulesoft.connectors.microsoft.dynamics.nav.internal.connection.Credentials;
import com.mulesoft.connectors.microsoft.dynamics.nav.internal.connection.DynamicsNavConnection;
import com.mulesoft.connectors.microsoft.dynamics.nav.internal.connection.NtlmCredentials;
import com.mulesoft.connectors.microsoft.dynamics.nav.internal.service.connection.service.DynamicsNavConnectionService;
import javax.inject.Inject;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.connection.PoolingConnectionProvider;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Password;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.client.auth.HttpAuthentication;

@Alias(value="ntlm")
public class NtlmConnectionProvider
implements PoolingConnectionProvider<DynamicsNavConnection> {
    @Parameter
    @Optional
    @Summary(value="Domain of the Dynamics NAV instance")
    String domain;
    @Parameter
    @Summary(value="The Windows username to connect to Dynamics NAV")
    String username;
    @Parameter
    @Summary(value="The Windows password to connect to Dynamics NAV")
    @Password
    String password;
    @Parameter
    @Summary(value="Base URL where the SOAP services are exposed in the form _https://<Server>:<WebServicePort>/<ServerInstance>/WS_. Example: https://hostname:7047/DynamicsNAV90/WS")
    String soapUrl;
    @Parameter
    @Summary(value="Base URL where the OData services are exposed in the form _https://<Server>:<WebServicePort>/<ServerInstance>/OData_. Example: https://hostname:7048/DynamicsNAV90/OData.")
    String odataUrl;
    @Parameter
    @Optional
    @Summary(value="Dynamics NAV Company to which connect. In case the field is left blank, the default configured one is used.")
    String companyName;
    @Parameter
    @Optional
    @DisplayName(value="Disable SSL certificate validation")
    boolean disableCnCheck;
    @Inject
    private HttpService httpService;

    public DynamicsNavConnection connect() throws ConnectionException {
        DynamicsNavConnectionService connectionService = new DynamicsNavConnectionService();
        NtlmCredentials credentials = new NtlmCredentials(this.odataUrl, this.soapUrl, this.companyName, this.username, this.password, this.domain, this.disableCnCheck);
        HttpAuthentication.HttpNtlmAuthentication httpAuthentication = HttpAuthentication.ntlm((String)credentials.getUsername(), (String)((Credentials)credentials).getAuthPassword()).domain(this.domain).workstation("").build();
        return connectionService.doConnect(credentials, this.httpService, (HttpAuthentication)httpAuthentication);
    }

    public void disconnect(DynamicsNavConnection dynamicsNavConnection) {
        dynamicsNavConnection.disconnect();
    }

    public ConnectionValidationResult validate(DynamicsNavConnection dynamicsNavConnection) {
        try {
            dynamicsNavConnection.validate();
            return ConnectionValidationResult.success();
        }
        catch (Exception e) {
            return ConnectionValidationResult.failure((String)e.getMessage(), (Exception)e);
        }
    }
}

