/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.microsoft.dynamics.nav.internal.datasense;

import com.mulesoft.connectors.microsoft.dynamics.nav.internal.connection.DynamicsNavConnection;
import com.mulesoft.connectors.microsoft.dynamics.nav.internal.service.connection.HttpClientService;
import com.mulesoft.connectors.microsoft.dynamics.nav.internal.service.connection.soap.XmlTypeField;
import com.mulesoft.connectors.microsoft.dynamics.nav.internal.service.utils.BeanUtils;
import com.mulesoft.connectors.microsoft.dynamics.nav.internal.soap.SOAPServiceDiscoveryClient;
import com.mulesoft.connectors.microsoft.dynamics.nav.internal.utils.ConnectorUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SOAPServicesMetadata {
    private final Logger logger = LoggerFactory.getLogger(SOAPServicesMetadata.class);
    private SOAPServiceDiscoveryClient soapServiceDiscoveryClient;

    SOAPServicesMetadata() {
    }

    SOAPServiceDiscoveryClient getDiscoveryClient(DynamicsNavConnection connection) throws MetadataResolvingException {
        if (this.soapServiceDiscoveryClient == null) {
            try {
                HttpClientService httpClientService = connection.getSoapClientProvider().getHttpClientService();
                URL url = new URL(connection.getCredentials().getSoapUrl());
                this.soapServiceDiscoveryClient = new SOAPServiceDiscoveryClient(httpClientService, url);
            }
            catch (MalformedURLException e) {
                this.logger.error(e.getMessage());
                throw new MetadataResolvingException(e.getMessage(), FailureCode.CONNECTION_FAILURE);
            }
        }
        return this.soapServiceDiscoveryClient;
    }

    private void addFieldsToDynamicObject(List<XmlTypeField> fields, ObjectTypeBuilder dynamicObject) {
        for (XmlTypeField field : fields) {
            if (BeanUtils.isListOrPojo(field.getType()).equals("Pojo")) {
                dynamicObject.addField().key(field.getName()).label(field.getName()).value().objectType().id(field.getName());
                this.addFieldsToDynamicObject(BeanUtils.getXmlTypeFields(field.getType()), dynamicObject);
                continue;
            }
            String name = field.getType().getSimpleName();
            ConnectorUtils.addSimpleField(dynamicObject, name, field.getName());
        }
    }

    MetadataType getMetadataType(ObjectTypeBuilder builder, Class listOrPojo, List<XmlTypeField> xmlTypeFields) {
        ObjectType metadata;
        if (BeanUtils.isListOrPojo(listOrPojo).equals("Pojo")) {
            this.addFieldsToDynamicObject(xmlTypeFields, builder);
            metadata = builder.build();
        } else {
            ConnectorUtils.addSimpleField(builder, listOrPojo.getTypeName(), listOrPojo.getName());
            metadata = builder.build();
        }
        return metadata;
    }

    Class getOutputFieldType(Class type) {
        if (type.getDeclaredFields().length > 0) {
            type = type.getDeclaredFields()[0].getType();
        }
        return type;
    }
}

