/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.microsoft.dynamics.nav.internal.operation;

import com.mulesoft.connectors.microsoft.dynamics.nav.internal.config.DynamicsNavConfiguration;
import com.mulesoft.connectors.microsoft.dynamics.nav.internal.connection.DynamicsNavConnection;
import com.mulesoft.connectors.microsoft.dynamics.nav.internal.datasense.CodeUnitMetadataResolver;
import com.mulesoft.connectors.microsoft.dynamics.nav.internal.datasense.ODataQueryEntityResolver;
import com.mulesoft.connectors.microsoft.dynamics.nav.internal.datasense.PageServiceMetadataResolver;
import com.mulesoft.connectors.microsoft.dynamics.nav.internal.error.DynamicsNavErrorType;
import com.mulesoft.connectors.microsoft.dynamics.nav.internal.error.DynamicsNavErrorTypeProvider;
import com.mulesoft.connectors.microsoft.dynamics.nav.internal.exception.DynamicsNavAuthenticationException;
import com.mulesoft.connectors.microsoft.dynamics.nav.internal.exception.DynamicsNavConnectionException;
import com.mulesoft.connectors.microsoft.dynamics.nav.internal.exception.DynamicsNavException;
import com.mulesoft.connectors.microsoft.dynamics.nav.internal.paging.DynamicsNavPagingProvider;
import com.mulesoft.connectors.microsoft.dynamics.nav.internal.query.DsqlToNativeQueryTranslator;
import com.mulesoft.connectors.microsoft.dynamics.nav.internal.service.DynamicsNavService;
import com.mulesoft.connectors.microsoft.dynamics.nav.internal.service.DynamicsNavServiceImpl;
import com.mulesoft.connectors.microsoft.dynamics.nav.internal.utils.ServiceOperationParam;
import java.util.Map;
import org.mule.connectors.atlantic.commons.builder.execution.ExecutionBuilder;
import org.mule.connectors.commons.template.config.ConnectorConfig;
import org.mule.connectors.commons.template.connection.ConnectorConnection;
import org.mule.connectors.commons.template.operation.ConnectorOperations;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.MetadataKeyId;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.metadata.TypeResolver;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.Query;
import org.mule.runtime.extension.api.annotation.param.display.Text;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;

@Throws(value={DynamicsNavErrorTypeProvider.class})
public class DynamicsNavOperations
extends ConnectorOperations<DynamicsNavConfiguration, DynamicsNavConnection, DynamicsNavService> {
    public DynamicsNavOperations() {
        super(DynamicsNavServiceImpl::new);
    }

    protected ExecutionBuilder<DynamicsNavService> newExecutionBuilder(DynamicsNavConfiguration config, DynamicsNavConnection connection) {
        return (ExecutionBuilder)((ExecutionBuilder)((ExecutionBuilder)super.newExecutionBuilder((ConnectorConfig)config, (ConnectorConnection)connection).withExceptionHandler(DynamicsNavConnectionException.class, exception -> {
            throw new ModuleException(exception.getMessage(), (ErrorTypeDefinition)DynamicsNavErrorType.CONNECTIVITY);
        })).withExceptionHandler(DynamicsNavAuthenticationException.class, exception -> {
            throw new ModuleException(exception.getMessage(), (ErrorTypeDefinition)DynamicsNavErrorType.INCORRECT_CREDENTIALS);
        })).withExceptionHandler(DynamicsNavException.class, exception -> {
            throw new ModuleException(exception.getMessage(), (ErrorTypeDefinition)DynamicsNavErrorType.UNKNOWN);
        });
    }

    @Query(translator=DsqlToNativeQueryTranslator.class, entityResolver=ODataQueryEntityResolver.class, nativeOutputResolver=ODataQueryEntityResolver.class)
    public PagingProvider<DynamicsNavConnection, Map<String, Object>> odataQuery(@MetadataKeyId @Text String query, Integer fetchSize) {
        return new DynamicsNavPagingProvider(query, fetchSize);
    }

    @OutputResolver(output=PageServiceMetadataResolver.class)
    public Object pageOperation(@Connection DynamicsNavConnection connection, @Config DynamicsNavConfiguration configuration, @MetadataKeyId(value=PageServiceMetadataResolver.class) @ParameterGroup(name="Service/Operation") ServiceOperationParam serviceOperation, @Content @TypeResolver(value=PageServiceMetadataResolver.class) Map<String, Object> entity) {
        return this.newExecutionBuilder(configuration, connection).execute(DynamicsNavService::pageOperation).withParam(entity).withParam((Object)serviceOperation);
    }

    @OutputResolver(output=CodeUnitMetadataResolver.class)
    public Object codeunitOperation(@Connection DynamicsNavConnection connection, @Config DynamicsNavConfiguration configuration, @MetadataKeyId(value=CodeUnitMetadataResolver.class) @ParameterGroup(name="Service/Operation") ServiceOperationParam serviceOperation, @Content @TypeResolver(value=CodeUnitMetadataResolver.class) Map<String, Object> entity) {
        return this.newExecutionBuilder(configuration, connection).execute(DynamicsNavService::executeCodeUnitSoapOperation).withParam((Object)serviceOperation).withParam(entity);
    }
}

