/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.microsoft.dynamics.nav.internal.service.connection;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.auth.HttpAuthentication;
import org.mule.runtime.http.api.domain.entity.EmptyHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.entity.InputStreamHttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;

public class HttpClientService {
    private static final String COOKIE_HEADER = "Cookie";
    private static final int RESPONSE_TIMEOUT = 5000;
    private final HttpClient httpClient;
    private final HttpAuthentication httpAuthentication;

    public HttpClientService(HttpClient httpClient, HttpAuthentication httpAuthentication) {
        this.httpClient = httpClient;
        this.httpAuthentication = httpAuthentication;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse sendPost(String uri, InputStream requestBody, Map<String, String> headers, Map<String, String> cookies) throws IOException, TimeoutException {
        try {
            MultiMap requestHeaders = new MultiMap();
            if (headers != null) {
                requestHeaders.putAll(headers);
            }
            this.setCookies((MultiMap<String, String>)requestHeaders, cookies);
            Object httpEntity = requestBody != null ? new InputStreamHttpEntity(requestBody) : new EmptyHttpEntity();
            this.httpClient.start();
            HttpRequest request = ((HttpRequestBuilder)((HttpRequestBuilder)HttpRequest.builder().method(HttpConstants.Method.POST).uri(uri).entity((HttpEntity)httpEntity)).headers(requestHeaders)).build();
            HttpResponse httpResponse = this.executeMethod(request, this.httpAuthentication);
            return httpResponse;
        }
        finally {
            this.httpClient.stop();
        }
    }

    public HttpResponse sendPost(String uri, InputStream requestBody, Map<String, String> headers) throws IOException, TimeoutException {
        return this.sendPost(uri, requestBody, headers, null);
    }

    public HttpResponse sendPost(String uri, InputStream requestBody) throws IOException, TimeoutException {
        return this.sendGet(uri, requestBody, null, null);
    }

    public HttpResponse sendPost(String uri) throws IOException, TimeoutException {
        return this.sendGet(uri, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse sendGet(String uri, InputStream requestBody, Map<String, String> headers, Map<String, String> cookies) throws IOException, TimeoutException {
        try {
            MultiMap requestHeaders = new MultiMap();
            if (headers != null) {
                requestHeaders.putAll(headers);
            }
            this.setCookies((MultiMap<String, String>)requestHeaders, cookies);
            Object httpEntity = requestBody != null ? new InputStreamHttpEntity(requestBody) : new EmptyHttpEntity();
            this.httpClient.start();
            HttpRequest request = ((HttpRequestBuilder)((HttpRequestBuilder)HttpRequest.builder().method(HttpConstants.Method.GET).uri(uri).entity((HttpEntity)httpEntity)).headers(requestHeaders)).build();
            HttpResponse httpResponse = this.executeMethod(request, this.httpAuthentication);
            return httpResponse;
        }
        finally {
            this.httpClient.stop();
        }
    }

    public HttpResponse sendGet(String uri, InputStream requestBody, Map<String, String> headers) throws IOException, TimeoutException {
        return this.sendGet(uri, requestBody, headers, null);
    }

    public HttpResponse sendGet(String uri, InputStream requestBody) throws IOException, TimeoutException {
        return this.sendGet(uri, requestBody, null, null);
    }

    public HttpResponse sendGet(String uri) throws IOException, TimeoutException {
        return this.sendGet(uri, null, null, null);
    }

    private HttpResponse executeMethod(HttpRequest request, HttpAuthentication httpAuthentication) throws IOException, TimeoutException {
        return this.httpClient.send(request, 5000, true, httpAuthentication);
    }

    private void setCookies(MultiMap<String, String> requestHeaders, Map<String, String> cookies) {
        if (cookies != null) {
            StringBuilder cookiesValue = new StringBuilder();
            for (Map.Entry<String, String> cookie : cookies.entrySet()) {
                cookiesValue.append(String.format("%s=%s", cookie.getKey(), cookie.getValue()));
                cookiesValue.append(";");
            }
            if (cookiesValue.length() != 0) {
                cookiesValue.deleteCharAt(cookiesValue.length() - 1);
                requestHeaders.put((Object)COOKIE_HEADER, (Object)cookiesValue.toString());
            }
        }
    }
}

