/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.microsoft.dynamics.nav.internal.service.connection.odata;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import com.mulesoft.connectors.microsoft.dynamics.nav.internal.connection.Credentials;
import com.mulesoft.connectors.microsoft.dynamics.nav.internal.exception.DynamicsNavAuthenticationException;
import com.mulesoft.connectors.microsoft.dynamics.nav.internal.exception.DynamicsNavConnectionException;
import com.mulesoft.connectors.microsoft.dynamics.nav.internal.exception.DynamicsNavException;
import com.mulesoft.connectors.microsoft.dynamics.nav.internal.service.connection.HttpClientService;
import com.mulesoft.connectors.microsoft.dynamics.nav.internal.service.connection.odata.EdmReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import javax.ws.rs.core.UriBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.olingo.odata2.api.edm.EdmEntitySet;
import org.apache.olingo.odata2.api.ep.EntityProvider;
import org.apache.olingo.odata2.api.ep.EntityProviderReadProperties;
import org.apache.olingo.odata2.api.ep.entry.EntryMetadata;
import org.apache.olingo.odata2.api.ep.entry.ODataEntry;
import org.apache.olingo.odata2.api.ep.feed.ODataFeed;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DynamicsNavODataClient {
    private static final String COMPANY = "Company('%s')";
    private static final Logger logger = LoggerFactory.getLogger(DynamicsNavODataClient.class);
    private final HttpClientService httpClientService;
    private final Credentials credentials;

    public DynamicsNavODataClient(HttpClientService httpClientService, Credentials credentials) {
        this.httpClientService = httpClientService;
        this.credentials = credentials;
    }

    public void testConnectivity() throws DynamicsNavConnectionException {
        try {
            new URL(this.credentials.getOdataUrl());
        }
        catch (MalformedURLException e) {
            throw new DynamicsNavConnectionException("OData URL is not a valid URL");
        }
        try {
            String url = this.credentials.getOdataUrl() + "/$metadata";
            HttpResponse httpResponse = this.httpClientService.sendGet(url);
            this.verifyResponse(httpResponse);
        }
        catch (IOException e) {
            throw new DynamicsNavConnectionException("Error reading OData endpoint", e);
        }
        catch (TimeoutException e) {
            e.printStackTrace();
        }
    }

    public List<Map<String, Object>> executeODataQuery(String entityName, String queryParams) throws DynamicsNavException {
        try {
            ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
            URI uri = UriBuilder.fromUri((String)this.credentials.getOdataUrl()).path(String.format(COMPANY, this.credentials.getCompanyName())).path(entityName).replaceQuery(queryParams).build(new Object[0]);
            HttpResponse httpResponse = this.httpClientService.sendGet(String.valueOf(uri));
            this.verifyResponse(httpResponse);
            EdmReader edmReader = new EdmReader(this.httpClientService, new URL(this.credentials.getOdataUrl()));
            ODataFeed feed = EntityProvider.readFeed((String)"application/atom+xml", (EdmEntitySet)edmReader.getEntitySet(entityName), (InputStream)httpResponse.getEntity().getContent(), (EntityProviderReadProperties)EntityProviderReadProperties.init().build());
            for (ODataEntry entity : feed.getEntries()) {
                Map result = entity.getProperties();
                result.putAll(this.getNavigationPropertyValues(entity.getMetadata()));
                results.add(result);
            }
            return results;
        }
        catch (Exception e) {
            throw new DynamicsNavException("Error executing OData Query", e);
        }
    }

    private void verifyResponse(HttpResponse response) {
        try {
            switch (response.getStatusCode()) {
                case 400: {
                    throw new DynamicsNavException(this.extractResponseText(response));
                }
                case 401: 
                case 403: {
                    throw new DynamicsNavAuthenticationException("Access unauthorized:");
                }
                case 404: {
                    throw new DynamicsNavException("Selected entity does not exist");
                }
                case 500: {
                    throw new DynamicsNavException("Selected entity does not exist");
                }
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new DynamicsNavException("Failed to get the response content or parsing the xml", e);
        }
    }

    private String extractResponseText(HttpResponse response) throws IOException, SAXException, ParserConfigurationException {
        InputStream xml = response.getEntity().getContent();
        DocumentBuilderFactory builder = DocumentBuilderFactory.newInstance();
        builder.setNamespaceAware(true);
        Document document = builder.newDocumentBuilder().parse(xml);
        NodeList nodeList = document.getElementsByTagNameNS("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "message");
        if (nodeList.getLength() > 0) {
            return nodeList.item(0).getTextContent();
        }
        return "";
    }

    private Map<String, String> getNavigationPropertyValues(EntryMetadata metadata) {
        try {
            Field f = metadata.getClass().getDeclaredField("associationUris");
            f.setAccessible(true);
            Map navigationProperties = (Map)f.get(metadata);
            return Maps.transformValues((Map)navigationProperties, (Function)new Function<List<String>, String>(){

                public String apply(List<String> input) {
                    return !input.isEmpty() ? input.get(0) : "";
                }
            });
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            logger.debug("Field 'associationUris' was not found", (Throwable)e);
            return null;
        }
    }

    public HttpClientService getHttpClientService() {
        return this.httpClientService;
    }
}

