/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.microsoft.dynamics.nav.internal.service.connection.odata;

import com.mulesoft.connectors.microsoft.dynamics.nav.internal.exception.DynamicsNavException;
import com.mulesoft.connectors.microsoft.dynamics.nav.internal.service.connection.HttpClientService;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.apache.olingo.odata2.api.edm.Edm;
import org.apache.olingo.odata2.api.edm.EdmEntitySet;
import org.apache.olingo.odata2.api.edm.EdmEntityType;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmTyped;
import org.apache.olingo.odata2.api.ep.EntityProvider;
import org.apache.olingo.odata2.api.ep.EntityProviderException;

public class EdmReader {
    private final HttpClientService httpClientService;
    private final URL baseUrl;
    private Edm edm;

    public EdmReader(HttpClientService httpClientService, URL baseUrl) {
        this.httpClientService = httpClientService;
        this.baseUrl = baseUrl;
    }

    public List<String> getEntityNames() {
        try {
            ArrayList<String> names = new ArrayList<String>();
            for (EdmEntitySet entity : this.getMetadata().getEntitySets()) {
                names.add(entity.getName());
            }
            return names;
        }
        catch (EdmException e) {
            throw new DynamicsNavException("e", e);
        }
    }

    public EdmEntitySet getEntitySet(String entityName) {
        try {
            return this.getMetadata().getDefaultEntityContainer().getEntitySet(entityName);
        }
        catch (EdmException e) {
            throw new DynamicsNavException("Error retrieving metadata", e);
        }
    }

    public List<EdmTyped> getEntityProperties(String entityName) {
        try {
            ArrayList<EdmTyped> properties = new ArrayList<EdmTyped>();
            EdmEntityType entityType = this.getEntitySet(entityName).getEntityType();
            for (String propertyName : entityType.getPropertyNames()) {
                properties.add(entityType.getProperty(propertyName));
            }
            return properties;
        }
        catch (EdmException e) {
            throw new DynamicsNavException("Error retrieving metadata", e);
        }
    }

    private Edm getMetadata() {
        try {
            if (this.edm == null) {
                InputStream inputStream = this.httpClientService.sendGet(this.baseUrl + "/$metadata").getEntity().getContent();
                this.edm = EntityProvider.readMetadata((InputStream)inputStream, (boolean)true);
                inputStream.close();
            }
            return this.edm;
        }
        catch (IOException | TimeoutException | EntityProviderException e) {
            throw new DynamicsNavException("Error retrieving OData metadata", e);
        }
    }
}

