/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.microsoft.dynamics.nav.internal.service.connection.service;

import com.mulesoft.connectors.microsoft.dynamics.nav.internal.connection.Credentials;
import com.mulesoft.connectors.microsoft.dynamics.nav.internal.connection.DynamicsNavConnection;
import com.mulesoft.connectors.microsoft.dynamics.nav.internal.exception.DynamicsNavConnectionException;
import com.mulesoft.connectors.microsoft.dynamics.nav.internal.exception.DynamicsNavException;
import com.mulesoft.connectors.microsoft.dynamics.nav.internal.service.connection.HttpClientService;
import com.mulesoft.connectors.microsoft.dynamics.nav.internal.service.connection.odata.DynamicsNavODataClient;
import com.mulesoft.connectors.microsoft.dynamics.nav.internal.service.connection.soap.DynamicsNavSoapClientProvider;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.lifecycle.CreateException;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.api.tls.TlsContextFactoryBuilder;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.client.auth.HttpAuthentication;

public class DynamicsNavConnectionService {
    private static final String HTTP_CLIENT_CONFIG = "httpClientConfig";
    private static final String HTTPS_PROTOCOLS_SYSTEM_PROPERTY_KEY = "https.protocols";
    private static final String FAILED_TO_CONFIGURE_HTTP_CLIENT_MSG = "Failed configuring the Http Client for Dynamics Nav API";

    public DynamicsNavConnection doConnect(Credentials credentials, HttpService httpService, HttpAuthentication httpAuthentication) throws ConnectionException {
        HttpClient httpClient = this.createHttpClient(httpService, credentials.isDisableCnCheck());
        HttpClientService httpClientService = new HttpClientService(httpClient, httpAuthentication);
        DynamicsNavSoapClientProvider dynamicsNavSoapClientProvider = new DynamicsNavSoapClientProvider(httpClientService, credentials);
        DynamicsNavODataClient dynamicsNavODataClient = new DynamicsNavODataClient(httpClientService, credentials);
        this.testConnectivity(dynamicsNavSoapClientProvider, dynamicsNavODataClient);
        return new DynamicsNavConnection(credentials, dynamicsNavSoapClientProvider, dynamicsNavODataClient);
    }

    private void testConnectivity(DynamicsNavSoapClientProvider dynamicsNavSoapClientProvider, DynamicsNavODataClient dynamicsNavODataClient) throws ConnectionException {
        try {
            dynamicsNavSoapClientProvider.testConnectivity();
            dynamicsNavODataClient.testConnectivity();
        }
        catch (DynamicsNavConnectionException ex) {
            throw new ConnectionException((Throwable)ex);
        }
    }

    private HttpClient createHttpClient(HttpService httpService, boolean enableInsecureTrustStore) {
        HttpClientConfiguration.Builder httpClientConfigurationBuilder = new HttpClientConfiguration.Builder().setName(HTTP_CLIENT_CONFIG);
        this.configureTlsContextFactory(enableInsecureTrustStore, httpClientConfigurationBuilder);
        return httpService.getClientFactory().create(httpClientConfigurationBuilder.build());
    }

    private void configureTlsContextFactory(boolean enableInsecureTrustStore, HttpClientConfiguration.Builder httpClientConfigurationBuilder) {
        TlsContextFactory tlsContextFactory = this.createTlsContextFactory(enableInsecureTrustStore);
        httpClientConfigurationBuilder.setTlsContextFactory(tlsContextFactory);
    }

    private TlsContextFactory createTlsContextFactory(boolean enableInsecureTrustStore) {
        TlsContextFactoryBuilder tlsContextFactoryBuilder = this.createTlsContextFactoryBuilder(enableInsecureTrustStore);
        try {
            return tlsContextFactoryBuilder.build();
        }
        catch (CreateException e) {
            throw new DynamicsNavException(FAILED_TO_CONFIGURE_HTTP_CLIENT_MSG, e);
        }
    }

    private TlsContextFactoryBuilder createTlsContextFactoryBuilder(boolean enableInsecureTrustStore) {
        String httpProtocolsListAsString = System.getProperty(HTTPS_PROTOCOLS_SYSTEM_PROPERTY_KEY);
        TlsContextFactoryBuilder tlsContextFactoryBuilder = TlsContextFactory.builder().insecureTrustStore(enableInsecureTrustStore);
        if (httpProtocolsListAsString != null) {
            tlsContextFactoryBuilder.enabledProtocols(httpProtocolsListAsString);
        }
        return tlsContextFactoryBuilder;
    }
}

