/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.microsoft.dynamics.nav.internal.soap;

import com.mulesoft.connectors.microsoft.dynamics.nav.internal.exception.DynamicsNavException;
import com.mulesoft.connectors.microsoft.dynamics.nav.internal.service.connection.HttpClientService;
import com.mulesoft.connectors.microsoft.dynamics.nav.internal.utils.ConnectorUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeoutException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SOAPServiceDiscoveryClient {
    private static final String PAGE = "/Page/";
    private static final String CODEUNIT = "/Codeunit/";
    private static final String SERVICES = "/services";
    private final HttpClientService httpClientService;
    private final URL soapUrl;

    public SOAPServiceDiscoveryClient(HttpClientService httpClientService, URL soapUrl) {
        this.httpClientService = httpClientService;
        this.soapUrl = soapUrl;
    }

    public List<String> getPageServices() {
        return this.getServices(PAGE);
    }

    public List<String> getCodeunitServices() {
        return this.getServices(CODEUNIT);
    }

    private List<String> getServices(String serviceType) {
        ArrayList<String> servicesNames = new ArrayList<String>();
        try {
            HttpResponse httpResponse = this.httpClientService.sendGet(this.soapUrl + SERVICES);
            InputStream response = httpResponse.getEntity().getContent();
            for (String serviceUrl : this.extractServiceUrls(response)) {
                if (!this.isValidService(serviceType, serviceUrl)) continue;
                servicesNames.add(ConnectorUtils.substringAfterLast(serviceUrl, "/"));
            }
        }
        catch (IOException | TimeoutException e) {
            throw new DynamicsNavException("Failed to extract the given service", e);
        }
        return servicesNames;
    }

    private boolean isValidService(String serviceType, String serviceUrl) throws IOException, TimeoutException {
        return serviceUrl.contains(serviceType) && (serviceType.equals(PAGE) || serviceType.equals(CODEUNIT) && this.isValidWsdl(serviceUrl));
    }

    private List<String> extractServiceUrls(InputStream xml) {
        ArrayList<String> serviceUrls = new ArrayList<String>();
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(xml);
            NodeList nodeList = document.getElementsByTagName("contractRef");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                serviceUrls.add(nodeList.item(i).getAttributes().getNamedItem("ref").getNodeValue());
            }
            return serviceUrls;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new DynamicsNavException("Failed to extract the service urls from the given xml", e);
        }
    }

    private boolean isValidWsdl(String serviceUrl) throws IOException, TimeoutException {
        HttpResponse response = this.httpClientService.sendGet(serviceUrl);
        return response.getStatusCode() < HttpConstants.HttpStatus.MULTIPLE_CHOICES.getStatusCode();
    }
}

