/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.mqtt.internal;

import com.mulesoft.connectors.mqtt.api.LWTMessage;
import com.mulesoft.connectors.mqtt.api.Protocol;
import com.mulesoft.connectors.mqtt.internal.MQTTAuthenticationGroup;
import com.mulesoft.connectors.mqtt.internal.MQTTSession;
import com.mulesoft.connectors.mqtt.internal.ResilienceGroup;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledExecutorService;
import javax.inject.Inject;
import javax.net.SocketFactory;
import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttPingSender;
import org.eclipse.paho.client.mqttv3.TimerPingSender;
import org.mule.runtime.api.connection.CachedConnectionProvider;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.dsl.xml.ParameterDsl;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.RefName;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MQTTConnectionProvider
implements CachedConnectionProvider<MQTTSession> {
    private final Logger LOGGER = LoggerFactory.getLogger(MQTTConnectionProvider.class);
    @RefName
    private String configName;
    @Inject
    private SchedulerService schedulerService;
    @Parameter
    @Optional(defaultValue="TCP")
    private Protocol protocol;
    @Parameter
    @Example(value="0.0.0.0")
    @DisplayName(value="URL")
    private String host;
    @Parameter
    @Optional(defaultValue="1883")
    private String port;
    @Parameter
    @DisplayName(value="Client ID")
    private String clientId;
    @ParameterGroup(name="Authentication")
    private MQTTAuthenticationGroup authentication;
    @ParameterGroup(name="Resilience")
    private ResilienceGroup resilience;
    @Parameter
    @Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(tab="SSL/TLS")
    @DisplayName(value="TLS Context")
    private TlsContextFactory tlsContextFactory;
    @Parameter
    @Optional
    @Placement(tab="LWT")
    @DisplayName(value="Last Will and Testament (LWT)")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    private LWTMessage lastWillAndTestament;
    @Parameter
    @Optional(defaultValue="60")
    @Placement(tab="Advanced")
    private int keepAliveInterval;
    @Parameter
    @Optional(defaultValue="10")
    @Placement(tab="Advanced")
    private int maxInFlight;
    @Parameter
    @Optional(defaultValue="true")
    @Placement(tab="Advanced")
    private boolean cleanSession;
    private Scheduler ioScheduler;

    public MQTTSession connect() throws ConnectionException {
        MqttAsyncClient mqttClient;
        MqttConnectOptions mqttConnectOptions = new MqttConnectOptions();
        mqttConnectOptions.setUserName(this.authentication.getUsername());
        mqttConnectOptions.setKeepAliveInterval(this.keepAliveInterval);
        mqttConnectOptions.setCleanSession(this.cleanSession);
        mqttConnectOptions.setMaxInflight(this.maxInFlight);
        mqttConnectOptions.setServerURIs(this.getFailOverServers().toArray(new String[0]));
        this.configureTls(mqttConnectOptions);
        if (this.authentication.getPassword() != null) {
            mqttConnectOptions.setPassword(this.authentication.getPassword().toCharArray());
        }
        mqttConnectOptions.setAutomaticReconnect(true);
        this.configureLWT(mqttConnectOptions);
        final CountDownLatch latch = new CountDownLatch(1);
        final Reference throwableReference = new Reference();
        try {
            this.ioScheduler = this.schedulerService.ioScheduler(SchedulerConfig.config().withName("MQTT-" + this.configName).withPrefix("MQTT-" + this.configName));
            mqttClient = new MqttAsyncClient(this.getUrl(), this.clientId, this.resilience.getPersistence().getPersistenceStrategy().get(), (MqttPingSender)new TimerPingSender(), (ScheduledExecutorService)this.ioScheduler);
            mqttClient.connect(mqttConnectOptions, new HashMap(), new IMqttActionListener(){

                public void onSuccess(IMqttToken asyncActionToken) {
                    latch.countDown();
                }

                public void onFailure(IMqttToken asyncActionToken, Throwable exception) {
                    throwableReference.set((Object)exception);
                    latch.countDown();
                }
            });
            latch.await();
        }
        catch (MqttException e) {
            throw new ConnectionException("Error creating connection" + e.getMessage(), (Throwable)e);
        }
        catch (InterruptedException e) {
            throw new ConnectionException("Error creating connection. Probably Mule is being turned off.", (Throwable)e);
        }
        if (throwableReference.get() != null) {
            throw new ConnectionException("Error while connecting to MQTT Broker", (Throwable)throwableReference.get());
        }
        return new MQTTSession(mqttClient);
    }

    private List<String> getFailOverServers() {
        List<String> userFailOverServers = this.resilience.getFailoverServers();
        if (!userFailOverServers.isEmpty()) {
            ArrayList<String> failOverServers = new ArrayList<String>(userFailOverServers.size() + 1);
            failOverServers.add(this.getUrl());
            failOverServers.addAll(userFailOverServers);
            return failOverServers;
        }
        return userFailOverServers;
    }

    private void configureLWT(MqttConnectOptions mqttConnectOptions) {
        if (this.lastWillAndTestament != null) {
            mqttConnectOptions.setWill(this.lastWillAndTestament.getTopic(), this.lastWillAndTestament.getBody().getBytes(), this.lastWillAndTestament.getQoS().getValue(), this.lastWillAndTestament.isRetained());
        }
    }

    public void disconnect(MQTTSession connection) {
        if (this.LOGGER.isTraceEnabled()) {
            this.LOGGER.trace("About to disconnect: " + connection);
        }
        try {
            MqttAsyncClient client = connection.getClient();
            client.disconnect();
            client.close();
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
        finally {
            if (this.ioScheduler != null && !this.ioScheduler.isShutdown()) {
                this.ioScheduler.stop();
            }
        }
    }

    public ConnectionValidationResult validate(MQTTSession connection) {
        MqttAsyncClient client = connection.getClient();
        if (client.isConnected()) {
            return ConnectionValidationResult.success();
        }
        return ConnectionValidationResult.failure((String)"Error", (Exception)new RuntimeException());
    }

    public String getUrl() {
        return this.protocol.getProtocol() + "://" + this.host + ":" + this.port;
    }

    private void configureTls(MqttConnectOptions mqttConnectOptions) throws ConnectionException {
        if (this.tlsContextFactory != null) {
            try {
                mqttConnectOptions.setSocketFactory((SocketFactory)this.tlsContextFactory.createSocketFactory());
            }
            catch (KeyManagementException | NoSuchAlgorithmException e) {
                throw new ConnectionException("Error on configured SSL/TLS Configurations", (Throwable)e);
            }
        }
    }
}

