/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.mqtt.internal;

import com.mulesoft.connectors.mqtt.api.QoS;
import com.mulesoft.connectors.mqtt.internal.ConnectionUtills;
import com.mulesoft.connectors.mqtt.internal.MQTTSession;
import com.mulesoft.connectors.mqtt.internal.PublishErrorTypes;
import com.mulesoft.connectors.mqtt.internal.error.MQTTInvalidTopicException;
import com.mulesoft.connectors.mqtt.internal.error.MQTTPublishException;
import com.mulesoft.connectors.mqtt.internal.metadata.AnyTypeResolver;
import java.io.InputStream;
import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.TypeResolver;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;

public class MQTTOperations {
    private static final Result<Void, Void> VOID_RESULT = Result.builder().build();

    @Throws(value={PublishErrorTypes.class})
    public void publish(String topic, @TypeResolver(value=AnyTypeResolver.class) @Content InputStream payload, @Optional(defaultValue="AT_LEAST_ONCE") QoS qos, boolean retained, @Connection MQTTSession connection, CompletionCallback<Void, Void> completionCallback) {
        try {
            connection.getClient().publish(topic, IOUtils.toByteArray((InputStream)payload), qos.getValue(), retained, null, (IMqttActionListener)new PublishActionListener(completionCallback));
        }
        catch (IllegalArgumentException e) {
            completionCallback.error((Throwable)((Object)new MQTTInvalidTopicException(e)));
        }
        catch (MqttException e) {
            if (ConnectionUtills.isConnectionException(e)) {
                completionCallback.error((Throwable)new ConnectionException((Throwable)e));
            } else {
                completionCallback.error((Throwable)((Object)new MQTTPublishException(e)));
            }
        }
        catch (Exception e) {
            completionCallback.error((Throwable)((Object)new MQTTPublishException(e)));
        }
    }

    private static class PublishActionListener
    implements IMqttActionListener {
        private CompletionCallback<Void, Void> completionCallback;

        PublishActionListener(CompletionCallback<Void, Void> completionCallback) {
            this.completionCallback = completionCallback;
        }

        public void onSuccess(IMqttToken iMqttToken) {
            this.completionCallback.success(VOID_RESULT);
        }

        public void onFailure(IMqttToken iMqttToken, Throwable throwable) {
            if (throwable instanceof IllegalArgumentException) {
                this.completionCallback.error((Throwable)((Object)new MQTTInvalidTopicException(throwable)));
            } else {
                this.completionCallback.error((Throwable)((Object)new MQTTPublishException(throwable)));
            }
        }
    }
}

