/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.mqtt.internal;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttMessage;

public class MQTTSession {
    private final MqttAsyncClient client;
    private final Set<Consumer<Throwable>> callbacks = new HashSet<Consumer<Throwable>>();

    public MQTTSession(MqttAsyncClient client) {
        this.client = client;
        this.client.setCallback(new MqttCallback(){

            public void connectionLost(Throwable cause) {
                MQTTSession.this.callbacks.forEach(c -> c.accept(cause));
            }

            public void messageArrived(String topic, MqttMessage message) throws Exception {
            }

            public void deliveryComplete(IMqttDeliveryToken token) {
            }
        });
    }

    public MqttAsyncClient getClient() {
        return this.client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerOnDisconnectCallback(Consumer<Throwable> callback) {
        Set<Consumer<Throwable>> set = this.callbacks;
        synchronized (set) {
            this.callbacks.add(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCallback(Consumer<Throwable> onDisconnectCallback) {
        Set<Consumer<Throwable>> set = this.callbacks;
        synchronized (set) {
            this.callbacks.remove(onDisconnectCallback);
        }
    }
}

