/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.netsuite.internal.citizen.metadata;

import com.mulesoft.connector.netsuite.internal.citizen.metadata.CitizenActionRecordEnum;
import com.mulesoft.connector.netsuite.internal.citizen.metadata.CitizenRecordEnum;
import com.mulesoft.connector.netsuite.internal.citizen.util.CitizenMetadataUtils;
import com.mulesoft.connector.netsuite.internal.error.NetSuiteSoapErrorType;
import com.mulesoft.connector.netsuite.internal.error.exception.NetSuiteSoapModuleException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.impl.DefaultObjectType;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeyBuilder;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.metadata.resolving.InputTypeResolver;
import org.mule.runtime.api.metadata.resolving.TypeKeysResolver;
import org.mule.runtime.api.value.Value;
import org.mule.runtime.core.api.expression.ExpressionRuntimeException;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.extension.api.values.ValueBuilder;
import org.mule.runtime.extension.api.values.ValueProvider;
import org.mule.runtime.extension.api.values.ValueResolvingException;

public class CitizenInputRecordResolver
implements InputTypeResolver<String>,
TypeKeysResolver,
ValueProvider {
    protected static final String RECORD = "record";
    protected static final Supplier<MetadataResolvingException> defaultErrSupplier = () -> new MetadataResolvingException("Could not generate input metadata", FailureCode.UNKNOWN);
    private static final Set<MetadataKey> METADATA_KEYS = Arrays.stream(CitizenActionRecordEnum.values()).map(field -> MetadataKeyBuilder.newKey((String)field.name()).withDisplayName(field.name()).build()).collect(Collectors.toSet());

    public Set<MetadataKey> getKeys(MetadataContext context) {
        return METADATA_KEYS;
    }

    public MetadataType getInputMetadata(MetadataContext context, String key) throws MetadataResolvingException {
        DefaultObjectType result = (DefaultObjectType)CitizenMetadataUtils.loadMetaData(context, key);
        this.processAttributes(result);
        return result;
    }

    protected void processAttributes(DefaultObjectType result) throws MetadataResolvingException {
        ((ObjectFieldType)result.getFieldByName(RECORD).orElseThrow(defaultErrSupplier)).getKey().getAttributes().clear();
    }

    public static InputStream prepareMessage(BiFunction<String, InputStream, InputStream> transformFn, InputStream input, String operation, String recordType, String id, String idType) {
        String recordTypeQName = Arrays.stream(CitizenActionRecordEnum.values()).filter(type -> type.name().equals(recordType)).findFirst().map(recordEnum -> CitizenRecordEnum.valueOf(recordType).getQName()).orElseThrow(() -> new NetSuiteSoapModuleException("Invalid record type", NetSuiteSoapErrorType.VALIDATION));
        String namespace = recordTypeQName.replaceFirst("^\\{([^}]+)}[^}]+$", "$1");
        String entity = recordTypeQName.replaceFirst("^\\{[^}]+}([^}]+)$", "$1");
        String idStatement = StringUtils.isBlank((String)id) ? "\"xmlns:ns0\": ns0, externalId: if(payload.record.@externalId == null) '' else payload.record.@externalId, " : "ns0#" + idType.toLowerCase() + "Id : '" + id + "' ,";
        String script = "%dw 2.0\noutput application/xml\nns ns0 " + namespace + "\nns ns1 urn:messages_2020_2.platform.webservices.netsuite.com\nns xsi http://www.w3.org/2001/XMLSchema-instance\nns platformCore urn:core_2020_2.platform.webservices.netsuite.com\nimport * from dw::core::Arrays\n\nfun getScriptId(key) = \n    slice(key splitBy '__', 1, sizeOf(key splitBy '__') - 1) joinBy  '__'\n\n    \nfun mapSelect(value, key) = {\n    platformCore#customField @(internalId: (key splitBy  '__')[-1], xsi#'type': 'platformCore:' ++ (key splitBy  '__')[0], scriptId: getScriptId(key)): {                platformCore#value @(internalId: if (value.@internalId == null) '' else value.@internalId, externalId: if (value.@externalId == null) '' else value.@externalId): {}\n            }\n}\nfun mapMultiSelect(value, key) = {\n    platformCore#customField @(internalId: (key splitBy  '__')[-1], xsi#'type': 'platformCore:' ++ (key splitBy  '__')[0], scriptId: getScriptId(key)): value mapObject ((val) -> {               platformCore#value @(internalId: if (val.@internalId == null) '' else val.@internalId, externalId: if (val.@externalId == null) '' else val.@externalId): {}\n            }\n)}\nfun mapScriptId(value, key) = {\n    platformCore#customField @(xsi#'type': 'platformCore:' ++ (key splitBy  '__')[0], scriptId: getScriptId(key)):  platformCore#value: value\n}\nfun mapScriptInternal(value, key) = {\n    platformCore#customField @(xsi#'type': 'platformCore:' ++ (key splitBy  '__')[0], scriptId: getScriptId(key), internalId: (key splitBy  '__')[-1]):  platformCore#value: value\n}\n\nfun mapCustomField(value, key) =\n    (key splitBy  '__')[0] match {\n        case 'SelectCustomFieldRef' -> mapSelect(value, key)\n        case 'MultiSelectCustomFieldRef' -> mapMultiSelect(value, key)\n        case 'StringCustomFieldRef' -> mapScriptId(value, key)\n        case 'DateCustomFieldRef' -> mapScriptId(value, key)\n        case 'LongCustomFieldRef' -> mapScriptInternal(value, key)\n        case 'DoubleCustomFieldRef' -> mapScriptInternal(value, key)\n        else -> {\n                    platformCore#customField @(internalId: (key splitBy  '__')[-1], xsi#'type': 'platformCore:' ++ (key splitBy  '__')[0]): {\n                    platformCore#value: value\n                    }\n        }\n}\n\nfun mapCustomFields(fields, namespace) = if (fields != null and namespace != null) {\n    namespace#customFieldList: fields.customFieldList mapObject ((value, key) ->  \n        mapCustomField(value, key))\n    }\n    else {}\n\nfun element(value, key, namespace) = {\n    namespace#\"$key\" @((value.@)): recursive(value, value.#)\n}\n\n\nfun recursive(payload, namespace) =\n  payload match {\n      case is Object -> ((payload - 'customFieldList') mapObject ((value, key1) -> element(value, key1, value.#))) ++ \n      mapCustomFields(payload, payload.customFieldList.#)\n      else -> payload\n}\n---\n{ \n    ns1#" + operation + ": {              record @(" + idStatement + " xsi#'type': 'ns0:" + entity + "'): recursive(payload.record, payload.record.#)\n    }\n}\n\n";
        try {
            return transformFn.apply(script, input);
        }
        catch (ExpressionRuntimeException ex) {
            throw new NetSuiteSoapModuleException("Invalid input data or record type", NetSuiteSoapErrorType.TRANSFORMATION, ex);
        }
    }

    public String getResolverName() {
        return CitizenInputRecordResolver.class.getSimpleName();
    }

    public String getCategoryName() {
        return "CITIZEN_NETSUITE_RECORD_CATEGORY";
    }

    public Set<Value> resolve() throws ValueResolvingException {
        return ValueBuilder.getValuesFor(METADATA_KEYS.stream().map(MetadataKey::getDisplayName).collect(Collectors.toList()));
    }
}

