/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.netsuite.internal.citizen.metadata;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mulesoft.connector.netsuite.api.NetsuiteSoapAttributes;
import com.mulesoft.connector.netsuite.internal.citizen.metadata.CitizenRecordEnum;
import com.mulesoft.connector.netsuite.internal.citizen.metadata.util.CustomFieldWrapper;
import com.mulesoft.connector.netsuite.internal.citizen.util.CitizenMetadataUtils;
import com.mulesoft.connector.netsuite.internal.config.NetSuiteSoapConfig;
import com.mulesoft.connector.netsuite.internal.connection.NetSuiteSoapConnection;
import com.mulesoft.connector.netsuite.internal.error.exception.NetSuiteSoapModuleException;
import com.mulesoft.connector.netsuite.internal.metadata.factory.XmlTypeLoaderFactory;
import com.mulesoft.connector.netsuite.internal.metadata.query.DefinitionsQuery;
import com.mulesoft.connector.netsuite.internal.metadata.query.DefinitionsQueryLocallyCachedProxy;
import com.mulesoft.connector.netsuite.internal.operation.ItemOperations;
import com.mulesoft.connector.netsuite.internal.operation.RecordOperations;
import com.mulesoft.connector.netsuite.internal.util.CustomFieldRefType;
import com.mulesoft.connector.netsuite.internal.util.CustomFieldType;
import com.mulesoft.connector.netsuite.internal.util.CustomFieldUtils;
import com.mulesoft.connector.netsuite.internal.util.CustomizationTypeEnum;
import com.mulesoft.connector.netsuite.internal.util.NetsuiteDocumentFactory;
import com.mulesoft.connector.netsuite.internal.util.Utils;
import com.mulesoft.connector.netsuite.internal.xml.XmlUtils;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.lang3.ObjectUtils;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectFieldTypeBuilder;
import org.mule.metadata.api.builder.ObjectKeyBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.xml.api.XmlTypeLoader;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class CitizenMetadataRecordResolver {
    private static final String COULD_NOT_GENERATE_METADATA = "Could not generate metadata from the WSDL model";
    private static final Logger logger = LoggerFactory.getLogger(CitizenMetadataRecordResolver.class);
    private static final Set<CustomizationTypeEnum> UNSUPPORTED_TYPES = new HashSet<CustomizationTypeEnum>(Arrays.asList(CustomizationTypeEnum.ITEM_NUMBER_CUSTOM_FIELD, CustomizationTypeEnum.CUSTOM_LIST, CustomizationTypeEnum.CUSTOM_RECORD_TYPE, CustomizationTypeEnum.CUSTOM_TRANSACTION_TYPE, CustomizationTypeEnum.ITEM_OPTION_CUSTOM_FIELD));
    private final String separator;
    private final ItemOperations itemOperations;
    private final RecordOperations recordOperations;
    private final NetSuiteSoapConnection connection;
    private final NetSuiteSoapConfig config;
    private DefinitionsQuery definitionsQuery;
    LazyValue<XmlTypeLoader> xmlTypeLoader = new LazyValue(this::loadXmlTypeLoader);
    private static final Set<String> VALID_ATTRIBUTES = Sets.newHashSet((Object[])new String[]{"internalId", "type"});

    public CitizenMetadataRecordResolver(MetadataContext metadataContext) throws ConnectionException, MetadataResolvingException {
        this.connection = (NetSuiteSoapConnection)metadataContext.getConnection().orElseThrow(() -> new MetadataResolvingException("Could not get a connection to resolve metadata", FailureCode.CONNECTION_FAILURE));
        this.config = (NetSuiteSoapConfig)metadataContext.getConfig().orElseThrow(() -> new MetadataResolvingException("Could not get a config to resolve metadata", FailureCode.CONNECTION_FAILURE));
        this.definitionsQuery = new DefinitionsQueryLocallyCachedProxy(this.connection.getDefinitions());
        this.separator = this.config.getAdvancedConfig().getSeparator();
        this.itemOperations = new ItemOperations();
        this.recordOperations = new RecordOperations();
    }

    private XmlTypeLoader loadXmlTypeLoader() {
        return XmlTypeLoaderFactory.createCachedXmlTypeLoaderWithLocalDefinitions(this.connection.getDefinitions());
    }

    private String resolveNamespace(String localName) throws MetadataResolvingException {
        Optional<String> namespace = this.tryToResolveNamespace(localName);
        if (!namespace.isPresent()) {
            throw new MetadataResolvingException("Could not resolve namespace for localPart %s in the xsd schemas", FailureCode.UNKNOWN);
        }
        return namespace.get();
    }

    private Optional<String> tryToResolveNamespace(String localName) {
        return this.definitionsQuery.resolveNamespaceFor(localName);
    }

    protected ObjectTypeBuilder getRootBuilder(BaseTypeBuilder baseTypeBuilder, String rootElementLocalPart) throws MetadataResolvingException {
        ObjectTypeBuilder rootObjectBuilder = baseTypeBuilder.withFormat(MetadataFormat.XML).objectType();
        QName rootQName = new QName(this.resolveNamespace(rootElementLocalPart), rootElementLocalPart);
        rootObjectBuilder.id("#root:" + rootQName.toString());
        return rootObjectBuilder;
    }

    protected ObjectFieldTypeBuilder getObjectFieldTypeBuilder(String rooElementtLocalPart, ObjectTypeBuilder rootObjectBuilder, boolean repeated) throws MetadataResolvingException {
        ObjectFieldTypeBuilder requestRootField = rootObjectBuilder.addField().required().repeated(repeated);
        requestRootField.key(new QName(this.resolveNamespace(rooElementtLocalPart), rooElementtLocalPart));
        return requestRootField;
    }

    public void generateCustomMetadataTypes(String recordType, ObjectFieldType objectType) {
        logger.debug("Starting custom metadata resolution for {}.", (Object)recordType);
        List<String> customizationTypes = Stream.of(CustomizationTypeEnum.values()).filter(val -> !UNSUPPORTED_TYPES.contains(val)).map(v -> v.getNetsuiteValue()).collect(Collectors.toList());
        Map<String, List<Node>> customizationMappings = this.retrieveAndExtractCustomizationRefNodesToMap(customizationTypes);
        logger.info("Retrieving customization types finished for {}.", (Object)recordType);
        ArrayList allNodes = new ArrayList();
        customizationMappings.values().stream().forEach(l -> allNodes.addAll(l));
        List partitions = Lists.partition(allNodes, (int)300);
        ArrayList<CustomFieldWrapper> list = new ArrayList<CustomFieldWrapper>();
        try {
            for (List partition : partitions) {
                logger.info(String.format("Getting a batch... size:%d", partition.size()));
                list.addAll(this.retrieveRecordsForBaseRefs(partition));
                logger.info("Batch retrieved and loaded.");
            }
        }
        catch (IOException | ParserConfigurationException | TransformerException | XPathExpressionException | SAXException e) {
            logger.error("Could not generate metadata for some customizationIds", (Throwable)e);
        }
        this.addCustomFields(objectType, list.stream().sorted(Comparator.comparing(a -> a.getFieldType().getKey().getName().getLocalPart())).collect(Collectors.toList()), CitizenRecordEnum.valueOf(recordType));
    }

    private void addCustomFields(ObjectFieldType parent, List<CustomFieldWrapper> list, CitizenRecordEnum recordType) {
        ObjectType objectType = (ObjectType)parent.getValue();
        Optional<ObjectFieldType> customFields = objectType.getFields().stream().filter(field -> field.getKey().getName().getLocalPart().equals("customFieldList")).findAny();
        if (customFields.isPresent()) {
            objectType.getFields().remove(customFields.get());
            ObjectFieldTypeBuilder fieldTypeBuilder = new ObjectFieldTypeBuilder(MetadataFormat.XML);
            QName name = customFields.get().getKey().getName();
            ObjectKeyBuilder keyBuilder = fieldTypeBuilder.key(name);
            fieldTypeBuilder.label(CitizenMetadataUtils.getLabel(name));
            CitizenMetadataUtils.copyKeyAttributes(customFields.get(), keyBuilder);
            fieldTypeBuilder.value().objectType();
            ObjectFieldType build = fieldTypeBuilder.build();
            Collection fields = ((ObjectType)build.getValue()).getFields();
            list.stream().filter(field -> recordType.appliesTo((CustomFieldWrapper)field, parent)).forEach(customField -> {
                logger.trace("Adding {} to parent element {}.", (Object)customField.getFieldType().getKey().getName(), (Object)parent.getKey().getName());
                fields.add(customField.getFieldType());
            });
            if (!fields.isEmpty()) {
                objectType.getFields().add(build);
            } else {
                logger.trace("No custom fields have been resolved for key: {}.", (Object)parent.getKey().getName());
            }
        }
        objectType.getFields().forEach(field -> {
            if (field.getValue() instanceof ObjectType) {
                this.addCustomFields((ObjectFieldType)field, list, recordType);
            }
        });
    }

    @VisibleForTesting
    protected List<CustomFieldWrapper> retrieveRecordsForBaseRefs(List<Node> baseRefs) throws ParserConfigurationException, TransformerException, IOException, SAXException, XPathExpressionException {
        NetsuiteDocumentFactory netsuiteDocumentFactory = new NetsuiteDocumentFactory("2020_2", null, null);
        Document getListRequestDoc = netsuiteDocumentFactory.getListRequest(baseRefs);
        Result<InputStream, NetsuiteSoapAttributes> getListResult = this.recordOperations.getList(this.config, this.connection, null, netsuiteDocumentFactory.transformToInputStream(getListRequestDoc));
        Document getListResultDocument = netsuiteDocumentFactory.transformToDocument((InputStream)getListResult.getOutput());
        List<Node> customizationRecords = XmlUtils.toList((NodeList)XmlUtils.executeXPath("//*[local-name()='record']", getListResultDocument, XPathConstants.NODESET));
        return this.convertCustomizationRecordToMetadataType(customizationRecords);
    }

    protected List<CustomFieldWrapper> convertCustomizationRecordToMetadataType(List<Node> customizationRecords) {
        List<CustomFieldWrapper> list = customizationRecords.stream().map(node -> {
            try {
                HashMap<String, Map<String, String>> customFields = new HashMap<String, Map<String, String>>();
                CitizenMetadataRecordResolver.extractCustomFields(node, customFields);
                Iterator cfi = customFields.entrySet().iterator();
                if (!cfi.hasNext()) {
                    logger.info(String.format("No custom fields appear for record: <%s internalId:%s>", node.getNodeName(), node.getAttributes().getNamedItem("internalId").getNodeValue()));
                    return null;
                }
                if (customFields.size() > 1) {
                    logger.warn(String.format("Multiple custom fields appear for record: <%s internalId:%s>", node.getNodeName(), node.getAttributes().getNamedItem("internalId").getNodeValue()));
                }
                Map mappedCustomField = (Map)cfi.next().getValue();
                String internalId = (String)mappedCustomField.get("internalId");
                String label = (String)mappedCustomField.get("label");
                String displayType = (String)mappedCustomField.get("displayType");
                if ("_disabled".equals(displayType)) {
                    logger.trace("Skipping {}, internalId: {} field as it has been disabled.", (Object)label, (Object)internalId);
                    return null;
                }
                String fieldType = (String)mappedCustomField.get("fieldType");
                String scriptId = (String)mappedCustomField.get("scriptId");
                String isMandatory = (String)mappedCustomField.get("isMandatory");
                Optional<CustomFieldRefType> customFieldRefType = CustomFieldType.refTypeFromNetSuiteName(fieldType);
                if (!customFieldRefType.isPresent()) {
                    logger.trace("Skipping {}, internalId: {} field as its type: {} is not supported.", new Object[]{label, internalId, fieldType});
                    return null;
                }
                if (!ObjectUtils.allNotNull((Object[])new Object[]{fieldType, scriptId}) && customFieldRefType.isPresent()) {
                    String description = (String)mappedCustomField.get("description");
                    String accessLevel = (String)mappedCustomField.get("accessLevel");
                    String searchLevel = (String)mappedCustomField.get("searchLevel");
                    String customizationData = String.format(" internalId: '%s' fieldType:'%s' label:'%s' description:'%s' isMandatory:'%s' accessLevel:'%s' searchLevel:'%s' ", fieldType, label, description, isMandatory, accessLevel, searchLevel, internalId);
                    logger.warn("Could not recognize field with values :: {}", (Object)customizationData);
                    return null;
                }
                String metadataFieldKey = CustomFieldUtils.getMetadataFieldKey(customFieldRefType.get(), this.separator, scriptId, internalId);
                if (logger.isDebugEnabled()) {
                    logger.debug("Metadata field processed: {}", (Object)metadataFieldKey);
                }
                String customFieldRefElementElementName = Utils.toLowerCamelCase(customFieldRefType.get().getNetsuiteValue());
                MetadataType typeRefMetadata = this.getMetadataTypeFromXmlTypeLoader(customFieldRefElementElementName);
                ObjectFieldType result = (ObjectFieldType)((ObjectType)typeRefMetadata).getFields().iterator().next();
                Optional value = ((ObjectType)result.getValue()).getFieldByName("value");
                ObjectFieldTypeBuilder fieldTypeBuilder = new ObjectFieldTypeBuilder(MetadataFormat.XML);
                ObjectKeyBuilder keyBuilder = fieldTypeBuilder.key(new QName(metadataFieldKey));
                fieldTypeBuilder.label(label).required(Boolean.valueOf(isMandatory).booleanValue());
                if (CustomFieldRefType.SELECT.equals((Object)customFieldRefType.get())) {
                    CitizenMetadataUtils.copyKeyAttributes((ObjectFieldType)value.get(), keyBuilder);
                }
                if (CustomFieldRefType.MULTI_SELECT.equals((Object)customFieldRefType.get())) {
                    CitizenMetadataUtils.mapField((ObjectFieldType)value.get(), fieldTypeBuilder.value().objectType());
                    return new CustomFieldWrapper(fieldTypeBuilder.build(), (Node)node);
                }
                return new CustomFieldWrapper(fieldTypeBuilder.value(((ObjectFieldType)value.get()).getValue()).build(), (Node)node);
            }
            catch (XPathExpressionException e) {
                logger.error(String.format("Could not generate metadata for node %s", node), (Throwable)e);
            }
            catch (MetadataResolvingException e) {
                logger.error(String.format("Could not generate metadata for node %s", node), (Throwable)e);
            }
            return null;
        }).filter(v -> v != null).collect(Collectors.toList());
        return list;
    }

    public static void extractCustomFields(Node root, Map<String, Map<String, String>> customFields) {
        if (root.getNodeName().endsWith("record")) {
            Map<String, String> customField = CitizenMetadataRecordResolver.readCustomFieldValues(root);
            customFields.put(customField.get("internalId"), customField);
        }
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            CitizenMetadataRecordResolver.extractCustomFields(child, customFields);
        }
    }

    private static Map<String, String> readCustomFieldValues(Node root) {
        HashMap<String, String> customField = new HashMap<String, String>();
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String name = child.getNodeName();
            String[] parts = name.split(":");
            String localName = parts[parts.length - 1];
            customField.put(localName, child.getTextContent());
        }
        NamedNodeMap attributes = root.getAttributes();
        for (String attributeName : VALID_ATTRIBUTES) {
            Node attributeNode = attributes.getNamedItem(attributeName);
            if (attributeNode == null) continue;
            customField.put(attributeName, attributeNode.getNodeValue());
        }
        return customField;
    }

    private XmlTypeLoader getXmlTypeLoader() throws MetadataResolvingException {
        try {
            return (XmlTypeLoader)this.xmlTypeLoader.get();
        }
        catch (RuntimeException e) {
            throw new MetadataResolvingException("", FailureCode.UNKNOWN, (Throwable)e);
        }
    }

    private MetadataType getMetadataTypeFromXmlTypeLoader(String localTypeName) throws MetadataResolvingException {
        Optional<String> namespaceURI = this.tryToResolveNamespace(localTypeName);
        Optional metadataType = this.getXmlTypeLoader().load(new QName(namespaceURI.orElse("http://mulesoft.org/connectors/netsuite"), localTypeName), localTypeName);
        return (MetadataType)metadataType.orElseThrow(() -> new MetadataResolvingException(String.format("Could not resolve metadata from localTypeName loader for localTypeName %s", localTypeName), FailureCode.UNKNOWN));
    }

    private void setFieldValue(Object object, Object fieldValue, String fieldName) throws IllegalAccessException, NoSuchFieldException {
        Field field = object.getClass().getDeclaredField(fieldName);
        field.setAccessible(true);
        field.set(object, fieldValue);
    }

    private void replaceObjectFieldKeyName(ObjectFieldType to, Optional<QName> name) throws MetadataResolvingException {
        try {
            this.setFieldValue(to.getKey(), name, "name");
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new MetadataResolvingException(COULD_NOT_GENERATE_METADATA, FailureCode.UNKNOWN, (Throwable)e);
        }
    }

    @VisibleForTesting
    protected Map<String, List<Node>> retrieveAndExtractCustomizationRefNodesToMap(List<String> customizationTypes) {
        return customizationTypes.stream().collect(Collectors.toMap(v -> v, customizationId -> {
            try {
                return this.retrieveCustomizationRefNodes((String)customizationId);
            }
            catch (NetSuiteSoapModuleException | ParserConfigurationException | TransformerException | XPathExpressionException e) {
                logger.error(String.format("Could not obtain custom Fields from Netsuite for customizationId %s", customizationId), (Throwable)e);
                return Collections.emptyList();
            }
        }));
    }

    @VisibleForTesting
    protected List<Node> retrieveCustomizationRefNodes(String customizationId) throws ParserConfigurationException, TransformerException, XPathExpressionException {
        NetsuiteDocumentFactory netsuiteDocumentFactory = new NetsuiteDocumentFactory("2020_2", null, null);
        Document customizationRequestDoc = netsuiteDocumentFactory.getCustomizationRequest(customizationId);
        Result<InputStream, NetsuiteSoapAttributes> customizationIdsResponse = this.itemOperations.getCustomizationId(this.config, this.connection, netsuiteDocumentFactory.transformToInputStream(customizationRequestDoc));
        NodeList customizationRefNodes = (NodeList)XmlUtils.executeXPath("//*[local-name()='customizationRef']", (InputStream)customizationIdsResponse.getOutput(), XPathConstants.NODESET);
        logger.debug("Retrieving customization ref nodes finished for {}.", (Object)customizationId);
        return XmlUtils.toList(customizationRefNodes);
    }

    private <T> List<List<T>> partitionList(List<T> customizationRefElements, int partitionSize) {
        ArrayList<List<T>> results = new ArrayList<List<T>>();
        ArrayList<T> listOfElements = null;
        for (T each : customizationRefElements) {
            if (listOfElements == null || listOfElements.size() >= partitionSize) {
                listOfElements = new ArrayList<T>();
                results.add(listOfElements);
            }
            listOfElements.add(each);
        }
        return results;
    }
}

