/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.netsuite.internal.citizen.metadata;

import com.mulesoft.connector.netsuite.internal.citizen.metadata.util.CustomFieldWrapper;
import org.mule.metadata.api.annotation.TypeIdAnnotation;
import org.mule.metadata.api.model.ObjectFieldType;

public enum CitizenRecordEnum {
    CUSTOMER("{urn:relationships_2020_2.lists.webservices.netsuite.com}Customer"){

        @Override
        public boolean appliesTo(CustomFieldWrapper field, ObjectFieldType parent) {
            return this.appliesToDefault(field.isAppliesToCustomer(), field, parent);
        }
    }
    ,
    CUSTOMER_REFUND("{urn:customers_2020_2.transactions.webservices.netsuite.com}CustomerRefund"),
    EMPLOYEE("{urn:employees_2020_2.lists.webservices.netsuite.com}Employee"){

        @Override
        public boolean appliesTo(CustomFieldWrapper field, ObjectFieldType parent) {
            return this.appliesToDefault(field.isAppliesToEmployee(), field, parent);
        }
    }
    ,
    CONTACT("{urn:relationships_2020_2.lists.webservices.netsuite.com}Contact"){

        @Override
        public boolean appliesTo(CustomFieldWrapper field, ObjectFieldType parent) {
            return this.appliesToDefault(field.isAppliesToContact(), field, parent);
        }
    }
    ,
    INVENTORY_ITEM("{urn:accounting_2020_2.lists.webservices.netsuite.com}InventoryItem"){

        @Override
        public boolean appliesTo(CustomFieldWrapper field, ObjectFieldType parent) {
            return this.appliesToDefault(field.isAppliesToInventory(), field, parent);
        }
    }
    ,
    INVOICE("{urn:sales_2020_2.transactions.webservices.netsuite.com}Invoice"){

        @Override
        public boolean appliesTo(CustomFieldWrapper field, ObjectFieldType parent) {
            return this.appliesToItem("InvoiceItem", field, parent);
        }
    }
    ,
    PAYMENT_ITEM("{urn:accounting_2020_2.lists.webservices.netsuite.com}PaymentItem"),
    SALES_ORDER("{urn:sales_2020_2.transactions.webservices.netsuite.com}SalesOrder"){

        @Override
        public boolean appliesTo(CustomFieldWrapper field, ObjectFieldType parent) {
            return this.appliesToItem("SalesOrderItem", field, parent);
        }
    }
    ,
    SUPPORT_CASE("{urn:support_2020_2.lists.webservices.netsuite.com}SupportCase"){

        @Override
        public boolean appliesTo(CustomFieldWrapper field, ObjectFieldType parent) {
            return this.appliesToDefault(field.isAppliesToCase(), field, parent);
        }
    };

    public static final String TRANSACTION_BODY_CUSTOM_FIELD = "TransactionBodyCustomField";
    public static final String TRANSACTION_COLUMN_CUSTOM_FIELD = "TransactionColumnCustomField";
    public static final String OTHER_CUSTOM_FIELD = "OtherCustomField";
    public static final String ENTITY_CUSTOM_FIELD = "EntityCustomField";
    private final String qname;

    private CitizenRecordEnum(String qName) {
        this.qname = qName;
    }

    public String getQName() {
        return this.qname;
    }

    public boolean appliesTo(CustomFieldWrapper field, ObjectFieldType parent) {
        return false;
    }

    public boolean appliesToDefault(boolean appliesTo, CustomFieldWrapper field, ObjectFieldType parent) {
        switch (field.getType()) {
            case "OtherCustomField": {
                return field.getRecTypeName().equals(CitizenRecordEnum.getParentName(parent));
            }
            case "EntityCustomField": {
                return this.getWsdlType().equals(CitizenRecordEnum.getParentName(parent)) && appliesTo;
            }
        }
        return appliesTo;
    }

    public boolean appliesToItem(String fieldName, CustomFieldWrapper field, ObjectFieldType parent) {
        switch (field.getType()) {
            case "TransactionBodyCustomField": {
                return this.getWsdlType().equals(CitizenRecordEnum.getParentName(parent)) && field.isBodySale();
            }
            case "TransactionColumnCustomField": {
                return fieldName.equals(CitizenRecordEnum.getParentName(parent)) && field.isColSale();
            }
            case "OtherCustomField": {
                return field.getRecTypeName().equals(CitizenRecordEnum.getParentName(parent));
            }
        }
        return false;
    }

    public String getNamespace() {
        return this.getQName() == null ? null : this.getQName().replaceFirst("^\\{([^}]+)}[^}]+$", "$1");
    }

    public String getWsdlType() {
        return this.getQName() == null ? null : this.getQName().replaceFirst("^\\{[^}]+}([^}]+)$", "$1");
    }

    private static String getParentName(ObjectFieldType parent) {
        return parent.getValue().getAnnotation(TypeIdAnnotation.class).map(typeAnnotation -> typeAnnotation.getValue().replaceFirst("^\\{[^}]+}([^}]+)$", "$1")).orElse(null);
    }
}

