/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.netsuite.internal.citizen.metadata.util;

import com.mulesoft.connector.netsuite.internal.xml.XmlUtils;
import java.util.Map;
import javax.xml.xpath.XPathExpressionException;
import org.jetbrains.annotations.NotNull;
import org.mule.metadata.api.model.ObjectFieldType;
import org.w3c.dom.Node;

public class CustomFieldWrapper {
    private String type;
    private String recTypeName;
    private boolean appliesToCustomer;
    private boolean appliesToEmployee;
    private boolean appliesToContact;
    private boolean appliesToInventory;
    private boolean appliesToCase;
    private boolean bodySale;
    private boolean colSale;
    private ObjectFieldType fieldType;

    public CustomFieldWrapper(ObjectFieldType field, Map<String, String> nodeMap) throws XPathExpressionException {
        this.fieldType = field;
        this.recTypeName = nodeMap.get("recType");
        this.type = nodeMap.get("type");
        this.appliesToCase = "true".equalsIgnoreCase(nodeMap.get("appliesToCase"));
        this.appliesToCustomer = "true".equalsIgnoreCase(nodeMap.get("appliesToCustomer"));
        this.appliesToEmployee = "true".equalsIgnoreCase(nodeMap.get("appliesToEmployee"));
        this.appliesToContact = "true".equalsIgnoreCase(nodeMap.get("appliesToContact"));
        this.appliesToInventory = "true".equalsIgnoreCase(nodeMap.get("appliesToInventory"));
        this.bodySale = "true".equalsIgnoreCase(nodeMap.get("bodySale"));
        this.colSale = "true".equalsIgnoreCase(nodeMap.get("colSale"));
    }

    public CustomFieldWrapper(ObjectFieldType field, Node node) throws XPathExpressionException {
        this.fieldType = field;
        this.recTypeName = XmlUtils.executeXPath("./*[local-name() = 'recType']", node);
        this.type = XmlUtils.executeXPath("./@*[local-name() = 'type']", node).split(":")[1];
        this.appliesToCase = this.getAppliesTo(node, "appliesToCase");
        this.appliesToCustomer = this.getAppliesTo(node, "appliesToCustomer");
        this.appliesToEmployee = this.getAppliesTo(node, "appliesToEmployee");
        this.appliesToContact = this.getAppliesTo(node, "appliesToContact");
        this.appliesToInventory = this.getAppliesTo(node, "appliesToInventory");
        this.bodySale = this.getAppliesTo(node, "bodySale");
        this.colSale = this.getAppliesTo(node, "colSale");
    }

    @NotNull
    private Boolean getAppliesTo(Node node, String name) throws XPathExpressionException {
        return Boolean.valueOf(XmlUtils.executeXPath("./*[local-name() = '" + name + "']", node));
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getRecTypeName() {
        return this.recTypeName;
    }

    public void setRecTypeName(String recTypeName) {
        this.recTypeName = recTypeName;
    }

    public boolean isAppliesToCustomer() {
        return this.appliesToCustomer;
    }

    public void setAppliesToCustomer(boolean appliesToCustomer) {
        this.appliesToCustomer = appliesToCustomer;
    }

    public boolean isAppliesToEmployee() {
        return this.appliesToEmployee;
    }

    public void setAppliesToEmployee(boolean appliesToEmployee) {
        this.appliesToEmployee = appliesToEmployee;
    }

    public boolean isAppliesToContact() {
        return this.appliesToContact;
    }

    public void setAppliesToContact(boolean appliesToContact) {
        this.appliesToContact = appliesToContact;
    }

    public boolean isAppliesToInventory() {
        return this.appliesToInventory;
    }

    public void setAppliesToInventory(boolean appliesToInventory) {
        this.appliesToInventory = appliesToInventory;
    }

    public boolean isBodySale() {
        return this.bodySale;
    }

    public void setBodySale(boolean bodySale) {
        this.bodySale = bodySale;
    }

    public boolean isColSale() {
        return this.colSale;
    }

    public void setColSale(boolean colSale) {
        this.colSale = colSale;
    }

    public boolean isAppliesToCase() {
        return this.appliesToCase;
    }

    public void setAppliesToCase(boolean appliesToCase) {
        this.appliesToCase = appliesToCase;
    }

    public ObjectFieldType getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(ObjectFieldType fieldType) {
        this.fieldType = fieldType;
    }
}

