/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.netsuite.internal.citizen.sampledata;

import com.google.common.base.CaseFormat;
import com.mulesoft.connector.netsuite.api.NetsuiteSoapAttributes;
import com.mulesoft.connector.netsuite.internal.citizen.metadata.CitizenRecordEnum;
import com.mulesoft.connector.netsuite.internal.citizen.metadata.CitizenSourceRecordEnum;
import com.mulesoft.connector.netsuite.internal.config.NetSuiteSoapConfig;
import com.mulesoft.connector.netsuite.internal.connection.NetSuiteSoapConnection;
import com.mulesoft.connector.netsuite.internal.operation.RecordOperations;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Optional;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;
import org.mule.sdk.api.data.sample.SampleDataException;
import org.mule.sdk.api.runtime.operation.Result;

public abstract class AbstractSampleDataProvider {
    private static final DateTimeFormatter MULE_DATETIME_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssZ");
    private static final int PAGE_SIZE = 5;
    protected static final String DW_RECORD_EXTRACTION = "payload";
    @Parameter
    protected String recordType;
    @Config
    protected NetSuiteSoapConfig config;
    @Connection
    protected NetSuiteSoapConnection connection;

    protected Result<InputStream, NetsuiteSoapAttributes> getSample(String outputScript) throws SampleDataException {
        try {
            String searchBody;
            if (this.recordType.equals("CUSTOMER_REFUND")) {
                searchBody = "<search xmlns=\"urn:messages_2020_2.platform.webservices.netsuite.com\" xmlns:common=\"urn:common_2020_2.platform.webservices.netsuite.com\">\n         <searchRecord xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type=\"common:TransactionSearchBasic\">\n            <dateCreated xmlns=\"urn:common_2020_2.platform.webservices.netsuite.com\" operator=\"before\">\n               <searchValue xmlns=\"\">" + ZonedDateTime.now().format(MULE_DATETIME_FORMAT) + "</searchValue>\n            </dateCreated>\n            <type xmlns=\"urn:common_2020_2.platform.webservices.netsuite.com\" operator=\"anyOf\">\n                <searchValue xmlns=\"\">_customerRefund</searchValue>\n            </type>\n         </searchRecord>\n      </search>";
            } else if (this.recordType.equals("PAYMENT_ITEM")) {
                searchBody = "<search xmlns=\"urn:messages_2020_2.platform.webservices.netsuite.com\" xmlns:common=\"urn:common_2020_2.platform.webservices.netsuite.com\">\n         <searchRecord xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type=\"common:ItemSearchBasic\">\n            <created xmlns=\"urn:common_2020_2.platform.webservices.netsuite.com\" operator=\"before\">\n               <searchValue xmlns=\"\">" + ZonedDateTime.now().format(MULE_DATETIME_FORMAT) + "</searchValue>\n            </created>\n            <type xmlns=\"urn:common_2020_2.platform.webservices.netsuite.com\" operator=\"anyOf\">\n               <searchValue xmlns=\"\">_payment</searchValue>\n            </type>\n         </searchRecord>\n      </search>";
            } else if (CitizenSourceRecordEnum.valueOf(this.recordType).getType() == null) {
                String upperCamelCaseRecordType = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.recordType);
                String searchField = CitizenSourceRecordEnum.valueOf(this.recordType).getOnNewSearchField();
                searchBody = "<search xmlns=\"urn:messages_2020_2.platform.webservices.netsuite.com\" xmlns:common=\"urn:common_2020_2.platform.webservices.netsuite.com\">\n         <searchRecord xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type=\"common:" + upperCamelCaseRecordType + "SearchBasic\">\n            <" + searchField + " xmlns=\"urn:common_2020_2.platform.webservices.netsuite.com\" operator=\"before\">\n               <searchValue xmlns=\"\">" + ZonedDateTime.now().format(MULE_DATETIME_FORMAT) + "</searchValue>\n            </" + searchField + ">\n         </searchRecord>\n      </search>";
            } else {
                String searchField = CitizenSourceRecordEnum.valueOf(this.recordType).getOnNewSearchField();
                searchBody = "<search xmlns=\"urn:messages_2020_2.platform.webservices.netsuite.com\" xmlns:common=\"urn:common_2020_2.platform.webservices.netsuite.com\">\n         <searchRecord xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type=\"common:" + CitizenSourceRecordEnum.valueOf(this.recordType).getSearchType(CitizenRecordEnum.valueOf(this.recordType).getQName()) + "\">\n            <" + searchField + " xmlns=\"urn:common_2020_2.platform.webservices.netsuite.com\" operator=\"before\">\n               <searchValue xmlns=\"\">" + ZonedDateTime.now().format(MULE_DATETIME_FORMAT) + "</searchValue>\n            </" + searchField + ">\n            <type xmlns=\"urn:common_2020_2.platform.webservices.netsuite.com\" operator=\"anyOf\">\n               <searchValue xmlns=\"\">" + CitizenSourceRecordEnum.valueOf(this.recordType).getType() + "</searchValue>\n            </type>\n         </searchRecord>\n      </search>";
            }
            PagingProvider<NetSuiteSoapConnection, org.mule.runtime.extension.api.runtime.operation.Result<String, NetsuiteSoapAttributes>> searchResult = new RecordOperations().search(this.config, null, new ByteArrayInputStream(searchBody.getBytes()), 5, 1, true, true);
            List records = searchResult.getPage((Object)this.connection);
            if (records.isEmpty()) {
                throw new SampleDataException("Error while retrieving sample data", "NO_DATA_AVAILABLE");
            }
            org.mule.runtime.extension.api.runtime.operation.Result singleItem = (org.mule.runtime.extension.api.runtime.operation.Result)records.get(0);
            InputStream singleOutput = this.connection.getDocumentFactory().transform(outputScript, new ByteArrayInputStream(((String)singleItem.getOutput()).getBytes()));
            Result.Builder builder = Result.builder().output((Object)singleOutput).mediaType(MediaType.APPLICATION_XML);
            Optional attributes = singleItem.getAttributes();
            if (attributes.isPresent()) {
                builder.attributes(attributes.get());
            }
            return builder.build();
        }
        catch (Exception e) {
            throw new SampleDataException("Error while retrieving sample data", "NO_DATA_AVAILABLE", (Throwable)e);
        }
    }

    void setRecordType(String recordType) {
        this.recordType = recordType;
    }

    void setConnection(NetSuiteSoapConnection connection) {
        this.connection = connection;
    }
}

