/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.netsuite.internal.citizen.source;

import com.mulesoft.connector.netsuite.api.NetsuiteSoapAttributes;
import com.mulesoft.connector.netsuite.internal.citizen.metadata.CitizenRecordEnum;
import com.mulesoft.connector.netsuite.internal.citizen.metadata.CitizenSourceMetadataResolver;
import com.mulesoft.connector.netsuite.internal.citizen.metadata.CitizenSourceRecordEnum;
import com.mulesoft.connector.netsuite.internal.citizen.util.FilteringUtils;
import com.mulesoft.connector.netsuite.internal.connection.NetSuiteSoapConnection;
import com.mulesoft.connector.netsuite.internal.error.NetSuiteSoapErrorType;
import com.mulesoft.connector.netsuite.internal.error.exception.NetSuiteSoapModuleException;
import com.mulesoft.connector.netsuite.internal.operation.RecordOperations;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPathExpressionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.annotation.metadata.MetadataKeyId;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;
import org.mule.sdk.api.runtime.operation.Result;
import org.mule.sdk.api.runtime.source.PollContext;
import org.mule.sdk.api.runtime.source.PollingSource;
import org.mule.sdk.api.runtime.source.SourceCallbackContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public abstract class CitizenAbstractSource
extends PollingSource<InputStream, NetsuiteSoapAttributes> {
    private static final DateTimeFormatter MULE_DATETIME_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSxxx");
    public static final ZoneId ZONE_ID = ZoneId.systemDefault();
    private static final String EXTRACT_ID_AND_WATERMARK = "%dw 2.0\noutput application/java\n---\n{\n    id: payload.record.@internalId,\n    watermark: payload.record.DATE_FIELD\n}";
    private String startSince;
    private static final String DW_RECORD_EXTRACTION = "payload";
    @Connection
    private ConnectionProvider<NetSuiteSoapConnection> connectionProvider;
    private NetSuiteSoapConnection connection;
    @Parameter
    @Placement(order=1)
    @Summary(value="The type of record that will be retrieved when created.")
    @MetadataKeyId(value=CitizenSourceMetadataResolver.class)
    @DisplayName(value="Type of Record")
    protected String recordType;

    protected void doStart() throws MuleException {
        this.connection = (NetSuiteSoapConnection)this.connectionProvider.connect();
        this.startSince = ZonedDateTime.now().format(MULE_DATETIME_FORMAT);
    }

    protected void doStop() {
        this.connectionProvider.disconnect((Object)this.connection);
    }

    public void poll(PollContext<InputStream, NetsuiteSoapAttributes> pollContext) {
        if (pollContext.isSourceStopping()) {
            return;
        }
        try {
            CitizenSourceRecordEnum searchEnum = CitizenSourceRecordEnum.valueOf(this.recordType);
            this.searchRecordPollCreate(pollContext, searchEnum);
        }
        catch (Exception e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    public void onRejectedItem(Result<InputStream, NetsuiteSoapAttributes> result, SourceCallbackContext sourceCallbackContext) {
    }

    protected void searchRecordPollCreate(PollContext<InputStream, NetsuiteSoapAttributes> pollContext, CitizenSourceRecordEnum searchEnum) throws TransformerException, ParserConfigurationException, XPathExpressionException, IOException, SAXException {
        String watermarkField;
        String since = pollContext.getWatermark().isPresent() ? this.formatSince(((Serializable)pollContext.getWatermark().get()).toString()) : this.formatSince(this.startSince);
        PagingProvider<NetSuiteSoapConnection, org.mule.runtime.extension.api.runtime.operation.Result<String, NetsuiteSoapAttributes>> searchResults = new RecordOperations().search(null, null, this.bodyRequest(searchEnum, since), 10, -1, true, true);
        List records = searchResults.getPage((Object)this.connection);
        String string = watermarkField = this.getSearchField(searchEnum).equals("lastModifiedDate") ? this.getSearchField(searchEnum) : CitizenSourceRecordEnum.valueOf(this.recordType).getOnNewRecordWatermarkField();
        while (!records.isEmpty()) {
            for (int i = 0; i < records.size(); ++i) {
                if (pollContext.isSourceStopping()) {
                    return;
                }
                pollContext.accept(this.getPollItemConsumer((Result<InputStream, NetsuiteSoapAttributes>)Result.builder().output((Object)new ByteArrayInputStream(((String)((org.mule.runtime.extension.api.runtime.operation.Result)records.get(i)).getOutput()).getBytes())).attributes(((org.mule.runtime.extension.api.runtime.operation.Result)records.get(0)).getAttributes().orElse(null)).build(), watermarkField));
            }
            if (pollContext.isSourceStopping()) {
                return;
            }
            records = searchResults.getPage((Object)this.connection);
        }
    }

    private String formatSince(String value) {
        ZonedDateTime fromDateTime = ZonedDateTime.parse(value, MULE_DATETIME_FORMAT);
        return ZonedDateTime.ofInstant(fromDateTime.toInstant(), ZONE_ID).format(MULE_DATETIME_FORMAT);
    }

    protected Consumer<PollContext.PollItem<InputStream, NetsuiteSoapAttributes>> getPollItemConsumer(Result<InputStream, NetsuiteSoapAttributes> record, String field) {
        String outputString = IOUtils.toString((InputStream)((InputStream)record.getOutput()));
        InputStream output = this.getConnection().getDocumentFactory().transform(FilteringUtils.getOutputScript("%dw 2.0\noutput application/xml\nns xsi http://www.w3.org/2001/XMLSchema-instance\nns platformCore urn:core_2020_2.platform.webservices.netsuite.com\nns ns01 TYPE_NS\nfun getKey(value) =\n    (value.@xsi#'type' splitBy  ':')[1] ++ '__' ++ value.@scriptId ++ '__' ++ value.@internalId\nvar payload = RECORD_EXP\n\nfun element(value, key, namespace) = {\n    namespace#\"$key\" @((value.@)): recursive(value, value.#)\n}\n\nfun mapCustomFields(payload, namespace) = (if (payload.customFieldList != null) {\n    namespace#customFieldList: payload.customFieldList mapObject ((value , key, index) -> mapCustomField(value, key, index))\n      } else {})\n\nfun mapMultiSelectField(value) = \n{\n    platformCore#\"$(getKey(value))\": value mapObject ((item) -> {\n        platformCore#value @((item.@)): item\n    })\n}\n\nfun mapSelectField(value) = \n{\n    platformCore#\"$(getKey(value))\" @((value.value.@)): value.value\n}\n\nfun mapCustomField(value, key, index) =\n(getKey(value) splitBy  '__')[0] match {\n    case is 'SelectCustomFieldRef' -> mapSelectField(value)\n    case is 'MultiSelectCustomFieldRef' -> mapMultiSelectField(value)\n    else -> {\n        platformCore#\"$(getKey(value))\": value.value \n    }\n}\nfun recursive(payload, namespace) =\n  payload match {\n      case is Object -> ((payload - 'customFieldList') mapObject ((value, key1, index) -> element(value, key1, value.#))) ++ \n      mapCustomFields(payload, payload.customFieldList.#)\n      else -> payload\n  }\n\nfun mapValue(payload) =\n  payload match {\n      case is Array -> ((payload - 'customFieldList') mapObject ((value, key1, index) -> element(value, key1, value.#))) ++ \n      mapCustomFields(payload, payload.customFieldList.#)\n      else -> payload\n  }\n\nfun mapRecord(payload, rec) = {\n    record : rec ++\n       ns01#customFieldList: payload.record.customFieldList mapObject ((value , key, index) -> {\n           platformCore#\"$(getKey(value))\": value \n       })\n}\n---\nplatformCore#record @((payload.record.@)): recursive(payload.record, payload.record.#)\n", this.recordType, DW_RECORD_EXTRACTION), this.getInputStream(outputString));
        Map<String, Object> recordSourceVars = this.getConnection().getDocumentFactory().transformToMap(EXTRACT_ID_AND_WATERMARK.replaceAll("DATE_FIELD", field), this.getInputStream(outputString));
        return item -> {
            item.setResult(Result.builder().output((Object)output).mediaType(MediaType.APPLICATION_XML).attributes(record.getAttributes().get()).build());
            item.setId(recordSourceVars.get("id").toString());
            item.setWatermark((Serializable)((Object)recordSourceVars.get("watermark").toString()));
        };
    }

    private InputStream getInputStream(String outputString) {
        try {
            return org.apache.commons.io.IOUtils.toInputStream((String)outputString, (String)"utf-8");
        }
        catch (IOException e) {
            throw new NetSuiteSoapModuleException("Error processing payload", NetSuiteSoapErrorType.TRANSFORMATION);
        }
    }

    protected abstract String getSearchField(CitizenSourceRecordEnum var1);

    private InputStream bodyRequest(CitizenSourceRecordEnum searchEnum, String since) throws ParserConfigurationException, TransformerException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        documentBuilderFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        Document document = documentBuilderFactory.newDocumentBuilder().newDocument();
        String messagesNS = "urn:messages_2020_2.platform.webservices.netsuite.com";
        String commonNS = "urn:common_2020_2.platform.webservices.netsuite.com";
        Element searchBody = document.createElementNS(messagesNS, "search");
        document.appendChild(searchBody);
        searchBody.setAttribute("xmlns:common", "urn:common_2020_2.platform.webservices.netsuite.com");
        Element searchRecord = document.createElementNS(messagesNS, "searchRecord");
        searchRecord.setAttribute("xsi:type", "common:" + searchEnum.getSearchType(CitizenRecordEnum.valueOf(searchEnum.name()).getQName()));
        searchRecord.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        searchBody.appendChild(searchRecord);
        Element dateCreated = document.createElementNS(commonNS, this.getSearchField(searchEnum));
        dateCreated.setAttribute("operator", "within");
        searchRecord.appendChild(dateCreated);
        Element searchValue = document.createElement("searchValue");
        searchValue.setTextContent(since);
        dateCreated.appendChild(searchValue);
        Element searchValue2 = document.createElement("searchValue2");
        searchValue2.setTextContent(ZonedDateTime.ofInstant(Instant.now(), ZONE_ID).format(MULE_DATETIME_FORMAT));
        dateCreated.appendChild(searchValue2);
        if (searchEnum.getType() != null) {
            Element type = document.createElementNS(commonNS, "type");
            type.setAttribute("operator", "anyOf");
            Element typeSearchValue = document.createElement("searchValue");
            typeSearchValue.setTextContent(searchEnum.getType());
            type.appendChild(typeSearchValue);
            searchRecord.appendChild(type);
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(new DOMSource(document), new StreamResult(outputStream));
        return new ByteArrayInputStream(outputStream.toByteArray());
    }

    public NetSuiteSoapConnection getConnection() {
        return this.connection;
    }
}

