/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.netsuite.internal.citizen.util;

import com.mulesoft.connector.netsuite.internal.citizen.metadata.CitizenMetadataRecordResolver;
import com.mulesoft.connector.netsuite.internal.citizen.metadata.CitizenRecordEnum;
import com.mulesoft.connector.netsuite.internal.error.NetSuiteSoapErrorType;
import com.mulesoft.connector.netsuite.internal.error.exception.NetSuiteSoapModuleException;
import com.mulesoft.connector.netsuite.internal.metadata.factory.CachedXmlTypeLoader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.StringUtils;
import org.mule.metadata.api.builder.AttributeFieldTypeBuilder;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectFieldTypeBuilder;
import org.mule.metadata.api.builder.ObjectKeyBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.xml.api.SchemaCollector;
import org.mule.metadata.xml.api.XmlTypeLoader;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.util.LazyValue;
import org.mule.wsdl.parser.WsdlSchemasCollector;

public final class CitizenMetadataUtils {
    public static final String WSDL_NETSUITE_WSDL = "wsdl/netsuite.wsdl";
    private static final LazyValue<XmlTypeLoader> typeLoader = new LazyValue(() -> {
        try {
            Definition def = WSDLFactory.newInstance().newWSDLReader().readWSDL(Thread.currentThread().getContextClassLoader().getResource(WSDL_NETSUITE_WSDL).toString());
            WsdlSchemasCollector wsdlSchemasCollector = new WsdlSchemasCollector(def, "UTF-8");
            Map schemas = wsdlSchemasCollector.toInMemorySchemaMap();
            SchemaCollector schemaCollector = SchemaCollector.getInstance();
            schemas.keySet().stream().filter(path -> path.endsWith(".xsd")).forEach(path -> {
                try {
                    schemaCollector.addSchema(new URL((String)path));
                }
                catch (MalformedURLException e) {
                    throw new NetSuiteSoapModuleException("Unable to process schema files.", NetSuiteSoapErrorType.NETSUITE_ERROR);
                }
            });
            return new CachedXmlTypeLoader(schemaCollector);
        }
        catch (WSDLException e) {
            throw new NetSuiteSoapModuleException("Unable to process schema files.", NetSuiteSoapErrorType.NETSUITE_ERROR);
        }
    });

    private CitizenMetadataUtils() {
    }

    public static void unwrapRootFieldAndMap(MetadataContext context, ObjectTypeBuilder builder, ObjectType objectType, String fieldName, String wsdlVersion, String record) throws ConnectionException, MetadataResolvingException {
        ObjectFieldType rootField = (ObjectFieldType)objectType.getFields().iterator().next();
        ObjectType rootValue = (ObjectType)rootField.getValue();
        ObjectTypeBuilder objectBuilder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.XML).objectType().label(fieldName);
        List mappedFields = rootValue.getFields().stream().map(field -> CitizenMetadataUtils.mapField(field, objectBuilder)).collect(Collectors.toList());
        rootValue.getFields().clear();
        rootValue.getFields().addAll(mappedFields);
        CitizenMetadataRecordResolver resolver = new CitizenMetadataRecordResolver(context);
        resolver.generateCustomMetadataTypes(record, rootField);
        ObjectFieldTypeBuilder newFieldBuilder = builder.addField();
        QName name = new QName(String.format("urn:core_%s.platform.webservices.netsuite.com", wsdlVersion), fieldName);
        CitizenMetadataUtils.mapKey(newFieldBuilder, rootField, name);
        newFieldBuilder.value((MetadataType)rootValue);
    }

    public static MetadataType loadMetaData(MetadataContext context, String key) throws MetadataResolvingException {
        if (StringUtils.isBlank((CharSequence)key)) {
            throw new MetadataResolvingException("Record type must be set", FailureCode.INVALID_METADATA_KEY);
        }
        try {
            String qName = CitizenRecordEnum.valueOf(key).getQName();
            Optional metadata = ((XmlTypeLoader)CitizenMetadataUtils.getTypeLoader().get()).load(qName);
            ObjectType type = (ObjectType)metadata.orElseThrow(() -> new MetadataResolvingException("Could not find record type metadata", FailureCode.INVALID_METADATA_KEY));
            ObjectTypeBuilder objectBuilder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.XML).objectType().label(key);
            CitizenMetadataUtils.unwrapRootFieldAndMap(context, objectBuilder, type, "record", "2020_2", key);
            return objectBuilder.build();
        }
        catch (IllegalArgumentException | ConnectionException iae) {
            throw new MetadataResolvingException("Unsupported record type: " + key, FailureCode.INVALID_METADATA_KEY);
        }
    }

    public static ObjectFieldType mapField(ObjectFieldType field, ObjectTypeBuilder builder) {
        ObjectFieldTypeBuilder newFieldBuilder = builder.addField();
        CitizenMetadataUtils.mapKey(newFieldBuilder, field, field.getKey().getName());
        if (field.getValue() instanceof ObjectType) {
            ObjectTypeBuilder objectBuilder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.XML).objectType();
            Collection childFields = ((ObjectType)field.getValue()).getFields();
            List<ObjectFieldType> fields = childFields.stream().map(childField -> CitizenMetadataUtils.mapField(childField, objectBuilder)).collect(Collectors.toList());
            childFields.clear();
            fields.forEach(field1 -> childFields.add(field1));
        }
        field.getValue().getAnnotations().forEach(annotation -> newFieldBuilder.with(annotation));
        field.getDescription().ifPresent(description -> newFieldBuilder.description(description));
        return newFieldBuilder.value(field.getValue()).build();
    }

    public static void mapKey(ObjectFieldTypeBuilder fieldTypeBuilder, ObjectFieldType field, QName name) {
        field.getKey().getAnnotations().stream().forEach(annotation -> fieldTypeBuilder.withKeyAnnotation(annotation));
        ObjectKeyBuilder key = fieldTypeBuilder.key(name);
        fieldTypeBuilder.label(CitizenMetadataUtils.getLabel(name));
        fieldTypeBuilder.required(field.isRequired());
        fieldTypeBuilder.repeated(field.isRepeated());
        CitizenMetadataUtils.copyKeyAttributes(field, key);
    }

    public static String getLabel(QName name) {
        return Arrays.stream(StringUtils.splitByCharacterTypeCamelCase((String)name.getLocalPart())).map(word -> StringUtils.capitalize((String)word)).collect(Collectors.joining(" "));
    }

    public static void copyKeyAttributes(ObjectFieldType field, ObjectKeyBuilder key) {
        field.getKey().getAttributes().forEach(attr -> {
            AttributeFieldTypeBuilder attrBuilder = key.addAttribute().name(attr.getKey().getName());
            attrBuilder.required(attr.isRequired());
            attrBuilder.value().stringType();
            if (attr.getKey().isPattern()) {
                attrBuilder.pattern(attr.getKey().getPattern());
            }
        });
    }

    public static LazyValue<XmlTypeLoader> getTypeLoader() {
        return typeLoader;
    }
}

