/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.netsuite.internal.citizen.util;

import com.mulesoft.connector.netsuite.internal.citizen.metadata.CitizenRecordEnum;

public class FilteringUtils {
    private static final String NS_PLACEHOLDER = "TYPE_NS";
    private static final String RECORD_PLACEHOLDER = "RECORD_EXP";
    public static final String OUTPUT_SCRIPT = "%dw 2.0\noutput application/xml\nns xsi http://www.w3.org/2001/XMLSchema-instance\nns platformCore urn:core_2020_2.platform.webservices.netsuite.com\nns ns01 TYPE_NS\nfun getKey(value) =\n    (value.@xsi#'type' splitBy  ':')[1] ++ '__' ++ value.@scriptId ++ '__' ++ value.@internalId\nvar payload = RECORD_EXP\n\nfun element(value, key, namespace) = {\n    namespace#\"$key\" @((value.@)): recursive(value, value.#)\n}\n\nfun mapCustomFields(payload, namespace) = (if (payload.customFieldList != null) {\n    namespace#customFieldList: payload.customFieldList mapObject ((value , key, index) -> mapCustomField(value, key, index))\n      } else {})\n\nfun mapMultiSelectField(value) = \n{\n    platformCore#\"$(getKey(value))\": value mapObject ((item) -> {\n        platformCore#value @((item.@)): item\n    })\n}\n\nfun mapSelectField(value) = \n{\n    platformCore#\"$(getKey(value))\" @((value.value.@)): value.value\n}\n\nfun mapCustomField(value, key, index) =\n(getKey(value) splitBy  '__')[0] match {\n    case is 'SelectCustomFieldRef' -> mapSelectField(value)\n    case is 'MultiSelectCustomFieldRef' -> mapMultiSelectField(value)\n    else -> {\n        platformCore#\"$(getKey(value))\": value.value \n    }\n}\nfun recursive(payload, namespace) =\n  payload match {\n      case is Object -> ((payload - 'customFieldList') mapObject ((value, key1, index) -> element(value, key1, value.#))) ++ \n      mapCustomFields(payload, payload.customFieldList.#)\n      else -> payload\n  }\n\nfun mapValue(payload) =\n  payload match {\n      case is Array -> ((payload - 'customFieldList') mapObject ((value, key1, index) -> element(value, key1, value.#))) ++ \n      mapCustomFields(payload, payload.customFieldList.#)\n      else -> payload\n  }\n\nfun mapRecord(payload, rec) = {\n    record : rec ++\n       ns01#customFieldList: payload.record.customFieldList mapObject ((value , key, index) -> {\n           platformCore#\"$(getKey(value))\": value \n       })\n}\n---\nplatformCore#record @((payload.record.@)): recursive(payload.record, payload.record.#)\n";

    private FilteringUtils() {
    }

    public static String getSampleDataTransformationScript(String script) {
        StringBuilder expressionBuilder = new StringBuilder(script);
        return expressionBuilder.append(")\n --- \n if (payload.record.@externalId != null)  {\n     record @(\n         internalId: payload.record.@internalId, \n         externalId: payload.record.@externalId,\n         xsi#'type': payload.record.@'type'): filterObject(record).record\n } else {\n     record @(\n         internalId: payload.record.@internalId, \n         xsi#'type': payload.record.@'type'): filterObject(record).record\n }").toString();
    }

    public static String getOutputScript(String outputScript, String recordType, String dwRecordExtraction) {
        return outputScript.replace(NS_PLACEHOLDER, CitizenRecordEnum.valueOf(recordType).getNamespace()).replace(RECORD_PLACEHOLDER, dwRecordExtraction);
    }
}

