/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.netsuite.internal.connection;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.mulesoft.connector.netsuite.api.NetsuiteSoapAttributes;
import com.mulesoft.connector.netsuite.internal.config.NetSuiteSoapConfig;
import com.mulesoft.connector.netsuite.internal.connection.HttpMessageDispatcher;
import com.mulesoft.connector.netsuite.internal.error.NetSuiteSoapErrorType;
import com.mulesoft.connector.netsuite.internal.error.exception.NetSuiteSoapModuleException;
import com.mulesoft.connector.netsuite.internal.error.exception.NetsuiteTransformationException;
import com.mulesoft.connector.netsuite.internal.error.provider.NetSuiteErrorTypeProvider;
import com.mulesoft.connector.netsuite.internal.model.RecordRefAndTypeParameterGroup;
import com.mulesoft.connector.netsuite.internal.util.NetsuiteDocumentFactory;
import com.mulesoft.connector.netsuite.internal.util.Timer;
import com.mulesoft.connector.netsuite.internal.xml.XmlTransformation;
import com.mulesoft.connectors.commons.template.connection.ConnectorConnection;
import com.predic8.schema.SchemaComponent;
import com.predic8.wsdl.Definitions;
import com.predic8.wsdl.WSDLParser;
import com.predic8.wsdl.WSDLParserContext;
import com.predic8.xml.util.ClasspathResolver;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.format.DateTimeFormatter;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.XMLEvent;
import javax.xml.transform.TransformerException;
import org.apache.commons.io.IOUtils;
import org.mule.runtime.api.el.MuleExpressionLanguage;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.transformation.TransformationService;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.core.api.util.xmlsecurity.XMLSecureFactories;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.soap.api.client.SoapClient;
import org.mule.soap.api.exception.SoapFaultException;
import org.mule.soap.api.message.SoapRequest;
import org.mule.soap.api.message.SoapResponse;
import org.mule.soap.api.transport.TransportDispatcher;
import org.mule.wsdl.parser.WsdlParser;
import org.mule.wsdl.parser.model.WsdlModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class NetSuiteSoapConnection
implements ConnectorConnection {
    public static DataType DEFAULT_BODY_DATA_TYPE = DataType.builder().type(InputStream.class).mediaType(MediaType.XML).build();
    private static final Logger logger = LoggerFactory.getLogger(NetSuiteSoapConnection.class);
    public static final DateTimeFormatter DATETIME_FORMAT_TO_NETSUITE = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    public static final DateTimeFormatter DATETIME_FORMAT_FROM_NETSUITE = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    public static final String LOCAL_WSDL_FOLDER = "/wsdl/";
    public static final String LOCAL_WSDL_FILE = "netsuite.wsdl";
    private final HttpClient httpClient;
    private final SoapClient soapClient;
    private final String endpoint;
    private final Supplier<MultiMap<String, String>> headersSupplier;
    private final Supplier<String> wsdlUrlSupplier;
    private final Integer responseTimeout;
    private LazyValue<WsdlModel> wsdlModel = new LazyValue(this::loadWsdlModel);
    private final LazyValue<Definitions> wsdlDefinitions = new LazyValue(this::loadWSDLDefinitions);
    private final LazyValue<Map<String, String>> schemaMappings = new LazyValue(this::loadSchemaMappings);
    private final LazyValue<Map<String, String>> complexTypesMapping = new LazyValue(this::loadComplexTypesMappings);
    private NetsuiteDocumentFactory documentFactory;
    private XMLSecureFactories xmlSecureFactories = XMLSecureFactories.createDefault();

    public NetSuiteSoapConnection(HttpClient httpClient, SoapClient soapClient, String endpoint, Supplier<MultiMap<String, String>> headersSupplier, Supplier<String> wsdlUrlSupplier, Integer responseTimeout, String wsdlVersion, MuleExpressionLanguage expressionExecutor, TransformationService transformationService) {
        this.httpClient = httpClient;
        this.soapClient = soapClient;
        this.endpoint = endpoint;
        this.headersSupplier = headersSupplier;
        this.wsdlUrlSupplier = wsdlUrlSupplier;
        this.responseTimeout = responseTimeout;
        this.documentFactory = new NetsuiteDocumentFactory(wsdlVersion, expressionExecutor, transformationService);
    }

    public void disconnect() {
    }

    public void validate() {
        logger.debug("Validating Connection ");
        Result<InputStream, NetsuiteSoapAttributes> serverTime = this.invokeWithoutBody(null, "getServerTime");
        try (InputStream value = (InputStream)serverTime.getOutput();){
            String response = IOUtils.toString((InputStream)value, (Charset)StandardCharsets.UTF_8);
            logger.debug(response);
        }
        catch (IOException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Could not validate connection"), (Throwable)e);
        }
        logger.debug("Validated Connection successfully");
    }

    public Result<InputStream, NetsuiteSoapAttributes> invokeWithHeaderPreferences(NetSuiteSoapConfig config, String operation, String searchPreferencesHeader, InputStream message, boolean useEndpointFromWsdl) {
        logger.debug("Invoking with config={},operation={}", (Object)config, (Object)operation);
        String preferencesHeaderXml = null;
        try {
            if (config != null) {
                Document preferencesDocument = this.documentFactory.generateXmlHeaderPreferences(config.getPreferences());
                preferencesHeaderXml = this.documentFactory.convertToString(preferencesDocument);
            }
        }
        catch (IOException | ParserConfigurationException | TransformerException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
        return this.invoke(operation, preferencesHeaderXml, searchPreferencesHeader, message, useEndpointFromWsdl);
    }

    public Result<InputStream, NetsuiteSoapAttributes> invoke(String operation, String preferencesXmlHeaders, String searchPreferencesHeader, InputStream message, boolean useEndpointFromWsdl) {
        Timer overallTime = Timer.fromNow();
        try {
            InputStream outboundInputStream = null;
            Timer outboundTimer = Timer.fromNow();
            try {
                outboundInputStream = this.trasnformOutbound(message);
                logger.debug("Took {} to process the outbound message", (Object)outboundTimer.measure());
            }
            catch (IOException e) {
                throw new NetsuiteTransformationException(String.format("Could not read from the input of the operation %s (took %s ms),", operation, outboundTimer.measure()), e);
            }
            SoapResponse response = null;
            logger.debug("Building SOAP request ");
            logger.debug("Adding SOAP request headers.");
            MultiMap<String, String> headers = this.headersSupplier.get();
            if (!Strings.isNullOrEmpty((String)preferencesXmlHeaders)) {
                headers.put((Object)"Preferences", (Object)preferencesXmlHeaders);
            }
            if (!Strings.isNullOrEmpty((String)searchPreferencesHeader)) {
                headers.put((Object)"searchPreferences", (Object)searchPreferencesHeader);
            }
            logger.debug("Sending SOAP request.");
            try {
                response = this.soapClient.consume((SoapRequest)SoapRequest.builder().operation(operation).soapHeaders(headers).content(outboundInputStream).contentType(MediaType.XML.toRfcString()).build(), (TransportDispatcher)new HttpMessageDispatcher(this.httpClient, useEndpointFromWsdl ? null : this.endpoint, this.responseTimeout, (MultiMap<String, String>)new MultiMap(), (MultiMap<String, String>)new MultiMap()));
            }
            catch (SoapFaultException e) {
                throw this.parseSoapFault(e);
            }
            Timer inboundTimer = Timer.fromNow();
            try {
                InputStream resultsOutput = this.trasnformInbound(this.parseResponse(response.getContent()));
                Result result = Result.builder().output((Object)resultsOutput).mediaType(MediaType.parse((String)response.getContentType())).attributes((Object)new NetsuiteSoapAttributes(response.getTransportHeaders(), response.getTransportAdditionalData(), NetSuiteSoapConnection.wrapHeaders(response.getSoapHeaders()))).build();
                return result;
            }
            catch (IOException e) {
                throw new NetsuiteTransformationException(String.format("Could not read from the inbound message for the operation %s (took %s ms),", operation, inboundTimer.measure()), e);
            }
        }
        finally {
            logger.debug("Took {} to process the soap invocation for operation {}", (Object)overallTime.measure(), (Object)operation);
        }
    }

    protected InputStream trasnformOutbound(InputStream message) throws IOException {
        if (message.available() < 1) {
            return message;
        }
        try {
            return XmlTransformation.transformOutbound(message);
        }
        catch (Exception e) {
            throw new NetsuiteTransformationException(e);
        }
    }

    protected InputStream trasnformInbound(InputStream message) throws IOException {
        if (message.available() < 1) {
            return message;
        }
        try {
            return XmlTransformation.transformInbound(message);
        }
        catch (Exception e) {
            throw new NetsuiteTransformationException(e);
        }
    }

    @VisibleForTesting
    protected NetSuiteSoapModuleException parseSoapFault(SoapFaultException soapFaultException) {
        try {
            if (!soapFaultException.getDetail().equals("<?xml version=\"1.0\" encoding=\"UTF-8\"?>")) {
                ByteArrayInputStream stream = new ByteArrayInputStream(soapFaultException.getDetail().getBytes());
                XMLEventReader reader = this.xmlSecureFactories.getXMLInputFactory().createXMLEventReader(stream);
                String errorCode = null;
                while (reader.hasNext()) {
                    XMLEvent event = reader.nextEvent();
                    if (!event.isStartElement() || !event.asStartElement().getName().getLocalPart().equals("code")) continue;
                    errorCode = reader.nextEvent().asCharacters().getData();
                    break;
                }
                return new NetSuiteSoapModuleException(NetSuiteErrorTypeProvider.getErrorType(errorCode), soapFaultException.getReason(), soapFaultException.getDetail());
            }
            return new NetSuiteSoapModuleException(NetSuiteSoapErrorType.NETSUITE_SOAP_FAULT, "Endpoint not found: invalid SOAP port", "Endpoint not found. Check the SOAP port in Connector configuration");
        }
        catch (XMLStreamException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    @VisibleForTesting
    protected InputStream parseResponse(InputStream content) {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new DataInputStream(content), 10240){

            @Override
            public void close() throws IOException {
            }
        };
        bufferedInputStream.mark(0);
        try {
            XMLEventReader reader = this.xmlSecureFactories.getXMLInputFactory().createXMLEventReader(bufferedInputStream);
            String errorCode = null;
            String errorMessage = null;
            while (reader.hasNext()) {
                Attribute isSuccessAttribute;
                XMLEvent event = reader.nextEvent();
                if (!event.isStartElement()) continue;
                String localPart = event.asStartElement().getName().getLocalPart();
                if (localPart.equals("status") && ((isSuccessAttribute = event.asStartElement().getAttributeByName(QName.valueOf("isSuccess"))) == null || Boolean.parseBoolean(isSuccessAttribute.getValue()))) {
                    bufferedInputStream.reset();
                    return bufferedInputStream;
                }
                errorCode = this.setErrorMessage(reader, errorCode, localPart, "code");
                errorMessage = this.setErrorMessage(reader, errorMessage, localPart, "message");
            }
            bufferedInputStream.reset();
            String exceptionDetail = IOUtils.toString((InputStream)bufferedInputStream, (Charset)StandardCharsets.UTF_8);
            bufferedInputStream.close();
            throw new NetSuiteSoapModuleException(NetSuiteSoapErrorType.NETSUITE_ERROR, errorCode, errorMessage, exceptionDetail);
        }
        catch (IOException | XMLStreamException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    private String setErrorMessage(XMLEventReader reader, String errorMessage, String localPart, String message) throws XMLStreamException {
        if (localPart.equals(message)) {
            errorMessage = reader.nextEvent().asCharacters().getData();
        }
        return errorMessage;
    }

    public Result<InputStream, NetsuiteSoapAttributes> get(NetSuiteSoapConfig config, RecordRefAndTypeParameterGroup key, InputStream message) {
        try {
            Document doc = this.documentFactory.get(message, key);
            return this.doInvoke(config, () -> doc, "get");
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new NetsuiteTransformationException(e);
        }
    }

    public Result<InputStream, NetsuiteSoapAttributes> getAll(NetSuiteSoapConfig config, String recordType) {
        return this.doInvoke(config, () -> this.documentFactory.getRecords(recordType), "getAll");
    }

    public Result<InputStream, NetsuiteSoapAttributes> getSavedSearch(NetSuiteSoapConfig config, String searchType) {
        return this.doInvoke(config, () -> this.documentFactory.getSavedSearch(searchType), "getSavedSearch");
    }

    public Result<InputStream, NetsuiteSoapAttributes> search(InputStream message, boolean bodyFieldsOnly, boolean returnSearchColumns, int pageSize) {
        return this.doInvokeWithSearchPreferences("search", message, bodyFieldsOnly, returnSearchColumns, pageSize);
    }

    public Result<InputStream, NetsuiteSoapAttributes> searchMoreWithId(String searchId, Integer pageIndex, boolean bodyFieldsOnly, boolean returnSearchColumns, int pageSize) {
        return this.doInvokeWithSearchPreferences("searchMoreWithId", () -> this.documentFactory.searchMoreWithId(searchId, pageIndex), bodyFieldsOnly, returnSearchColumns, pageSize);
    }

    public Result<InputStream, NetsuiteSoapAttributes> asyncSearch(InputStream message, boolean bodyFieldsOnly, boolean returnSearchColumns, int pageSize) {
        return this.doInvokeWithSearchPreferences("asyncSearch", message, bodyFieldsOnly, returnSearchColumns, pageSize);
    }

    public Result<InputStream, NetsuiteSoapAttributes> changeEmail(NetSuiteSoapConfig config, String newEmail, String currentCredentials, boolean justThisAccount) {
        return this.doInvoke(config, () -> this.documentFactory.changeEmail(newEmail, currentCredentials, justThisAccount), "changeEmail");
    }

    public Result<InputStream, NetsuiteSoapAttributes> changePassword(NetSuiteSoapConfig config, String newPassword, String currentCredentials) {
        return this.doInvoke(config, () -> this.documentFactory.changePassword(newPassword, currentCredentials), "changePassword");
    }

    public Result<InputStream, NetsuiteSoapAttributes> getAsyncResult(NetSuiteSoapConfig config, String jobId, Integer pageIndex) {
        return this.doInvoke(config, () -> this.documentFactory.getAsyncResult(jobId, pageIndex), "getAsyncResult");
    }

    public Result<InputStream, NetsuiteSoapAttributes> checkAsyncStatus(NetSuiteSoapConfig config, String jobId) {
        return this.doInvoke(config, () -> this.documentFactory.checkAsyncStatus(jobId), "checkAsyncStatus");
    }

    public Result<InputStream, NetsuiteSoapAttributes> getDeleted(NetSuiteSoapConfig config, InputStream message) {
        return this.invokeWithHeaderPreferences(config, "getDeleted", null, message, false);
    }

    public Result<InputStream, NetsuiteSoapAttributes> getDataCenterUrls(String accountId) {
        return this.doInvokeWithoutHeaderPreferences(() -> this.documentFactory.getDataCenterUrls(accountId), "getDataCenterUrls", true);
    }

    public Result<InputStream, NetsuiteSoapAttributes> getPostingTransactionSummary(NetSuiteSoapConfig config, InputStream message) {
        return this.invokeWithHeaderPreferences(config, "getPostingTransactionSummary", null, message, false);
    }

    public Result<InputStream, NetsuiteSoapAttributes> getSelectValue(NetSuiteSoapConfig config, InputStream message) {
        return this.invokeWithHeaderPreferences(config, "getSelectValue", null, message, false);
    }

    public Result<InputStream, NetsuiteSoapAttributes> invokeAdvancedOperation(NetSuiteSoapConfig config, String operation, InputStream message) {
        return this.invokeWithHeaderPreferences(config, operation, null, message, false);
    }

    public Result<InputStream, NetsuiteSoapAttributes> invokeAsyncOperation(NetSuiteSoapConfig config, String operation, InputStream message) {
        return this.invokeWithHeaderPreferences(config, operation, null, message, false);
    }

    public Result<InputStream, NetsuiteSoapAttributes> invokeInviteeOperation(NetSuiteSoapConfig config, String operation, InputStream message) {
        return this.invokeWithHeaderPreferences(config, operation, null, message, false);
    }

    public Result<InputStream, NetsuiteSoapAttributes> invokeItemOperation(NetSuiteSoapConfig config, String operation, InputStream message) {
        return this.invokeWithHeaderPreferences(config, operation, null, message, false);
    }

    public Result<InputStream, NetsuiteSoapAttributes> invokeRecordOperation(NetSuiteSoapConfig config, String operation, InputStream message) {
        return this.invokeWithHeaderPreferences(config, operation, null, message, false);
    }

    private Result<InputStream, NetsuiteSoapAttributes> doInvokeWithSearchPreferences(String operation, TransformationSupplier<Document> transformSupplier, boolean bodyFieldsOnly, boolean returnSearchColumns, int pageSize) {
        try {
            Document document = transformSupplier.get();
            InputStream message = this.documentFactory.transformToInputStream(document);
            return this.doInvokeWithSearchPreferences(operation, message, bodyFieldsOnly, returnSearchColumns, pageSize);
        }
        catch (ParserConfigurationException | TransformerException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    private Result<InputStream, NetsuiteSoapAttributes> doInvokeWithSearchPreferences(String operation, InputStream message, boolean bodyFieldsOnly, boolean returnSearchColumns, int pageSize) {
        try {
            String searchPreferences = this.documentFactory.convertToString(this.documentFactory.generateXmlSearchPreferences(bodyFieldsOnly, returnSearchColumns, pageSize));
            return this.invokeWithHeaderPreferences(null, operation, searchPreferences, message, false);
        }
        catch (IOException | ParserConfigurationException | TransformerException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    private Result<InputStream, NetsuiteSoapAttributes> doInvoke(NetSuiteSoapConfig config, TransformationSupplier<Document> transformSupplier, String operation) {
        return this.doInvoke(config, transformSupplier, operation, false);
    }

    private Result<InputStream, NetsuiteSoapAttributes> doInvokeWithoutHeaderPreferences(TransformationSupplier<Document> transformSupplier, String operation, boolean useEndpointFromWsdl) {
        try {
            Document document = transformSupplier.get();
            InputStream message = this.documentFactory.transformToInputStream(document);
            return this.invoke(operation, null, null, message, useEndpointFromWsdl);
        }
        catch (ParserConfigurationException | TransformerException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    private Result<InputStream, NetsuiteSoapAttributes> doInvoke(NetSuiteSoapConfig config, TransformationSupplier<Document> transformSupplier, String operation, boolean useEndpointFromWsdl) {
        try {
            Document document = transformSupplier.get();
            InputStream message = this.documentFactory.transformToInputStream(document);
            return this.invokeWithHeaderPreferences(config, operation, null, message, useEndpointFromWsdl);
        }
        catch (ParserConfigurationException | TransformerException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    public Result<InputStream, NetsuiteSoapAttributes> invokeWithoutBody(NetSuiteSoapConfig config, String operation) {
        return this.doInvoke(config, () -> this.documentFactory.generateOperationEmptyBody(operation), operation, false);
    }

    public NetsuiteDocumentFactory getDocumentFactory() {
        return this.documentFactory;
    }

    public LazyValue<Map<String, String>> getSchemaMap() {
        return this.schemaMappings;
    }

    public Definitions getDefinitions() {
        return (Definitions)this.wsdlDefinitions.get();
    }

    public WsdlModel getWsdlModel() {
        return (WsdlModel)this.wsdlModel.get();
    }

    @VisibleForTesting
    protected WsdlModel loadWsdlModel() {
        logger.debug("Creating WsdlModel for {}.", (Object)this.wsdlUrlSupplier.get());
        WsdlModel wsdl = WsdlParser.Companion.parse(this.wsdlUrlSupplier.get(), StandardCharsets.UTF_8.name());
        logger.debug("Created WsdlModel for {}.", (Object)this.wsdlUrlSupplier.get());
        return wsdl;
    }

    @VisibleForTesting
    protected Definitions loadWSDLDefinitions() {
        Definitions definitions;
        logger.debug("Loading WSDL model (Predic8)");
        try {
            definitions = this.loadLocalWsdlDefinitions();
        }
        catch (IOException e) {
            logger.debug("Failed to load  WSDL model (Predic8) from local schema files", (Throwable)e);
            logger.debug("Loading WSDL model (Predic8) from remote location {}.", (Object)this.wsdlUrlSupplier.get());
            definitions = new WSDLParser().parse("https://webservices.netsuite.com/wsdl/v2020_2_0/netsuite.wsdl");
            logger.debug("Loaded WSDL model (Predic8) from remote location {}.", (Object)this.wsdlUrlSupplier.get());
        }
        return definitions;
    }

    @VisibleForTesting
    protected Definitions loadRemoteWsdlDefinitions() throws IOException {
        logger.debug("Loading WSDL model (Predic8) from remote schema files");
        Definitions definitions = new WSDLParser().parse("https://webservices.netsuite.com/wsdl/v2020_2_0/netsuite.wsdl");
        logger.debug("Loaded WSDL model (Predic8) from remote schema files");
        return definitions;
    }

    @VisibleForTesting
    protected Definitions loadLocalWsdlDefinitions() throws IOException {
        logger.debug("Loading WSDL model (Predic8) from local schema files");
        ClasspathResolver classpathResolver = new ClasspathResolver();
        WSDLParser parser = new WSDLParser();
        parser.setResourceResolver((Object)classpathResolver);
        WSDLParserContext ctx = new WSDLParserContext();
        ctx.setBaseDir(LOCAL_WSDL_FOLDER);
        try (InputStream wsdlStream = this.getClass().getResourceAsStream("/wsdl/netsuite.wsdl");){
            ctx.setInput((Object)wsdlStream);
            Definitions definitions = parser.parse(ctx);
            logger.debug("Loaded WSDL model (Predic8) from local schema files");
            Definitions definitions2 = definitions;
            return definitions2;
        }
    }

    private Map<String, String> loadSchemaMappings() {
        return this.getDefinitions().getSchemas().stream().flatMap(e -> e.getAllElements().stream()).distinct().collect(Collectors.toMap(SchemaComponent::getName, e -> e.getType().getNamespaceURI()));
    }

    private Map<String, String> loadComplexTypesMappings() {
        HashSet uniques = new HashSet();
        return this.getDefinitions().getSchemas().stream().flatMap(schema -> schema.getComplexTypes().stream()).filter(complexType -> uniques.add(complexType.getName())).collect(Collectors.toMap(SchemaComponent::getName, e -> e.getQname().getNamespaceURI()));
    }

    public LazyValue<Map<String, String>> getComplexTypesMap() {
        return this.complexTypesMapping;
    }

    private static Map<String, TypedValue<String>> wrapHeaders(Map<String, String> headers) {
        ImmutableMap.Builder wrapped = ImmutableMap.builder();
        headers.forEach((k, v) -> wrapped.put(k, (Object)new TypedValue(v, DataType.XML_STRING)));
        return wrapped.build();
    }

    protected static interface TransformationSupplier<T> {
        public T get() throws ParserConfigurationException, TransformerException;
    }
}

