/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.netsuite.internal.metadata;

import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.wsdl.parser.model.PortModel;
import org.mule.wsdl.parser.model.ServiceModel;
import org.mule.wsdl.parser.model.WsdlModel;
import org.mule.wsdl.parser.model.operation.OperationModel;
import org.mule.wsdl.parser.model.operation.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMetadataRetriever {
    private static final Logger logger = LoggerFactory.getLogger(DefaultMetadataRetriever.class);
    public static final String NET_SUITE_SERVICE = "NetSuiteService";
    private WsdlModel wsdlModel;

    public DefaultMetadataRetriever(WsdlModel wsdlModel) {
        this.wsdlModel = wsdlModel;
    }

    public Type getInputType(String operationName) throws ConnectionException, MetadataResolvingException {
        OperationModel operation = this.getOperationModel(operationName);
        return operation.getInputType();
    }

    public Type getOutputType(String operationName) throws ConnectionException, MetadataResolvingException {
        logger.debug("Retrieving output metadata.");
        OperationModel operationModel = this.getOperationModel(operationName);
        return operationModel.getOutputType();
    }

    protected OperationModel getOperationModel(String operationName) throws ConnectionException, MetadataResolvingException {
        logger.debug("Retrieving OperationModel.");
        return this.getOperationModel(operationName, NET_SUITE_SERVICE);
    }

    protected OperationModel getOperationModel(String operationName, String serviceName) throws ConnectionException, MetadataResolvingException {
        logger.debug("Retrieving input metadata.");
        if (StringUtils.isBlank((CharSequence)serviceName) || StringUtils.isBlank((CharSequence)operationName)) {
            throw new MetadataResolvingException(String.format("Can't resolve metadata, both service and operation parameters are required provided service:%s , operation:%s", serviceName, operationName), FailureCode.INVALID_METADATA_KEY);
        }
        ServiceModel service = this.wsdlModel.getService(serviceName);
        if (service == null) {
            throw new MetadataResolvingException(String.format("Could not resolve metadata for service %s", serviceName), FailureCode.INVALID_METADATA_KEY);
        }
        return ((PortModel)service.getPorts().stream().findFirst().orElseThrow(() -> new MetadataResolvingException(String.format("Could not resolve metadata for service %s, there are not ports for the service", serviceName), FailureCode.INVALID_METADATA_KEY))).getOperation(operationName);
    }
}

