/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.netsuite.internal.operation;

import com.mulesoft.connector.netsuite.api.NetsuiteSoapAttributes;
import com.mulesoft.connector.netsuite.internal.config.NetSuiteSoapConfig;
import com.mulesoft.connector.netsuite.internal.connection.NetSuiteSoapConnection;
import com.mulesoft.connector.netsuite.internal.error.provider.NetSuiteMultipleErrorTypeProvider;
import com.mulesoft.connector.netsuite.internal.error.provider.NetSuiteSingleErrorTypeProvider;
import com.mulesoft.connector.netsuite.internal.metadata.RecordOperationsMetadataResolvers;
import com.mulesoft.connector.netsuite.internal.model.RecordRefAndTypeParameterGroup;
import com.mulesoft.connector.netsuite.internal.pagination.PaginatedGetDeleted;
import com.mulesoft.connector.netsuite.internal.pagination.PaginatedGetSelectValue;
import com.mulesoft.connector.netsuite.internal.pagination.PaginatedSearch;
import java.io.InputStream;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.MetadataKeyId;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.metadata.TypeResolver;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;

public class RecordOperations {
    @OutputResolver(output=RecordOperationsMetadataResolvers.AttachRecordMetadataResolver.class, attributes=RecordOperationsMetadataResolvers.AttachRecordMetadataResolver.class)
    @MediaType(value="text/xml")
    public Result<InputStream, NetsuiteSoapAttributes> attach(@Config NetSuiteSoapConfig config, @Connection NetSuiteSoapConnection connection, @Optional @MetadataKeyId(value=RecordOperationsMetadataResolvers.AttachRecordMetadataResolver.class) String attachRefType, @TypeResolver(value=RecordOperationsMetadataResolvers.AttachRecordMetadataResolver.class) @Content InputStream message) {
        return connection.invokeRecordOperation(config, "attach", message);
    }

    @OutputResolver(output=RecordOperationsMetadataResolvers.DetachRecordMetadataResolver.class, attributes=RecordOperationsMetadataResolvers.DetachRecordMetadataResolver.class)
    @MediaType(value="text/xml")
    public Result<InputStream, NetsuiteSoapAttributes> detach(@Config NetSuiteSoapConfig config, @Connection NetSuiteSoapConnection connection, @Optional @MetadataKeyId(value=RecordOperationsMetadataResolvers.DetachRecordMetadataResolver.class) String detachRefType, @TypeResolver(value=RecordOperationsMetadataResolvers.DetachRecordMetadataResolver.class) @Content InputStream message) {
        return connection.invokeRecordOperation(config, "detach", message);
    }

    @Throws(value={NetSuiteSingleErrorTypeProvider.class})
    @OutputResolver(output=RecordOperationsMetadataResolvers.GetMetadataResolver.class, attributes=RecordOperationsMetadataResolvers.GetMetadataResolver.class)
    @MediaType(value="text/xml")
    public Result<InputStream, NetsuiteSoapAttributes> get(@Config NetSuiteSoapConfig config, @Connection NetSuiteSoapConnection connection, @MetadataKeyId(value=RecordOperationsMetadataResolvers.GetMetadataResolver.class) @ParameterGroup(name="types") RecordRefAndTypeParameterGroup key, @TypeResolver(value=RecordOperationsMetadataResolvers.GetMetadataResolver.class) @Content InputStream message) {
        return connection.get(config, key, message);
    }

    @Throws(value={NetSuiteMultipleErrorTypeProvider.class})
    @OutputResolver(output=RecordOperationsMetadataResolvers.GetListMetadataResolver.class, attributes=RecordOperationsMetadataResolvers.GetListMetadataResolver.class)
    @MediaType(value="text/xml")
    public Result<InputStream, NetsuiteSoapAttributes> getList(@Config NetSuiteSoapConfig config, @Connection NetSuiteSoapConnection connection, @MetadataKeyId(value=RecordOperationsMetadataResolvers.GetListMetadataResolver.class) @ParameterGroup(name="types") RecordRefAndTypeParameterGroup key, @TypeResolver(value=RecordOperationsMetadataResolvers.GetListMetadataResolver.class) @Content InputStream message) {
        return connection.invokeRecordOperation(config, "getList", message);
    }

    @OutputResolver(output=RecordOperationsMetadataResolvers.GetAllMetadataResolver.class, attributes=RecordOperationsMetadataResolvers.GetAllMetadataResolver.class)
    @MediaType(value="text/xml")
    public Result<InputStream, NetsuiteSoapAttributes> getAll(@Config NetSuiteSoapConfig config, @Connection NetSuiteSoapConnection connection, @Optional @MetadataKeyId(value=RecordOperationsMetadataResolvers.GetAllMetadataResolver.class) String type, @TypeResolver(value=RecordOperationsMetadataResolvers.GetAllMetadataResolver.class) @Content InputStream message) {
        if (StringUtils.isNotBlank((CharSequence)type)) {
            return connection.getAll(config, type);
        }
        return connection.invokeRecordOperation(config, "getAll", message);
    }

    @Throws(value={NetSuiteSingleErrorTypeProvider.class})
    @OutputResolver(output=RecordOperationsMetadataResolvers.AddRecordMetadataResolver.class, attributes=RecordOperationsMetadataResolvers.AddRecordMetadataResolver.class)
    @MediaType(value="text/xml")
    public Result<InputStream, NetsuiteSoapAttributes> add(@Config NetSuiteSoapConfig config, @Connection NetSuiteSoapConnection connection, @MetadataKeyId(value=RecordOperationsMetadataResolvers.AddRecordMetadataResolver.class) @Optional String type, @TypeResolver(value=RecordOperationsMetadataResolvers.AddRecordMetadataResolver.class) @Content InputStream message) {
        return connection.invokeRecordOperation(config, "add", message);
    }

    @Throws(value={NetSuiteMultipleErrorTypeProvider.class})
    @OutputResolver(output=RecordOperationsMetadataResolvers.AddListMetadataResolver.class, attributes=RecordOperationsMetadataResolvers.AddListMetadataResolver.class)
    @MediaType(value="text/xml")
    public Result<InputStream, NetsuiteSoapAttributes> addList(@Config NetSuiteSoapConfig config, @Connection NetSuiteSoapConnection connection, @MetadataKeyId(value=RecordOperationsMetadataResolvers.AddListMetadataResolver.class) @Optional String type, @TypeResolver(value=RecordOperationsMetadataResolvers.AddListMetadataResolver.class) @Content InputStream message) {
        return connection.invokeRecordOperation(config, "addList", message);
    }

    @Throws(value={NetSuiteSingleErrorTypeProvider.class})
    @OutputResolver(output=RecordOperationsMetadataResolvers.UpdateRecordMetadataResolver.class, attributes=RecordOperationsMetadataResolvers.UpdateRecordMetadataResolver.class)
    @MediaType(value="text/xml")
    public Result<InputStream, NetsuiteSoapAttributes> update(@Config NetSuiteSoapConfig config, @Connection NetSuiteSoapConnection connection, @Optional @MetadataKeyId(value=RecordOperationsMetadataResolvers.UpdateRecordMetadataResolver.class) String type, @TypeResolver(value=RecordOperationsMetadataResolvers.UpdateRecordMetadataResolver.class) @Content InputStream message) {
        return connection.invokeRecordOperation(config, "update", message);
    }

    @Throws(value={NetSuiteMultipleErrorTypeProvider.class})
    @OutputResolver(output=RecordOperationsMetadataResolvers.UpdateListMetadataResolver.class, attributes=RecordOperationsMetadataResolvers.UpdateListMetadataResolver.class)
    @MediaType(value="text/xml")
    public Result<InputStream, NetsuiteSoapAttributes> updateList(@Config NetSuiteSoapConfig config, @Connection NetSuiteSoapConnection connection, @Optional @MetadataKeyId(value=RecordOperationsMetadataResolvers.UpdateListMetadataResolver.class) String type, @TypeResolver(value=RecordOperationsMetadataResolvers.UpdateListMetadataResolver.class) @Content InputStream message) {
        return connection.invokeRecordOperation(config, "updateList", message);
    }

    @Throws(value={NetSuiteSingleErrorTypeProvider.class})
    @OutputResolver(output=RecordOperationsMetadataResolvers.UpsertRecordMetadataResolver.class, attributes=RecordOperationsMetadataResolvers.UpsertRecordMetadataResolver.class)
    @MediaType(value="text/xml")
    public Result<InputStream, NetsuiteSoapAttributes> upsert(@Config NetSuiteSoapConfig config, @Connection NetSuiteSoapConnection connection, @Optional @MetadataKeyId(value=RecordOperationsMetadataResolvers.UpsertRecordMetadataResolver.class) String type, @TypeResolver(value=RecordOperationsMetadataResolvers.UpsertRecordMetadataResolver.class) @Content InputStream message) {
        return connection.invokeRecordOperation(config, "upsert", message);
    }

    @Throws(value={NetSuiteMultipleErrorTypeProvider.class})
    @OutputResolver(output=RecordOperationsMetadataResolvers.UpsertListMetadataResolver.class, attributes=RecordOperationsMetadataResolvers.UpsertListMetadataResolver.class)
    @MediaType(value="text/xml")
    public Result<InputStream, NetsuiteSoapAttributes> upsertList(@Config NetSuiteSoapConfig config, @Connection NetSuiteSoapConnection connection, @Optional @MetadataKeyId(value=RecordOperationsMetadataResolvers.UpsertListMetadataResolver.class) String type, @TypeResolver(value=RecordOperationsMetadataResolvers.UpsertListMetadataResolver.class) @Content InputStream message) {
        return connection.invokeRecordOperation(config, "upsertList", message);
    }

    @Throws(value={NetSuiteSingleErrorTypeProvider.class})
    @OutputResolver(output=RecordOperationsMetadataResolvers.DeleteRecordMetadataResolver.class, attributes=RecordOperationsMetadataResolvers.DeleteRecordMetadataResolver.class)
    @MediaType(value="text/xml")
    public Result<InputStream, NetsuiteSoapAttributes> delete(@Config NetSuiteSoapConfig config, @Connection NetSuiteSoapConnection connection, @MetadataKeyId(value=RecordOperationsMetadataResolvers.DeleteRecordMetadataResolver.class) @ParameterGroup(name="types") RecordRefAndTypeParameterGroup key, @TypeResolver(value=RecordOperationsMetadataResolvers.DeleteRecordMetadataResolver.class) @Content InputStream message) {
        return connection.invokeRecordOperation(config, "delete", message);
    }

    @Throws(value={NetSuiteMultipleErrorTypeProvider.class})
    @OutputResolver(output=RecordOperationsMetadataResolvers.DeleteListMetadataResolver.class, attributes=RecordOperationsMetadataResolvers.DeleteListMetadataResolver.class)
    @MediaType(value="text/xml")
    public Result<InputStream, NetsuiteSoapAttributes> deleteList(@Config NetSuiteSoapConfig config, @Connection NetSuiteSoapConnection connection, @MetadataKeyId(value=RecordOperationsMetadataResolvers.DeleteListMetadataResolver.class) @ParameterGroup(name="types") RecordRefAndTypeParameterGroup key, @TypeResolver(value=RecordOperationsMetadataResolvers.DeleteListMetadataResolver.class) @Content InputStream message) {
        return connection.invokeRecordOperation(config, "deleteList", message);
    }

    @OutputResolver(output=RecordOperationsMetadataResolvers.GetDeletedMetadataResolver.class, attributes=RecordOperationsMetadataResolvers.GetDeletedMetadataResolver.class)
    @Throws(value={NetSuiteMultipleErrorTypeProvider.class})
    public PagingProvider<NetSuiteSoapConnection, Result<String, NetsuiteSoapAttributes>> getDeleted(@Config NetSuiteSoapConfig config, @TypeResolver(value=RecordOperationsMetadataResolvers.GetDeletedMetadataResolver.class) @Content InputStream filter, @Placement(tab="Search preferences") @Optional(defaultValue="-1") @Example(value="100") int limit) {
        return new PaginatedGetDeleted(filter, limit);
    }

    @OutputResolver(output=RecordOperationsMetadataResolvers.GetSelectValueMetadataResolver.class, attributes=RecordOperationsMetadataResolvers.GetSelectValueMetadataResolver.class)
    public PagingProvider<NetSuiteSoapConnection, Result<String, NetsuiteSoapAttributes>> getSelectValue(@Config NetSuiteSoapConfig config, @TypeResolver(value=RecordOperationsMetadataResolvers.GetSelectValueMetadataResolver.class) @Content InputStream fieldDescription, @Optional(defaultValue="10") @Example(value="10") int pageSize) {
        return new PaginatedGetSelectValue(fieldDescription, pageSize);
    }

    @OutputResolver(output=RecordOperationsMetadataResolvers.InitializeMetadataResolver.class, attributes=RecordOperationsMetadataResolvers.InitializeMetadataResolver.class)
    @Throws(value={NetSuiteMultipleErrorTypeProvider.class})
    @MediaType(value="text/xml")
    public Result<InputStream, NetsuiteSoapAttributes> initialize(@Config NetSuiteSoapConfig config, @Connection NetSuiteSoapConnection connection, @TypeResolver(value=RecordOperationsMetadataResolvers.InitializeMetadataResolver.class) @Content InputStream message) {
        return connection.invokeRecordOperation(config, "initialize", message);
    }

    @OutputResolver(output=RecordOperationsMetadataResolvers.InitializeListMetadataResolver.class, attributes=RecordOperationsMetadataResolvers.InitializeListMetadataResolver.class)
    @Throws(value={NetSuiteMultipleErrorTypeProvider.class})
    @MediaType(value="text/xml")
    public Result<InputStream, NetsuiteSoapAttributes> initializeList(@Config NetSuiteSoapConfig config, @Connection NetSuiteSoapConnection connection, @TypeResolver(value=RecordOperationsMetadataResolvers.InitializeListMetadataResolver.class) @Content InputStream message) {
        return connection.invokeRecordOperation(config, "initializeList", message);
    }

    @Throws(value={NetSuiteMultipleErrorTypeProvider.class})
    @OutputResolver(output=RecordOperationsMetadataResolvers.SearchMetadataResolver.class, attributes=RecordOperationsMetadataResolvers.SearchMetadataResolver.class)
    public PagingProvider<NetSuiteSoapConnection, Result<String, NetsuiteSoapAttributes>> search(@Config NetSuiteSoapConfig config, @MetadataKeyId(value=RecordOperationsMetadataResolvers.SearchMetadataResolver.class) @Optional String key, @Content @TypeResolver(value=RecordOperationsMetadataResolvers.SearchMetadataResolver.class) InputStream message, @Summary(value="This field limits the amount of results returned by the search, defaults to -1. 0 and -1 meaning not to limit the results.") @Placement(tab="Search preferences") @Optional(defaultValue="10") @Example(value="10") int pageSize, @Placement(tab="Search preferences") @Optional(defaultValue="-1") @Example(value="100") int limit, @Placement(tab="Search preferences") @Optional(defaultValue="true") boolean bodyFieldsOnly, @Placement(tab="Search preferences") @Optional(defaultValue="true") boolean returnSearchColumns) {
        return new PaginatedSearch(message, limit, pageSize, bodyFieldsOnly, returnSearchColumns);
    }

    @OutputResolver(output=RecordOperationsMetadataResolvers.GetSavedSearchMetadataResolver.class, attributes=RecordOperationsMetadataResolvers.GetSavedSearchMetadataResolver.class)
    @MediaType(value="text/xml")
    public Result<InputStream, NetsuiteSoapAttributes> getSavedSearch(@Config NetSuiteSoapConfig config, @Connection NetSuiteSoapConnection connection, @MetadataKeyId(value=RecordOperationsMetadataResolvers.GetSavedSearchMetadataResolver.class) String searchType) {
        return connection.getSavedSearch(config, searchType);
    }
}

