/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.netsuite.internal.pagination;

import com.mulesoft.connector.netsuite.api.NetsuiteSoapAttributes;
import com.mulesoft.connector.netsuite.internal.config.NetSuiteSoapConfig;
import com.mulesoft.connector.netsuite.internal.connection.NetSuiteSoapConnection;
import com.mulesoft.connector.netsuite.internal.util.NetsuiteDocumentFactory;
import com.mulesoft.connector.netsuite.internal.xml.XmlUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Spliterators;
import java.util.function.Supplier;
import java.util.stream.StreamSupport;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class IterablePagingProvider<C, T>
implements PagingProvider<C, T> {
    private static final Logger logger = LoggerFactory.getLogger(IterablePagingProvider.class);
    @Config
    private NetSuiteSoapConfig config;
    protected final int limit;
    protected boolean bodyFieldsOnly;
    protected boolean returnSearchColumns;
    protected InputStream searchQuery;
    protected Integer pageSize;
    String xPathStatusExpression;
    String xPathPageIndexExpression;
    String xPathPageSizeExpression;
    String xPathTotalRecordsExpression;
    String xPathTotalPagesExpression;
    boolean status;
    int pageIndex = -1;
    int totalRecords;
    int totalPages;

    public IterablePagingProvider(String xPathBaseElement, int pageSize, int limit) {
        this.pageSize = pageSize;
        this.limit = limit;
        this.xPathStatusExpression = xPathBaseElement + "/*[local-name() = 'status']/@*[local-name() = 'isSuccess']";
        this.xPathPageIndexExpression = xPathBaseElement + "/*[local-name() = 'pageIndex']";
        this.xPathPageSizeExpression = xPathBaseElement + "/*[local-name() = 'pageSize']";
        this.xPathTotalRecordsExpression = xPathBaseElement + "/*[local-name() = 'totalRecords']";
        this.xPathTotalPagesExpression = xPathBaseElement + "/*[local-name() = 'totalPages']";
    }

    protected abstract Result<InputStream, NetsuiteSoapAttributes> getNextPage(NetSuiteSoapConnection var1) throws IOException, TransformerException, SAXException, ParserConfigurationException;

    protected abstract Result<InputStream, NetsuiteSoapAttributes> getFirstPage(NetSuiteSoapConnection var1) throws IOException, ParserConfigurationException, SAXException, TransformerException;

    public Iterator<T> iterator(final Supplier<C> connectionSupplier) {
        Iterator pagesIterator = new Iterator<List<T>>(){
            private List<T> currentPageResults = null;

            @Override
            public boolean hasNext() {
                if (this.currentPageResults == null) {
                    this.currentPageResults = IterablePagingProvider.this.getPage(connectionSupplier.get());
                }
                return !this.currentPageResults.isEmpty();
            }

            @Override
            public List<T> next() {
                if (this.currentPageResults == null) {
                    this.currentPageResults = IterablePagingProvider.this.getPage(connectionSupplier.get());
                } else if (this.currentPageResults.isEmpty()) {
                    throw new NoSuchElementException("There are no more pages in this iterator");
                }
                List nextPageResults = this.currentPageResults;
                this.currentPageResults = null;
                return nextPageResults;
            }
        };
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(pagesIterator, 0), false).flatMap(v -> v.stream()).iterator();
    }

    public synchronized List<Result<String, NetsuiteSoapAttributes>> getPage(NetSuiteSoapConnection connection) {
        NetsuiteDocumentFactory documentFactory = connection.getDocumentFactory();
        try {
            Result<InputStream, NetsuiteSoapAttributes> queryResult;
            if (this.isStartPageIndex()) {
                queryResult = this.getFirstPage(connection);
            } else if (this.pageIndex < this.totalPages) {
                queryResult = this.getNextPage(connection);
            } else {
                return Collections.emptyList();
            }
            Document resultDocument = documentFactory.transformToDocument((InputStream)queryResult.getOutput());
            this.status = this.extractStatus(resultDocument);
            if (Boolean.FALSE.equals(this.status)) {
                logger.error("The request to obtain a page failed");
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Could not obtain the page with index %s for the paging provider", this.pageIndex)));
            }
            this.totalPages = this.extractTotalPages(resultDocument);
            if (this.totalPages <= 0) {
                logger.debug("No Records where returned in the search");
                return Collections.emptyList();
            }
            this.extractResultFields(resultDocument);
            ArrayList<Result<String, NetsuiteSoapAttributes>> queryResults = new ArrayList<Result<String, NetsuiteSoapAttributes>>();
            NodeList nodes = (NodeList)XmlUtils.executeXPath(this.getXPathForResultNodeList(), resultDocument, XPathConstants.NODESET);
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                String output = documentFactory.convertToString(node);
                queryResults.add((Result<String, NetsuiteSoapAttributes>)Result.builder().output((Object)output).mediaType(queryResult.getMediaType().orElse(DataType.builder().type(String.class).mediaType("text/xml").build().getMediaType())).attributes(queryResult.getAttributes().orElseThrow(() -> new NullPointerException("Couldn't get the attributes for the result."))).build());
            }
            return queryResults;
        }
        catch (IOException | ParserConfigurationException | TransformerException | XPathExpressionException | SAXException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    protected boolean isStartPageIndex() {
        return this.pageIndex <= 0;
    }

    protected abstract String getXPathForResultNodeList();

    public Optional<Integer> getTotalResults(NetSuiteSoapConnection connection) {
        return Optional.empty();
    }

    protected void extractResultFields(Document resultDocument) throws XPathExpressionException {
        this.pageIndex = this.extractPageIndex(resultDocument);
        this.pageSize = this.extractPageSize(resultDocument);
        this.totalRecords = this.extractTotalRecords(resultDocument);
    }

    public void close(NetSuiteSoapConnection netSuiteSoapConnection) {
    }

    protected String getXPathStatusExpression() {
        return this.xPathStatusExpression;
    }

    protected String getXPathPageIndexExpression() {
        return this.xPathPageIndexExpression;
    }

    protected String getXPathPageSizeExpression() {
        return this.xPathPageSizeExpression;
    }

    protected String getXPathTotalPagesExpression() {
        return this.xPathTotalPagesExpression;
    }

    protected String getXPathTotalRecordsExpression() {
        return this.xPathTotalRecordsExpression;
    }

    private Boolean extractStatus(Document document) throws XPathExpressionException {
        return (Boolean)XmlUtils.executeXPath(this.getXPathStatusExpression(), document, XPathConstants.BOOLEAN);
    }

    private Integer extractPageIndex(Document document) throws XPathExpressionException {
        String result = (String)XmlUtils.executeXPath(this.getXPathPageIndexExpression(), document, XPathConstants.STRING);
        return result != null ? Integer.valueOf(result) : null;
    }

    private Integer extractPageSize(Document document) throws XPathExpressionException {
        String result = (String)XmlUtils.executeXPath(this.getXPathPageSizeExpression(), document, XPathConstants.STRING);
        return result != null ? Integer.valueOf(result) : null;
    }

    private Integer extractTotalPages(Document document) throws XPathExpressionException {
        String result = (String)XmlUtils.executeXPath(this.getXPathTotalPagesExpression(), document, XPathConstants.STRING);
        return result != null ? Integer.valueOf(result) : null;
    }

    private Integer extractTotalRecords(Document document) throws XPathExpressionException {
        String result = (String)XmlUtils.executeXPath(this.getXPathTotalRecordsExpression(), document, XPathConstants.STRING);
        return result != null ? Integer.valueOf(result) : null;
    }

    public NetSuiteSoapConfig getConfig() {
        return this.config;
    }
}

