/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.netsuite.internal.pagination;

import com.mulesoft.connector.netsuite.api.NetsuiteSoapAttributes;
import com.mulesoft.connector.netsuite.internal.connection.NetSuiteSoapConnection;
import com.mulesoft.connector.netsuite.internal.pagination.IterablePagingProvider;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class PaginatedGetDeleted
extends IterablePagingProvider<NetSuiteSoapConnection, Result<String, NetsuiteSoapAttributes>> {
    private static final String DELETE_RESPONSE_RESULT_NODESET = "//*[local-name() = 'deletedRecordList']/*";
    private final InputStream filter;
    private Document filterDocument;

    public PaginatedGetDeleted(InputStream filter, int limit) {
        super("//*[local-name() = 'getDeletedResult']", -1, limit);
        this.filter = filter;
    }

    @Override
    protected Result<InputStream, NetsuiteSoapAttributes> getNextPage(NetSuiteSoapConnection connection) throws IOException, TransformerException, SAXException, ParserConfigurationException {
        try (InputStream message = this.createMessage(connection);){
            Result<InputStream, NetsuiteSoapAttributes> result = connection.getDeleted(this.getConfig(), message);
            return result;
        }
    }

    @Override
    protected Result<InputStream, NetsuiteSoapAttributes> getFirstPage(NetSuiteSoapConnection connection) throws IOException, ParserConfigurationException, SAXException, TransformerException {
        try (InputStream firstPageFilter = this.filter;){
            this.filterDocument = connection.getDocumentFactory().transformToDocument(firstPageFilter);
        }
        return this.getNextPage(connection);
    }

    @Override
    protected String getXPathForResultNodeList() {
        return DELETE_RESPONSE_RESULT_NODESET;
    }

    @Override
    public void close(NetSuiteSoapConnection netSuiteSoapConnection) {
        IOUtils.closeQuietly((Closeable)this.filter);
        super.close(netSuiteSoapConnection);
    }

    private InputStream createMessage(NetSuiteSoapConnection connection) throws IOException, SAXException, ParserConfigurationException, TransformerException {
        int pageIndex = this.pageIndex;
        if (this.isStartPageIndex()) {
            pageIndex = 1;
        }
        return connection.getDocumentFactory().transformToInputStream(connection.getDocumentFactory().getDeleted(this.filterDocument, pageIndex));
    }
}

