/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.netsuite.internal.pagination;

import com.mulesoft.connector.netsuite.api.NetsuiteSoapAttributes;
import com.mulesoft.connector.netsuite.internal.connection.NetSuiteSoapConnection;
import com.mulesoft.connector.netsuite.internal.pagination.IterablePagingProvider;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class PaginatedGetPostingTransactionSummary
extends IterablePagingProvider<NetSuiteSoapConnection, Result<String, NetsuiteSoapAttributes>> {
    private static final String GET_POSTING_TRANSACTION_SUMMARY_RESPONSE_RESULT_NODESET = "//*[local-name() = 'postingTransactionSummaryList']/*";
    private InputStream fields;
    private InputStream filters;
    private String operationId;
    private Document fieldsDocument;
    private Document filtersDocument;

    public PaginatedGetPostingTransactionSummary(InputStream fields, InputStream filters, String operationId) {
        super("//*[local-name() = 'getPostingTransactionSummaryResult']", -1, 1000);
        this.fields = fields;
        this.filters = filters;
        this.operationId = operationId;
    }

    @Override
    protected Result<InputStream, NetsuiteSoapAttributes> getNextPage(NetSuiteSoapConnection connection) throws IOException, TransformerException, ParserConfigurationException {
        try (InputStream message = this.createMessage(connection);){
            Result<InputStream, NetsuiteSoapAttributes> result = connection.getPostingTransactionSummary(this.getConfig(), message);
            return result;
        }
    }

    @Override
    protected Result<InputStream, NetsuiteSoapAttributes> getFirstPage(NetSuiteSoapConnection connection) throws IOException, ParserConfigurationException, SAXException, TransformerException {
        try (InputStream firstPageFields = this.fields;
             InputStream firstPageFilters = this.filters;){
            this.fieldsDocument = connection.getDocumentFactory().transformToDocument(firstPageFields);
            this.filtersDocument = connection.getDocumentFactory().transformToDocument(firstPageFilters);
        }
        return this.getNextPage(connection);
    }

    @Override
    protected String getXPathForResultNodeList() {
        return GET_POSTING_TRANSACTION_SUMMARY_RESPONSE_RESULT_NODESET;
    }

    @Override
    public void close(NetSuiteSoapConnection netSuiteSoapConnection) {
        IOUtils.closeQuietly((Closeable)this.fields);
        IOUtils.closeQuietly((Closeable)this.filters);
        super.close(netSuiteSoapConnection);
    }

    private InputStream createMessage(NetSuiteSoapConnection connection) throws ParserConfigurationException, TransformerException {
        int pageIndex = this.pageIndex;
        if (this.isStartPageIndex()) {
            pageIndex = 1;
        }
        return connection.getDocumentFactory().transformToInputStream(connection.getDocumentFactory().getPostingTransactionSummary(this.filtersDocument, this.fieldsDocument, this.operationId, pageIndex));
    }
}

