/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.netsuite.internal.pagination;

import com.mulesoft.connector.netsuite.api.NetsuiteSoapAttributes;
import com.mulesoft.connector.netsuite.internal.connection.NetSuiteSoapConnection;
import com.mulesoft.connector.netsuite.internal.pagination.IterablePagingProvider;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class PaginatedGetSelectValue
extends IterablePagingProvider<NetSuiteSoapConnection, Result<String, NetsuiteSoapAttributes>> {
    private static final String GET_SELECT_VALUE_RESPONSE_RESULT_NODESET = "//*[local-name() = 'baseRefList']/*";
    private InputStream fieldDescription;
    private Document fieldDescriptionDocument;

    public PaginatedGetSelectValue(InputStream fieldDescription, int pageSize) {
        super("//*[local-name() = 'getSelectValueResult']", pageSize, 1000);
        this.fieldDescription = fieldDescription;
    }

    @Override
    protected Result<InputStream, NetsuiteSoapAttributes> getNextPage(NetSuiteSoapConnection connection) throws IOException, TransformerException, ParserConfigurationException {
        try (InputStream message = this.createMessage(connection);){
            Result<InputStream, NetsuiteSoapAttributes> result = connection.getSelectValue(this.getConfig(), message);
            return result;
        }
    }

    @Override
    protected Result<InputStream, NetsuiteSoapAttributes> getFirstPage(NetSuiteSoapConnection connection) throws IOException, ParserConfigurationException, SAXException, TransformerException {
        try (InputStream fieldDesc = this.fieldDescription;){
            this.fieldDescriptionDocument = connection.getDocumentFactory().transformToDocument(fieldDesc);
        }
        return this.getNextPage(connection);
    }

    @Override
    protected String getXPathForResultNodeList() {
        return GET_SELECT_VALUE_RESPONSE_RESULT_NODESET;
    }

    private InputStream createMessage(NetSuiteSoapConnection connection) throws ParserConfigurationException, TransformerException {
        if (this.isStartPageIndex()) {
            this.pageIndex = 1;
        }
        return connection.getDocumentFactory().transformToInputStream(connection.getDocumentFactory().getSelectValue(this.fieldDescriptionDocument, this.pageIndex));
    }

    @Override
    protected void extractResultFields(Document resultDocument) {
        this.pageIndex = this.pageIndex++;
    }
}

