/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.netsuite.internal.source;

import com.mulesoft.connector.netsuite.api.NetsuiteSoapAttributes;
import com.mulesoft.connector.netsuite.internal.connection.NetSuiteSoapConnection;
import com.mulesoft.connector.netsuite.internal.metadata.SourcesMetadataResolvers;
import com.mulesoft.connector.netsuite.internal.pagination.IterablePagingProvider;
import com.mulesoft.connector.netsuite.internal.pagination.PaginatedGetDeleted;
import com.mulesoft.connector.netsuite.internal.source.AbstractPollingSource;
import com.mulesoft.connector.netsuite.internal.util.NetsuiteDocumentFactory;
import java.time.ZonedDateTime;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.metadata.MetadataScope;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.source.ClusterSupport;
import org.mule.runtime.extension.api.annotation.source.SourceClusterSupport;
import org.mule.runtime.extension.api.runtime.operation.Result;

@Alias(value="deleted-object-listener")
@DisplayName(value="On Deleted Object")
@ClusterSupport(value=SourceClusterSupport.NOT_SUPPORTED)
@MetadataScope(outputResolver=SourcesMetadataResolvers.OnDeletedSourceMetadataResolver.class)
@MediaType(value="text/xml")
public class OnDeletedSource
extends AbstractPollingSource {
    @Override
    protected IterablePagingProvider<NetSuiteSoapConnection, Result<String, NetsuiteSoapAttributes>> getResultsIterator(NetSuiteSoapConnection connection, ZonedDateTime queryStartDateTime) throws TransformerException, ParserConfigurationException {
        NetsuiteDocumentFactory documentFactory = connection.getDocumentFactory();
        return new PaginatedGetDeleted(documentFactory.transformToInputStream(documentFactory.getDeletedFilter(queryStartDateTime, NetSuiteSoapConnection.DATETIME_FORMAT_TO_NETSUITE)), -1);
    }

    protected void doStart() {
        this.setWaterMarkFieldName("deletedDate");
    }
}

