/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.netsuite.internal.util;

import com.mulesoft.connector.netsuite.internal.util.CustomFieldRefType;
import java.util.Optional;
import java.util.stream.Stream;

public enum CustomFieldType {
    CHECK_BOX("_checkBox", CustomFieldRefType.BOOLEAN),
    CURRENCY("_currency", CustomFieldRefType.DOUBLE),
    DATE("_date", CustomFieldRefType.DATE),
    DATETIME("_datetime", CustomFieldRefType.DATE),
    DECIMAL_NUMBER("_decimalNumber", CustomFieldRefType.DOUBLE),
    E_MAIL_ADDRESS("_eMailAddress", CustomFieldRefType.STRING),
    FREE_FORM_TEXT("_freeFormText", CustomFieldRefType.STRING),
    HELP("_help", CustomFieldRefType.STRING),
    HYPERLINK("_hyperlink", CustomFieldRefType.STRING),
    INLINE_HTML("_inlineHTML", CustomFieldRefType.STRING),
    INTEGER_NUMBER("_integerNumber", CustomFieldRefType.LONG),
    LIST_RECORD("_listRecord", CustomFieldRefType.SELECT),
    LONG_TEXT("_longText", CustomFieldRefType.STRING),
    MULTIPLE_SELECT("_multipleSelect", CustomFieldRefType.MULTI_SELECT),
    PASSWORD("_password", CustomFieldRefType.STRING),
    PERCENT("_percent", CustomFieldRefType.DOUBLE),
    PHONE_NUMBER("_phoneNumber", CustomFieldRefType.STRING),
    RICH_TEXT("_richText", CustomFieldRefType.STRING),
    TEXT_AREA("_textArea", CustomFieldRefType.STRING),
    TIME_OF_DAY("_timeOfDay", CustomFieldRefType.DATE);

    private String netsuiteValue;
    private final CustomFieldRefType customFieldRefType;

    public static Optional<CustomFieldRefType> refTypeFromNetSuiteName(String name) {
        return Stream.of(CustomFieldType.values()).filter(v -> v.netsuiteValue.equalsIgnoreCase(name)).map(v -> v.customFieldRefType).findFirst();
    }

    private CustomFieldType(String value, CustomFieldRefType customFieldRefType) {
        this.netsuiteValue = value;
        this.customFieldRefType = customFieldRefType;
    }

    public String getNetsuiteValue() {
        return this.netsuiteValue;
    }

    public CustomFieldRefType getCustomFieldRefType() {
        return this.customFieldRefType;
    }
}

