/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.netsuite.internal.util;

import com.google.common.base.Strings;
import com.mulesoft.connector.netsuite.internal.config.PreferencesParameterGroup;
import com.mulesoft.connector.netsuite.internal.connection.provider.config.TokenConnectionParameters;
import com.mulesoft.connector.netsuite.internal.model.RecordRefAndTypeParameterGroup;
import com.mulesoft.connector.netsuite.internal.util.CustomFieldUtils;
import com.mulesoft.connector.netsuite.internal.util.CustomUUIDGenerator;
import com.mulesoft.connector.netsuite.internal.xml.XmlFactories;
import com.mulesoft.connector.netsuite.internal.xml.XmlUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.crypto.Mac;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.MuleExpressionLanguage;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.transformation.TransformationService;
import org.mule.runtime.api.util.IOUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class NetsuiteDocumentFactory {
    private static final DataType XML_STREAM = DataType.builder().type(InputStream.class).mediaType(MediaType.XML).build();
    public static final String INTERNAL_ID = "internalId";
    public static final String SCRIPT_ID = "scriptId";
    public static final String TYPE = "type";
    private static final String RECORD_ELEMENT_NAME = "record";
    private static final String DEFAULT_XSI_PREFIX = "xsi";
    private static final String XMLNS_CORE = "xmlns:core";
    private static final String WSDL_VERSION = "wsdlVersion";
    private static final String PAYLOAD = "payload";
    public static final String XMLNS_PLATFORM_CORE = "xmlns:platformCore";
    public static final String XMLNS_XSI = "xmlns:xsi";
    public static final String XMLSCHEMA_INSTANCE = "http://www.w3.org/2001/XMLSchema-instance";
    private final String messagesNS;
    private final String coreNS;
    private final String commonNS;
    private final MuleExpressionLanguage expressionExecutor;
    private final TransformationService transformationService;
    private final String wsdlVersion;

    public NetsuiteDocumentFactory(MuleExpressionLanguage expressionExecutor, TransformationService transformationService) {
        this("2020_2", expressionExecutor, transformationService);
    }

    public NetsuiteDocumentFactory(String wsdlVersion, MuleExpressionLanguage expressionExecutor, TransformationService transformationService) {
        this.messagesNS = String.format("urn:messages_%s.platform.webservices.netsuite.com", wsdlVersion);
        this.coreNS = String.format("urn:core_%s.platform.webservices.netsuite.com", wsdlVersion);
        this.commonNS = String.format("urn:common_%s.platform.webservices.netsuite.com", wsdlVersion);
        this.wsdlVersion = wsdlVersion;
        this.transformationService = transformationService;
        this.expressionExecutor = expressionExecutor;
    }

    public Document getCustomizationRequest(String customizationTypeValue) throws ParserConfigurationException {
        Document document = this.createNewDocument();
        Element getBodyElement = document.createElementNS(this.messagesNS, "getCustomizationId");
        getBodyElement.setAttribute(XMLNS_CORE, this.coreNS);
        document.appendChild(getBodyElement);
        Element customizationType = document.createElementNS(this.messagesNS, "customizationType");
        customizationType.setAttribute("getCustomizationType", customizationTypeValue);
        getBodyElement.appendChild(customizationType);
        Element includeInactives = document.createElementNS(this.messagesNS, "includeInactives");
        includeInactives.setTextContent("false");
        getBodyElement.appendChild(includeInactives);
        return document;
    }

    public Document getRecords(String recordType) throws ParserConfigurationException {
        Document document = this.createNewDocument();
        Element getBodyElement = document.createElementNS(this.messagesNS, "getAll");
        getBodyElement.setAttribute(XMLNS_CORE, this.coreNS);
        document.appendChild(getBodyElement);
        Element record = document.createElementNS(this.messagesNS, RECORD_ELEMENT_NAME);
        record.setAttribute("recordType", recordType);
        getBodyElement.appendChild(record);
        return document;
    }

    public Document getSavedSearch(String searchType) throws ParserConfigurationException {
        Document document = this.createNewDocument();
        Element getBodyElement = document.createElementNS(this.messagesNS, "getSavedSearch");
        getBodyElement.setAttribute(XMLNS_CORE, this.coreNS);
        document.appendChild(getBodyElement);
        Element record = document.createElementNS(this.messagesNS, RECORD_ELEMENT_NAME);
        record.setAttribute("searchType", searchType);
        getBodyElement.appendChild(record);
        return document;
    }

    public Document searchMoreWithId(String searchId, Integer pageIndex) throws ParserConfigurationException {
        Document document = this.createNewDocument();
        Element searchMoreWithIdElement = document.createElementNS(this.messagesNS, "searchMoreWithId");
        document.appendChild(searchMoreWithIdElement);
        Element element = document.createElementNS(this.messagesNS, "searchId");
        element.setTextContent(searchId);
        searchMoreWithIdElement.appendChild(element);
        element = document.createElementNS(this.messagesNS, "pageIndex");
        element.setTextContent(pageIndex.toString());
        searchMoreWithIdElement.appendChild(element);
        return document;
    }

    public Document getDeleted(Document getDeletedFilter, int pageIndex) throws ParserConfigurationException {
        Document document = this.createNewDocument();
        Element getDeletedBody = document.createElementNS(this.messagesNS, "getDeleted");
        document.appendChild(getDeletedBody);
        Element pageIndexElement = document.createElementNS(this.messagesNS, "pageIndex");
        pageIndexElement.setTextContent(String.valueOf(pageIndex));
        getDeletedBody.appendChild(pageIndexElement);
        getDeletedBody.appendChild(document.importNode(getDeletedFilter.getDocumentElement(), true));
        return document;
    }

    public Document getPostingTransactionSummary(Document filtersDocument, Document fieldsDocument, String operationId, int pageIndex) throws ParserConfigurationException {
        Document document = this.createNewDocument();
        Element getPostingBody = document.createElementNS(this.messagesNS, "getPostingTransactionSummary");
        document.appendChild(getPostingBody);
        Element pageIndexElement = document.createElementNS(this.messagesNS, "pageIndex");
        pageIndexElement.setTextContent(String.valueOf(pageIndex));
        getPostingBody.appendChild(pageIndexElement);
        if (!Strings.isNullOrEmpty((String)operationId)) {
            Element operationIdElement = document.createElementNS(this.messagesNS, "operationId");
            operationIdElement.setTextContent(operationId);
            getPostingBody.appendChild(operationIdElement);
        }
        getPostingBody.appendChild(document.importNode(filtersDocument.getDocumentElement(), true));
        getPostingBody.appendChild(document.importNode(fieldsDocument.getDocumentElement(), true));
        return document;
    }

    public Document getSelectValue(Document fieldDescription, int pageIndex) throws ParserConfigurationException {
        Document document = this.createNewDocument();
        Element getSelectValueBody = document.createElementNS(this.messagesNS, "getSelectValue");
        document.appendChild(getSelectValueBody);
        Element pageIndexElement = document.createElementNS(this.messagesNS, "pageIndex");
        pageIndexElement.setTextContent(String.valueOf(pageIndex));
        getSelectValueBody.appendChild(pageIndexElement);
        getSelectValueBody.appendChild(document.importNode(fieldDescription.getDocumentElement(), true));
        return document;
    }

    public Document getDeletedFilter(ZonedDateTime since, DateTimeFormatter netsuiteDateTimeFormatter) throws ParserConfigurationException {
        Document document = this.createNewDocument();
        Element getDeletedFilter = document.createElementNS(this.messagesNS, "getDeletedFilter");
        document.appendChild(getDeletedFilter);
        Element deletedDate = document.createElementNS(this.coreNS, "deletedDate");
        getDeletedFilter.appendChild(deletedDate);
        deletedDate.setAttribute("operator", "after");
        getDeletedFilter.appendChild(deletedDate);
        Element searchValue = document.createElementNS(this.coreNS, "searchValue");
        searchValue.setTextContent(since.format(netsuiteDateTimeFormatter));
        deletedDate.appendChild(searchValue);
        return document;
    }

    public InputStream newAndModifiedSourceBodyRequest(String objectType, ZonedDateTime since, String fieldName, DateTimeFormatter netsuiteDateTimeFormatter) throws ParserConfigurationException, TransformerException {
        Document document = this.createNewDocument();
        Element searchBody = document.createElementNS(this.messagesNS, "search");
        document.appendChild(searchBody);
        searchBody.setAttribute("xmlns:common", "urn:common_2020_2.platform.webservices.netsuite.com");
        Element searchRecord = document.createElementNS(this.messagesNS, "searchRecord");
        searchRecord.setAttribute("xsi:type", "common:" + objectType);
        searchRecord.setAttribute(XMLNS_XSI, XMLSCHEMA_INSTANCE);
        searchBody.appendChild(searchRecord);
        Element dateCreated = document.createElementNS(this.commonNS, fieldName);
        dateCreated.setAttribute("operator", "after");
        searchRecord.appendChild(dateCreated);
        Element searchValue = document.createElementNS(this.coreNS, "searchValue");
        searchValue.setTextContent(netsuiteDateTimeFormatter.format(since));
        dateCreated.appendChild(searchValue);
        return this.transformToInputStream(document);
    }

    public Document generateXmlHeaderPreferences(PreferencesParameterGroup preferences) throws ParserConfigurationException {
        Document document = this.createNewDocument();
        Element preferencesBody = document.createElementNS(this.messagesNS, "preferences");
        document.appendChild(preferencesBody);
        Element warningAsError = document.createElementNS(this.messagesNS, "warningAsError");
        warningAsError.setTextContent(String.valueOf(preferences.isWarningAsError()));
        preferencesBody.appendChild(warningAsError);
        Element disableMandatoryCustomFieldValidation = document.createElementNS(this.messagesNS, "disableMandatoryCustomFieldValidation");
        disableMandatoryCustomFieldValidation.setTextContent(String.valueOf(preferences.isDisableMandatoryCustomFieldValidation()));
        preferencesBody.appendChild(disableMandatoryCustomFieldValidation);
        Element disableSystemNotesForCustomFields = document.createElementNS(this.messagesNS, "disableSystemNotesForCustomFields");
        disableSystemNotesForCustomFields.setTextContent(String.valueOf(preferences.isDisableSystemNotesForCustomFields()));
        preferencesBody.appendChild(disableSystemNotesForCustomFields);
        Element ignoreReadOnlyFields = document.createElementNS(this.messagesNS, "ignoreReadOnlyFields");
        ignoreReadOnlyFields.setTextContent(String.valueOf(preferences.isIgnoreReadOnlyFields()));
        preferencesBody.appendChild(ignoreReadOnlyFields);
        Element runServerSuiteScriptAndTriggerWorkflows = document.createElementNS(this.messagesNS, "runServerSuiteScriptAndTriggerWorkflows");
        runServerSuiteScriptAndTriggerWorkflows.setTextContent(String.valueOf(preferences.isRunServerSuiteScriptAndTriggerWorkflows()));
        preferencesBody.appendChild(runServerSuiteScriptAndTriggerWorkflows);
        return document;
    }

    public Document generateXmlSearchPreferences(boolean bodyFieldsOnly, boolean returnSearchColumns, int pageSize) throws ParserConfigurationException {
        Document document = this.createNewDocument();
        Element searchPreferencesBody = document.createElementNS(this.messagesNS, "searchPreferences");
        document.appendChild(searchPreferencesBody);
        Element bodyFieldsOnlyElement = document.createElementNS(this.messagesNS, "bodyFieldsOnly");
        bodyFieldsOnlyElement.setTextContent(String.valueOf(bodyFieldsOnly));
        searchPreferencesBody.appendChild(bodyFieldsOnlyElement);
        Element returnSearchColumnsElement = document.createElementNS(this.messagesNS, "returnSearchColumns");
        returnSearchColumnsElement.setTextContent(String.valueOf(returnSearchColumns));
        searchPreferencesBody.appendChild(returnSearchColumnsElement);
        Element pageSizeElement = document.createElementNS(this.messagesNS, "pageSize");
        pageSizeElement.setTextContent(String.valueOf(pageSize));
        searchPreferencesBody.appendChild(pageSizeElement);
        return document;
    }

    public Document changeEmail(String newEmail, String currentCredentials, boolean justThisAccount) throws ParserConfigurationException {
        Document document = this.createNewDocument();
        Element changeEmailBody = document.createElementNS(this.messagesNS, "changeEmail");
        document.appendChild(changeEmailBody);
        Element changeEmailElement = document.createElementNS(this.messagesNS, "changeEmail");
        changeEmailBody.appendChild(changeEmailElement);
        Element currentPasswordElement = document.createElementNS(this.coreNS, "currentPassword");
        currentPasswordElement.setTextContent(currentCredentials);
        changeEmailElement.appendChild(currentPasswordElement);
        Element newEmailElement = document.createElementNS(this.coreNS, "newEmail");
        newEmailElement.setTextContent(newEmail);
        changeEmailElement.appendChild(newEmailElement);
        Element newEmail2Element = document.createElementNS(this.coreNS, "newEmail2");
        newEmail2Element.setTextContent(newEmail);
        changeEmailElement.appendChild(newEmail2Element);
        Element justThisAccountElement = document.createElementNS(this.coreNS, "justThisAccount");
        justThisAccountElement.setTextContent(String.valueOf(justThisAccount));
        changeEmailElement.appendChild(justThisAccountElement);
        return document;
    }

    public Document changePassword(String newPassword, String currentCredentials) throws ParserConfigurationException {
        Document document = this.createNewDocument();
        Element changePasswordBody = document.createElementNS(this.messagesNS, "changePassword");
        document.appendChild(changePasswordBody);
        Element changePasswordElement = document.createElementNS(this.coreNS, "changePassword");
        changePasswordBody.appendChild(changePasswordElement);
        Element currentPasswordElement = document.createElementNS(this.coreNS, "currentPassword");
        currentPasswordElement.setTextContent(currentCredentials);
        changePasswordElement.appendChild(currentPasswordElement);
        Element newPasswordElement = document.createElementNS(this.coreNS, "newPassword");
        newPasswordElement.setTextContent(newPassword);
        changePasswordElement.appendChild(newPasswordElement);
        Element newPassword2Element = document.createElementNS(this.coreNS, "newPassword2");
        newPassword2Element.setTextContent(newPassword);
        changePasswordElement.appendChild(newPassword2Element);
        return document;
    }

    public Document getAsyncResult(String jobId, Integer pageIndex) throws ParserConfigurationException {
        Document document = this.createNewDocument();
        Element getAsyncResultBody = document.createElementNS(this.messagesNS, "getAsyncResult");
        document.appendChild(getAsyncResultBody);
        Element jobIdElement = document.createElementNS(this.messagesNS, "jobId");
        jobIdElement.setTextContent(jobId);
        getAsyncResultBody.appendChild(jobIdElement);
        Element pageIndexElement = document.createElementNS(this.messagesNS, "pageIndex");
        pageIndexElement.setTextContent(String.valueOf(pageIndex));
        getAsyncResultBody.appendChild(pageIndexElement);
        return document;
    }

    public Document checkAsyncStatus(String jobId) throws ParserConfigurationException {
        Document document = this.createNewDocument();
        Element checkAsyncStatusBody = this.createElementNS(document, document, this.messagesNS, "checkAsyncStatus");
        Element jobIdElement = this.createElementNS(document, checkAsyncStatusBody, this.messagesNS, "jobId");
        jobIdElement.setTextContent(jobId);
        return document;
    }

    public Document transformCustomFieldsIncoming(InputStream input, String separator) throws IOException, SAXException, ParserConfigurationException, XPathExpressionException {
        Document document = this.transformToDocument(input);
        List<Node> customFieldNodes = XmlUtils.toList((NodeList)XmlUtils.executeXPath("//*[local-name()='customField']", document, XPathConstants.NODESET));
        for (Node node : customFieldNodes) {
            String type = StringUtils.substringAfter((String)XmlUtils.executeXPath("./@*[local-name()='type']", node), (String)":");
            String scriptId = XmlUtils.executeXPath("./@*[local-name()='scriptId']", node);
            String internalId = XmlUtils.executeXPath("./@*[local-name()='internalId']", node);
            document.renameNode(node, node.getNamespaceURI(), CustomFieldUtils.getCustomFieldElementName(separator, type, scriptId, internalId));
        }
        return document;
    }

    protected void createAttributeNSIfNotPresent(Document document, Node node, String namespace, String name, String currentValue, String newValue) {
        if (StringUtils.isBlank((CharSequence)currentValue)) {
            this.createAttributeNS(document, node, namespace, String.format("%s:%s", DEFAULT_XSI_PREFIX, name), newValue);
        }
    }

    protected void createAttributeIfNotPresent(Document document, Node node, String nane, String currentValue, String newValue) {
        if (StringUtils.isBlank((CharSequence)currentValue)) {
            this.createAttribute(document, node, nane, newValue);
        }
    }

    private Attr createAttributeNS(Document document, Node node, String namespace, String name, String value) {
        Attr typeAttr = document.createAttributeNS(namespace, name);
        typeAttr.setValue(value);
        node.getAttributes().setNamedItemNS(typeAttr);
        return typeAttr;
    }

    protected Attr createAttribute(Document document, Node node, String name, String value) {
        Attr typeAttr = document.createAttribute(name);
        typeAttr.setValue(value);
        node.getAttributes().setNamedItem(typeAttr);
        return typeAttr;
    }

    private Element createElementNS(Document document, Node parentNode, String ns, String name) {
        Element result = document.createElementNS(ns, name);
        parentNode.appendChild(result);
        return result;
    }

    public Document getDataCenterUrls(String accountId) throws ParserConfigurationException {
        Document document = this.createNewDocument();
        Element getDataCenterUrlsBody = document.createElementNS(this.messagesNS, "getDataCenterUrls");
        document.appendChild(getDataCenterUrlsBody);
        Element accountElement = document.createElementNS(this.messagesNS, "account");
        accountElement.setTextContent(accountId);
        getDataCenterUrlsBody.appendChild(accountElement);
        return document;
    }

    protected Document createNewDocument() throws ParserConfigurationException {
        Document document = NetsuiteDocumentFactory.getDocumentBuilder().newDocument();
        return document;
    }

    public Document generateOperationEmptyBody(String operation) throws ParserConfigurationException {
        Document document = this.createNewDocument();
        Element element = document.createElementNS(this.messagesNS, operation);
        document.appendChild(element);
        return document;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Document transformToDocument(InputStream xmlInputStream) throws ParserConfigurationException, IOException, SAXException {
        byte[] buffer = IOUtils.toByteArray((InputStream)xmlInputStream);
        try (ByteArrayInputStream input = new ByteArrayInputStream(buffer);){
            Document document = this.parse(input);
            return document;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    protected Document parse(ByteArrayInputStream input) throws SAXException, IOException, ParserConfigurationException {
        return NetsuiteDocumentFactory.getDocumentBuilder().parse(input);
    }

    public Document transformToDocument(String xml, Charset charset) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilder documentBuilder = NetsuiteDocumentFactory.getDocumentBuilder();
        Document document = documentBuilder.parse(new ByteArrayInputStream(xml.getBytes(charset)));
        document.getDocumentElement().normalize();
        return document;
    }

    protected static DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        return XmlFactories.getDocumentBuilderFactory().newDocumentBuilder();
    }

    public InputStream transformToInputStream(Node node) throws TransformerException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Transformer transformer = XmlFactories.getTransformerFactory().newTransformer();
        transformer.setURIResolver(new URIResolver(){

            @Override
            public Source resolve(String href, String base) throws TransformerException {
                return null;
            }
        });
        transformer.transform(new DOMSource(node), new StreamResult(outputStream));
        return new ByteArrayInputStream(outputStream.toByteArray());
    }

    public String convertToString(Node node) throws TransformerException, IOException {
        return this.convertToString(this.transformToInputStream(node));
    }

    public String convertToString(InputStream xmlInputStream) throws TransformerException, IOException {
        return org.apache.commons.io.IOUtils.toString((InputStream)xmlInputStream, (Charset)StandardCharsets.UTF_8);
    }

    public Document get(InputStream message, RecordRefAndTypeParameterGroup recordRefAndType) throws IOException, SAXException, ParserConfigurationException {
        String recordType = null;
        if (recordRefAndType != null && StringUtils.isBlank((CharSequence)recordRefAndType.getType())) {
            recordType = recordRefAndType.getType();
        }
        if (recordType == null) {
            return this.transformToDocument(message);
        }
        Document document = this.transformToDocument(message);
        return document;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String createTokenPassportString(TokenConnectionParameters connectionParameters, Mac messageAuthenticationCode, CustomUUIDGenerator customUUIDGenerator) {
        try (StringWriter writer = new StringWriter();){
            String account = connectionParameters.getAccount();
            String consumerKey = connectionParameters.getConsumerKey();
            String tokenId = connectionParameters.getTokenId();
            String nonce = NetsuiteDocumentFactory.generateNonce(customUUIDGenerator);
            String timestamp = String.valueOf(System.currentTimeMillis() / 1000L);
            String signature = Base64.encodeBase64String((byte[])messageAuthenticationCode.doFinal(Stream.of(account, consumerKey, tokenId, nonce, timestamp).map(Object::toString).collect(Collectors.joining("&")).getBytes(StandardCharsets.UTF_8)));
            Document document = NetsuiteDocumentFactory.getDocumentBuilder().newDocument();
            Element tokenPassportBody = document.createElementNS(String.format("urn:messages_%s.platform.webservices.netsuite.com", "2020_2"), "tokenPassport");
            document.appendChild(tokenPassportBody);
            NetsuiteDocumentFactory.addToDocument(document, tokenPassportBody, "account", account);
            NetsuiteDocumentFactory.addToDocument(document, tokenPassportBody, "consumerKey", consumerKey);
            NetsuiteDocumentFactory.addToDocument(document, tokenPassportBody, "token", tokenId);
            NetsuiteDocumentFactory.addToDocument(document, tokenPassportBody, "nonce", nonce);
            NetsuiteDocumentFactory.addToDocument(document, tokenPassportBody, "timestamp", timestamp);
            NetsuiteDocumentFactory.addToDocument(document, tokenPassportBody, "signature", signature, "algorithm", connectionParameters.getSignatureAlgorithm());
            Transformer transformer = XmlFactories.getTransformerFactory().newTransformer();
            transformer.transform(new DOMSource(document), new StreamResult(writer));
            String string = writer.toString();
            return string;
        }
        catch (IOException | RuntimeException | ParserConfigurationException | TransformerException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    protected static String generateNonce(CustomUUIDGenerator customUUIDGenerator) {
        String token = customUUIDGenerator.get();
        return token.length() >= 65 ? token.substring(0, 64) : token;
    }

    private static void addToDocument(Document document, Element tokenPassportBody, String qualifiedName, String textContent) {
        NetsuiteDocumentFactory.addToDocument(document, tokenPassportBody, qualifiedName, textContent, null, null);
    }

    private static void addToDocument(Document document, Element tokenPassportBody, String qualifiedName, String textContent, String attributeName, String attributeValue) {
        Element element = document.createElementNS(String.format("urn:core_%s.platform.webservices.netsuite.com", "2020_2"), qualifiedName);
        if (attributeName != null) {
            element.setAttribute(attributeName, attributeValue);
        }
        element.setTextContent(textContent);
        tokenPassportBody.appendChild(element);
    }

    public InputStream transform(String expression, InputStream xmlInput) {
        BindingContext context = BindingContext.builder().addBinding(PAYLOAD, new TypedValue((Object)xmlInput, XML_STREAM)).addBinding(WSDL_VERSION, TypedValue.of((Object)this.wsdlVersion)).build();
        Object expressionResult = this.expressionExecutor.evaluate(expression, context).getValue();
        return (InputStream)this.transformationService.transform(expressionResult, DataType.fromObject((Object)expressionResult), DataType.INPUT_STREAM);
    }

    public InputStream transform(String expression, Map<String, Object> inputParams) {
        BindingContext context = BindingContext.builder().addBinding(PAYLOAD, new TypedValue(inputParams, DataType.OBJECT)).addBinding(WSDL_VERSION, TypedValue.of((Object)this.wsdlVersion)).build();
        Object expressionResult = this.expressionExecutor.evaluate(expression, context).getValue();
        return (InputStream)this.transformationService.transform(expressionResult, DataType.fromObject((Object)expressionResult), DataType.INPUT_STREAM);
    }

    public Map<String, Object> transformToMap(String expression, InputStream xmlInput) {
        BindingContext context = BindingContext.builder().addBinding(PAYLOAD, new TypedValue((Object)xmlInput, XML_STREAM)).addBinding(WSDL_VERSION, TypedValue.of((Object)this.wsdlVersion)).build();
        Object expressionResult = this.expressionExecutor.evaluate(expression, context).getValue();
        return (Map)this.transformationService.transform(expressionResult, DataType.fromObject((Object)expressionResult), DataType.OBJECT);
    }

    public Document getListRequest(List<Node> baseRefs) throws ParserConfigurationException {
        Document document = this.createNewDocument();
        Element getBodyElement = document.createElementNS(this.messagesNS, "getList");
        getBodyElement.setAttribute(XMLNS_PLATFORM_CORE, this.coreNS);
        getBodyElement.setAttribute(XMLNS_XSI, XMLSCHEMA_INSTANCE);
        document.appendChild(getBodyElement);
        baseRefs.forEach(baseRef -> {
            Element baseRefEl = document.createElementNS(this.messagesNS, "baseRef");
            baseRefEl.setAttribute(SCRIPT_ID, baseRef.getAttributes().getNamedItem(SCRIPT_ID).getTextContent());
            baseRefEl.setAttribute(INTERNAL_ID, baseRef.getAttributes().getNamedItem(INTERNAL_ID).getTextContent());
            baseRefEl.setAttribute(TYPE, baseRef.getAttributes().getNamedItem(TYPE).getTextContent());
            baseRefEl.setAttribute("xsi:type", baseRef.getPrefix() + ":" + StringUtils.capitalize((String)baseRef.getLocalName()));
            Element nameEl = document.createElementNS(this.coreNS, "name");
            nameEl.setTextContent(baseRef.getFirstChild().getTextContent());
            baseRefEl.appendChild(nameEl);
            getBodyElement.appendChild(baseRefEl);
        });
        return document;
    }
}

