/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.netsuite.internal.xml;

import com.mulesoft.connector.netsuite.internal.error.exception.NetsuiteTransformationException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.core.api.util.xmlsecurity.XMLSecureFactories;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class XmlTransformation {
    private static final Logger logger = LoggerFactory.getLogger(XmlTransformation.class);
    static XMLSecureFactories factories = XMLSecureFactories.createDefault();
    private static String XSLT_INBOUND_PATH = "xslt/CustomFieldsInbound.xslt";
    private static String XSLT_OUTBOUND_PATH = "xslt/CustomFieldsOutbound.xslt";
    private static final LazyValue<Templates> outboundTemplate = new LazyValue(XmlTransformation::loadXSLTOutboundTemplates);
    private static final LazyValue<Templates> inboundTemplate = new LazyValue(XmlTransformation::loadXSLTInboundTemplates);

    private XmlTransformation() {
    }

    public static ByteArrayInputStream transformInbound(InputStream inputXML) throws IOException, TransformerConfigurationException, ParserConfigurationException, SAXException {
        return XmlTransformation.transform((Templates)inboundTemplate.get(), inputXML);
    }

    public static ByteArrayInputStream transformOutbound(InputStream inputXML) throws IOException, TransformerConfigurationException, ParserConfigurationException, SAXException {
        return XmlTransformation.transform((Templates)outboundTemplate.get(), inputXML);
    }

    private static ByteArrayInputStream transform(Templates stylesheet, InputStream inputXML) throws IOException, TransformerConfigurationException, ParserConfigurationException, SAXException {
        TransformerFactory tfactory = XmlTransformation.getTransformerFactory();
        SAXParser jaxpParser = XmlTransformation.getSaxParserFactory().newSAXParser();
        SAXTransformerFactory stf = (SAXTransformerFactory)tfactory;
        TransformerHandler th = stf.newTransformerHandler(stylesheet);
        XMLReader reader = XmlTransformation.createXmlReader(jaxpParser);
        reader.setContentHandler(th);
        reader.setDTDHandler(th);
        ByteArrayOutputStream result = new ByteArrayOutputStream(1024);
        StreamResult strResult = new StreamResult(result);
        th.setResult(strResult);
        reader.parse(new InputSource(inputXML));
        return new ByteArrayInputStream(result.toByteArray());
    }

    protected static SAXParserFactory getSaxParserFactory() throws SAXNotSupportedException, SAXNotRecognizedException, ParserConfigurationException {
        SAXParserFactory saxParserFactory = factories.getSAXParserFactory();
        saxParserFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        saxParserFactory.setNamespaceAware(true);
        return saxParserFactory;
    }

    protected static TransformerFactory getTransformerFactory() {
        return factories.getTransformerFactory();
    }

    private static XMLReader createXmlReader(SAXParser jaxpParser) throws SAXException {
        XMLReader reader = jaxpParser.getXMLReader();
        logger.trace("Created Reader is JAXP");
        return reader;
    }

    private static Templates loadXSLTInboundTemplates() {
        return XmlTransformation.loadXSLTTemplate(XSLT_INBOUND_PATH);
    }

    private static Templates loadXSLTOutboundTemplates() {
        return XmlTransformation.loadXSLTTemplate(XSLT_OUTBOUND_PATH);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Templates loadXSLTTemplate(String relativePath) {
        try (InputStream inputXSLT = XmlTransformation.getResourceAsStream(relativePath);){
            Templates templates = XmlTransformation.getTemplates(inputXSLT);
            return templates;
        }
        catch (IOException e) {
            throw new NetsuiteTransformationException(e);
        }
    }

    private static Templates getTemplates(InputStream inputXSLT) {
        try {
            return XmlTransformation.getTransformerFactory().newTemplates(new StreamSource(inputXSLT));
        }
        catch (Exception e) {
            throw new NetsuiteTransformationException(e);
        }
    }

    private static InputStream getResourceAsStream(String xmlResourcePath) {
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(xmlResourcePath);
    }
}

