/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.netsuite.internal.connection.provider;

import com.mulesoft.connector.netsuite.api.WsdlVersion;
import com.mulesoft.connector.netsuite.internal.connection.NetSuiteSoapConnection;
import com.mulesoft.connector.netsuite.internal.connection.provider.config.AdvancedConfig;
import com.mulesoft.connector.netsuite.internal.connection.provider.config.ProxyConfiguration;
import com.mulesoft.connector.netsuite.internal.connection.provider.config.SoapParameters;
import com.mulesoft.connector.netsuite.internal.connection.provider.config.TokenConnectionParameters;
import com.mulesoft.connector.netsuite.internal.error.exception.ServerNotFoundException;
import com.mulesoft.connector.netsuite.internal.util.CustomUUIDGenerator;
import com.mulesoft.connector.netsuite.internal.util.NetsuiteDocumentFactory;
import com.mulesoft.connectors.commons.template.connection.provider.ConnectorConnectionProvider;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Optional;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.connection.CachedConnectionProvider;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.el.MuleExpressionLanguage;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.transformation.TransformationService;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.RefName;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.client.proxy.ProxyConfig;
import org.mule.runtime.http.api.tcp.TcpClientSocketProperties;
import org.mule.runtime.http.api.tcp.TcpClientSocketPropertiesBuilder;
import org.mule.soap.api.SoapVersion;
import org.mule.soap.api.SoapWebServiceConfiguration;
import org.mule.soap.api.client.SoapClient;
import org.mule.soap.api.client.SoapClientFactory;
import org.mule.soap.api.client.SoapConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alias(value="token-based-authentication", description="Token Based Authentication")
public class TokenBasedAuthenticationConnectionProvider
implements CachedConnectionProvider<NetSuiteSoapConnection>,
ConnectorConnectionProvider<NetSuiteSoapConnection>,
Initialisable,
Disposable,
Startable,
Stoppable {
    private static final Logger logger = LoggerFactory.getLogger(TokenBasedAuthenticationConnectionProvider.class);
    @RefName
    private String configName;
    @ParameterGroup(name="Advanced")
    @NullSafe
    private AdvancedConfig advancedConfig;
    @ParameterGroup(name="Proxy")
    @NullSafe
    private ProxyConfiguration proxyConfiguration;
    @Inject
    private HttpService httpService;
    @ParameterGroup(name="Connection")
    private TokenConnectionParameters connectionParameters;
    @ParameterGroup(name="SOAP")
    private SoapParameters soapParameters;
    private HttpClient httpClient;
    private Mac messageAuthenticationCode;
    private CustomUUIDGenerator customUUIDGenerator = new CustomUUIDGenerator();
    @Inject
    protected MuleExpressionLanguage expressionExecutor;
    @Inject
    protected TransformationService transformationService;
    private final SoapClientFactory soapClientFactory = SoapClientFactory.getDefault();
    private LazyValue<SoapClient> defaultSoapClient;
    private Optional<WsdlVersion> optionalWsdlVersion;

    public void initialise() throws InitialisationException {
        logger.debug("Connection Provider Initializing");
        try {
            logger.debug("Initializing TLS Context");
            LifecycleUtils.initialiseIfNeeded((Object)this.advancedConfig.getTlsContext());
            this.optionalWsdlVersion = this.soapParameters.getWsdlVersion();
        }
        catch (MuleException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
        String signatureAlgorithmValue = this.connectionParameters.getSignatureAlgorithm().replace("_", "").replace("MAC", "mac");
        this.messageAuthenticationCode = null;
        try {
            this.messageAuthenticationCode = Mac.getInstance(signatureAlgorithmValue);
            this.messageAuthenticationCode.init(new SecretKeySpec(String.format("%s&%s", this.connectionParameters.getConsumerSecret(), this.connectionParameters.getTokenSecret()).getBytes(StandardCharsets.UTF_8), signatureAlgorithmValue));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
        logger.debug("Connection Provider initialized");
    }

    public NetSuiteSoapConnection connect() throws ConnectionException {
        this.defaultSoapClient = new LazyValue((Object)this.loadDefaultSoapClient());
        return this.createConnection(this.automaticDiscoveryOfEndpoint());
    }

    private void checkEndpoint(String endpointUrl) throws ConnectionException {
        try {
            URL url = new URL(endpointUrl);
            String host = url.getHost();
            InetAddress.getByName(host);
        }
        catch (MalformedURLException e) {
            throw new ConnectionException(String.format("The endpoint %s for the connection is malformed", endpointUrl));
        }
        catch (UnknownHostException e) {
            throw new ServerNotFoundException(String.format("Could not resolve host %s", endpointUrl));
        }
    }

    /*
     * Exception decompiling
     */
    private String automaticDiscoveryOfEndpoint() throws ConnectionException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private NetSuiteSoapConnection createConnection(String endpoint) {
        logger.debug("Creating connection with endpoint {}", (Object)endpoint);
        NetSuiteSoapConnection connection = new NetSuiteSoapConnection(this.httpClient, (SoapClient)this.defaultSoapClient.get(), endpoint, () -> {
            MultiMap headers = new MultiMap();
            headers.put((Object)"passport", (Object)NetsuiteDocumentFactory.createTokenPassportString(this.connectionParameters, this.messageAuthenticationCode, this.customUUIDGenerator, this.optionalWsdlVersion));
            return headers;
        }, () -> Thread.currentThread().getContextClassLoader().getResource(WsdlVersion.getBaseDir(this.optionalWsdlVersion) + "/netsuite.wsdl").toString(), this.advancedConfig.getReadTimeoutInMillis(), this.optionalWsdlVersion, this.expressionExecutor, this.transformationService);
        logger.debug("Created connection with endpoint {}", (Object)endpoint);
        return connection;
    }

    public void disconnect(NetSuiteSoapConnection connection) {
        try {
            this.defaultSoapClient.ifComputed(SoapClient::destroy);
        }
        finally {
            connection.disconnect();
        }
    }

    public void dispose() {
        logger.debug("Disposing Connection Provider");
        LifecycleUtils.disposeIfNeeded((Object)this.advancedConfig.getTlsContext(), (Logger)logger);
        logger.debug("Disposed Connection Provider");
    }

    protected SoapClient loadDefaultSoapClient() {
        return this.createSoapClient();
    }

    protected SoapClient createSoapClient() throws SoapConfigurationException {
        String wsdlLocation = Thread.currentThread().getContextClassLoader().getResource(WsdlVersion.getBaseDir(this.optionalWsdlVersion) + "/netsuite.wsdl").toString();
        logger.debug("Creating SoapClient from wsdl location {}", (Object)wsdlLocation);
        SoapClient soapClient = this.soapClientFactory.create(SoapWebServiceConfiguration.builder().withService("NetSuiteService").withPort("NetSuitePort").withWsdlLocation(wsdlLocation).withVersion(SoapVersion.SOAP_11).build());
        logger.debug("Created SoapClient successfully from wsdl location {}", (Object)wsdlLocation);
        return soapClient;
    }

    public void start() throws MuleException {
        logger.debug(" Using the advancedConfig with httpClient {} ", (Object)this.advancedConfig);
        TcpClientSocketPropertiesBuilder builder = TcpClientSocketProperties.builder().connectionTimeout(this.advancedConfig.getConnectionTimeoutInMillis()).clientTimeout(this.advancedConfig.getReadTimeoutInMillis());
        logger.debug("Creating HttpClient");
        this.httpClient = this.httpService.getClientFactory().create(new HttpClientConfiguration.Builder().setMaxConnections(this.advancedConfig.getMaximumConnections().intValue()).setConnectionIdleTimeout(this.advancedConfig.getConnectionTimeoutInMillis().intValue()).setTlsContextFactory(this.advancedConfig.getTlsContext()).setProxyConfig((ProxyConfig)(this.proxyConfiguration.getHost() != null ? this.proxyConfiguration : null)).setClientSocketProperties(builder.build()).setName(this.configName).build());
        logger.debug("Starting HttpClient");
        this.httpClient.start();
    }

    public void stop() throws MuleException {
        if (this.httpClient != null) {
            try {
                this.httpClient.stop();
            }
            catch (Exception e) {
                logger.error("Could not stop the HttpClient", (Throwable)e);
            }
            finally {
                this.httpClient = null;
            }
        }
    }

    private /* synthetic */ String lambda$automaticDiscoveryOfEndpoint$0() {
        return StringUtils.removeStart((String)this.soapParameters.getSoapPort(), (String)"/");
    }
}

