/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.netsuite.internal.metadata;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CaseFormat;
import com.mulesoft.connector.netsuite.api.NetsuiteSoapAttributes;
import com.mulesoft.connector.netsuite.api.WsdlVersion;
import com.mulesoft.connector.netsuite.internal.config.NetSuiteSoapConfig;
import com.mulesoft.connector.netsuite.internal.connection.NetSuiteSoapConnection;
import com.mulesoft.connector.netsuite.internal.error.exception.NetSuiteSoapModuleException;
import com.mulesoft.connector.netsuite.internal.metadata.DefaultMetadataRetriever;
import com.mulesoft.connector.netsuite.internal.metadata.factory.XmlTypeLoaderFactory;
import com.mulesoft.connector.netsuite.internal.metadata.query.DefinitionsQuery;
import com.mulesoft.connector.netsuite.internal.metadata.query.DefinitionsQueryLocallyCachedProxy;
import com.mulesoft.connector.netsuite.internal.model.RecordRefAndTypeParameterGroup;
import com.mulesoft.connector.netsuite.internal.operation.ItemOperations;
import com.mulesoft.connector.netsuite.internal.operation.RecordOperations;
import com.mulesoft.connector.netsuite.internal.util.CustomFieldRefType;
import com.mulesoft.connector.netsuite.internal.util.CustomFieldType;
import com.mulesoft.connector.netsuite.internal.util.CustomKey;
import com.mulesoft.connector.netsuite.internal.util.CustomizationTypeEnum;
import com.mulesoft.connector.netsuite.internal.util.MetadataUtils;
import com.mulesoft.connector.netsuite.internal.util.NetsuiteDocumentFactory;
import com.mulesoft.connector.netsuite.internal.util.Utils;
import com.mulesoft.connector.netsuite.internal.xml.XmlUtils;
import com.predic8.schema.Attribute;
import com.predic8.schema.ComplexType;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.lang3.StringUtils;
import org.mule.metadata.api.builder.ObjectFieldTypeBuilder;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.impl.DefaultObjectType;
import org.mule.metadata.xml.api.XmlTypeLoader;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeyBuilder;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MetadataRecordResolver {
    private static final String COULD_NOT_GENERATE_METADATA = "Could not generate metadata from the WSDL model";
    private static final Logger logger = LoggerFactory.getLogger(MetadataRecordResolver.class);
    private final String separator;
    private final ItemOperations itemOperations;
    private final RecordOperations recordOperations;
    private final NetSuiteSoapConnection connection;
    private final NetSuiteSoapConfig config;
    private String operationName;
    private DefaultMetadataRetriever metadataRetriever;
    private DefinitionsQuery definitionsQuery;
    LazyValue<XmlTypeLoader> xmlTypeLoader = new LazyValue(this::loadXmlTypeLoader);

    public MetadataRecordResolver(MetadataContext metadataContext, DefaultMetadataRetriever metadataRetriever, String operationName) throws ConnectionException, MetadataResolvingException {
        this.metadataRetriever = metadataRetriever;
        this.operationName = operationName;
        this.connection = (NetSuiteSoapConnection)metadataContext.getConnection().orElseThrow(() -> new MetadataResolvingException("Could not get a connection to resolve metadata", FailureCode.CONNECTION_FAILURE));
        this.config = (NetSuiteSoapConfig)metadataContext.getConfig().orElseThrow(() -> new MetadataResolvingException("Could not get a config to resolve metadata", FailureCode.CONNECTION_FAILURE));
        this.definitionsQuery = new DefinitionsQueryLocallyCachedProxy(this.connection.getDefinitions());
        this.separator = this.config.getAdvancedConfig().getSeparator();
        this.itemOperations = new ItemOperations();
        this.recordOperations = new RecordOperations();
    }

    public MetadataType getMetadataForRecordInput(Optional<String> recordType) throws MetadataResolvingException {
        MetadataType metadataType = this.getMetadataForRecord(this.metadataRetriever.getInputType(this.operationName).getBody(), recordType);
        MetadataUtils.replaceWsdlVersionInMetadataTypeIfPossible(metadataType, this.connection.getWsdlVersion());
        return metadataType;
    }

    public MetadataType getMetadataForRecordOutput(Optional<String> recordType) throws MetadataResolvingException {
        MetadataType metadataType = this.getMetadataForRecord(this.metadataRetriever.getOutputType(this.operationName).getBody(), recordType);
        MetadataUtils.replaceWsdlVersionInMetadataTypeIfPossible(metadataType, this.connection.getWsdlVersion());
        return metadataType;
    }

    public MetadataType getMetadataForRefInput(Optional<String> recordType) throws MetadataResolvingException {
        MetadataType metadataType = this.getMetadataForRef(this.metadataRetriever.getInputType(this.operationName).getBody(), recordType, true);
        MetadataUtils.replaceWsdlVersionInMetadataTypeIfPossible(metadataType, this.connection.getWsdlVersion());
        return metadataType;
    }

    public MetadataType getMetadataForRefOutput(Optional<String> recordType) throws MetadataResolvingException {
        MetadataType metadataType = this.getMetadataForRef(this.metadataRetriever.getOutputType(this.operationName).getBody(), recordType, false);
        MetadataUtils.replaceWsdlVersionInMetadataTypeIfPossible(metadataType, this.connection.getWsdlVersion());
        return metadataType;
    }

    public MetadataType getMetadataForAttachInput(Optional<String> attachType, String reference) throws MetadataResolvingException {
        MetadataType metadataType = this.getMetadataForAttachRefType(this.metadataRetriever.getInputType(this.operationName).getBody(), attachType, reference);
        MetadataUtils.replaceWsdlVersionInMetadataTypeIfPossible(metadataType, this.connection.getWsdlVersion());
        return metadataType;
    }

    public MetadataType getMetadataForSearch(Optional<String> searchType) throws MetadataResolvingException {
        return this.getMetadataForSearchType(this.metadataRetriever.getInputType(this.operationName).getBody(), searchType);
    }

    public Set<MetadataKey> getRecordRefAndTypeParameterGroup() throws MetadataResolvingException {
        HashSet<MetadataKey> results = new HashSet<MetadataKey>();
        for (ComplexType complexType : this.definitionsQuery.getComplexSuperTypes("BaseRef")) {
            MetadataKeyBuilder metadataKeyBuilder = MetadataKeyBuilder.newKey((String)complexType.getQname().getLocalPart());
            for (Attribute attribute : complexType.getAllAttributes()) {
                if (!attribute.getName().equals("type") || !attribute.getType().getLocalPart().equals("RecordType")) continue;
                List<String> recordTypes = this.definitionsQuery.getRecordTypes();
                if (recordTypes.isEmpty()) {
                    throw new MetadataResolvingException("Could not obtain record types (RecordTypes) from the schema", FailureCode.NO_DYNAMIC_KEY_AVAILABLE);
                }
                recordTypes.forEach(type -> metadataKeyBuilder.withChild(MetadataKeyBuilder.newKey((String)CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, type))).build());
            }
            if (complexType.getQname().getLocalPart().equals("CustomRecordRef")) {
                this.getCustomRecordKeys().forEach(metadataKey -> metadataKeyBuilder.withChild(metadataKey).build());
            }
            results.add(metadataKeyBuilder.build());
        }
        return results;
    }

    public Set<MetadataKey> getRecordTypesMetadataType() {
        Set<MetadataKey> recordTypes = this.definitionsQuery.getRecordTypes().stream().map(e -> MetadataKeyBuilder.newKey((String)e).withDisplayName(StringUtils.capitalize((String)e)).build()).collect(Collectors.toSet());
        recordTypes.addAll(this.getCustomRecordKeys());
        return recordTypes;
    }

    private MetadataType getMetadataForRecord(MetadataType defaultMetadataType, Optional<String> recordType) throws MetadataResolvingException {
        if (recordType.isPresent()) {
            CustomKey customKey = CustomKey.fromKey(recordType.get(), this.separator);
            ObjectType objectType = (ObjectType)defaultMetadataType;
            this.replaceWithXmlTypeLoaderElement(objectType, customKey.getType(), "record");
            if (customKey.isCustomRecord()) {
                this.retrieveRecordFromNetsuiteAndGenerateMetadata(objectType, recordType.get());
            } else {
                this.generateCustomMetadataTypes(objectType, recordType.get(), false);
            }
        }
        return defaultMetadataType;
    }

    private void retrieveRecordFromNetsuiteAndGenerateMetadata(ObjectType defaultMetadataType, String recordType) throws MetadataResolvingException {
        try {
            Document getCustomRecordDocument = this.retrieveCustomRecordByTypeFromNetsuite(recordType);
            List<Node> listOfCustomFieldNodes = XmlUtils.toList((NodeList)XmlUtils.executeXPath("//*[local-name()='customFieldList']//*", getCustomRecordDocument, XPathConstants.NODESET));
            List<ObjectFieldType> metadataTypes = this.convertCustomizationRecordToMetadataType(listOfCustomFieldNodes, recordType, true);
            this.addCustomFieldsToCustomFieldList(defaultMetadataType, metadataTypes);
        }
        catch (ParserConfigurationException | TransformerException | XPathExpressionException e) {
            throw new MetadataResolvingException("Could not resolve metadata for the given key", FailureCode.NO_DYNAMIC_METADATA_AVAILABLE);
        }
    }

    protected MetadataType getMetadataForRef(MetadataType defaultMetadataType, Optional<String> refType, boolean isInput) throws MetadataResolvingException {
        if (refType.isPresent()) {
            String refTypeName = refType.get();
            Supplier<MetadataResolvingException> exceptionSupplier = () -> new MetadataResolvingException(String.format("Could not resolve metadata for Ref Type %s", refTypeName), FailureCode.UNKNOWN);
            MetadataType recordMetadataType = this.getMetadataTypeFromXmlTypeLoader(this.definitionsQuery.getElement(refTypeName).orElseThrow(exceptionSupplier));
            try {
                ObjectFieldType baseRefField = this.findValueForKey((ObjectType)defaultMetadataType, "baseRef").orElseThrow(exceptionSupplier);
                if (isInput) {
                    this.setFieldValue(baseRefField.getKey().getName(), this.definitionsQuery.resolveNamespaceFor(refTypeName).orElseThrow(exceptionSupplier), "namespaceURI");
                }
                baseRefField.getKey().getAttributes().addAll(((ObjectFieldType)((DefaultObjectType)recordMetadataType).getFields().iterator().next()).getKey().getAttributes());
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                exceptionSupplier.get();
            }
        }
        return defaultMetadataType;
    }

    protected MetadataType getMetadataForAttachRefType(MetadataType defaultMetadataType, Optional<String> type, String reference) throws MetadataResolvingException {
        if (type.isPresent()) {
            this.replaceWithXmlTypeLoaderElement((ObjectType)defaultMetadataType, type.get(), reference);
        }
        return defaultMetadataType;
    }

    protected MetadataType getMetadataForSearchType(MetadataType defaultMetadataType, Optional<String> type) throws MetadataResolvingException {
        if (type.isPresent()) {
            this.replaceWithXmlTypeLoaderElement((ObjectType)defaultMetadataType, type.get(), "searchRecord");
        }
        return defaultMetadataType;
    }

    public Set<MetadataKey> getAttachRefTypes(String reference) {
        return this.definitionsQuery.getComplexSuperTypes(reference).stream().map(e -> MetadataKeyBuilder.newKey((String)e.getQname().getLocalPart()).withDisplayName(StringUtils.capitalize((String)e.getQname().getLocalPart())).build()).collect(Collectors.toSet());
    }

    protected void replaceWithXmlTypeLoaderElement(ObjectType metadataType, String xmlTypeLoaderElement, String whereLocalMetadataPartName) throws MetadataResolvingException {
        Supplier<MetadataResolvingException> metadataResolvingExceptionSupplier = () -> new MetadataResolvingException(String.format("Could not resolve metadata when assigning %s", whereLocalMetadataPartName), FailureCode.UNKNOWN);
        String elementLocalPart = this.definitionsQuery.getElement(xmlTypeLoaderElement).orElseThrow(metadataResolvingExceptionSupplier);
        MetadataType recordMetadataType = this.getMetadataTypeFromXmlTypeLoader(elementLocalPart);
        ObjectFieldType concreteRecordMetadataType = (ObjectFieldType)((ObjectType)recordMetadataType).getFields().iterator().next();
        ObjectFieldType recordObject = this.findValueForKey(metadataType, whereLocalMetadataPartName).orElseThrow(metadataResolvingExceptionSupplier);
        this.replaceValue(recordObject, concreteRecordMetadataType);
    }

    private Optional<String> tryToResolveNamespace(String localName) {
        return this.definitionsQuery.resolveNamespaceFor(localName);
    }

    protected void replaceValue(Object to, ObjectFieldType from) throws MetadataResolvingException {
        try {
            this.setFieldValue(to, from.getValue(), "value");
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new MetadataResolvingException(COULD_NOT_GENERATE_METADATA, FailureCode.UNKNOWN, (Throwable)e);
        }
    }

    private void replaceObjectFieldKeyName(ObjectFieldType to, Optional<QName> name) throws MetadataResolvingException {
        try {
            this.setFieldValue(to.getKey(), name, "name");
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new MetadataResolvingException(COULD_NOT_GENERATE_METADATA, FailureCode.UNKNOWN, (Throwable)e);
        }
    }

    private MetadataType getMetadataTypeFromXmlTypeLoader(String localTypeName) throws MetadataResolvingException {
        Optional<String> namespaceURI = this.tryToResolveNamespace(localTypeName);
        Optional metadataType = this.getXmlTypeLoader().load(new QName(namespaceURI.orElse("http://mulesoft.org/connectors/netsuite"), localTypeName), localTypeName);
        return (MetadataType)metadataType.orElseThrow(() -> new MetadataResolvingException(String.format("Could not resolve metadata from localTypeName loader for localTypeName %s", localTypeName), FailureCode.UNKNOWN));
    }

    protected Optional<ObjectFieldType> findValueForKey(ObjectType objectType, String keyLocalPartName) {
        Collection fields = objectType.getFields();
        for (ObjectFieldType objectFieldType : fields) {
            Optional<ObjectFieldType> valueForKey;
            if (objectFieldType.getKey().getName().getLocalPart().equals(keyLocalPartName)) {
                return Optional.of(objectFieldType);
            }
            if (!(objectFieldType.getValue() instanceof ObjectType) || !(valueForKey = this.findValueForKey((ObjectType)objectFieldType.getValue(), keyLocalPartName)).isPresent()) continue;
            return valueForKey;
        }
        return Optional.empty();
    }

    @VisibleForTesting
    protected void generateCustomMetadataTypes(ObjectType objectType, String recordType, boolean isCustomRecord) {
        List<String> customizationTypes = Stream.of(CustomizationTypeEnum.values()).map(CustomizationTypeEnum::getNetsuiteValue).collect(Collectors.toList());
        Map<String, List<Node>> customizationMappings = this.retrieveAndExtractCustomizationRefNodesToMap(customizationTypes);
        List<ObjectFieldType> customizationRecords = customizationMappings.values().stream().map(nodes -> this.partitionList((List)nodes, 300)).flatMap(refs -> refs.stream().map(baseRefNodes -> {
            try {
                return this.retrieveRecordsForBaseRefs((List<Node>)baseRefNodes, recordType, isCustomRecord);
            }
            catch (ParserConfigurationException | TransformerException | XPathExpressionException e) {
                logger.error("Could not generate metadata for some customizationIds", (Throwable)e);
                return null;
            }
        }).filter(Objects::nonNull).flatMap(Collection::stream)).sorted(Comparator.comparing(a -> a.getKey().getName().getLocalPart())).collect(Collectors.toList());
        this.addCustomFieldsToCustomFieldList(objectType, customizationRecords);
    }

    private void addCustomFieldsToCustomFieldList(ObjectType objectType, List<ObjectFieldType> customizationRecords) {
        Optional<ObjectFieldType> customFieldList = this.findValueForKey(objectType, "customFieldList");
        if (customFieldList.isPresent()) {
            Collection customFields = ((ObjectType)customFieldList.get().getValue()).getFields();
            List customFieldsKeys = customFields.stream().map(ObjectFieldType::getKey).collect(Collectors.toList());
            customFields.addAll(customizationRecords.stream().filter(element -> !customFieldsKeys.contains(element.getKey())).collect(Collectors.toList()));
        }
    }

    @VisibleForTesting
    protected List<ObjectFieldType> retrieveRecordsForBaseRefs(List<Node> baseRefs, String recordType, boolean isCustomRecord) throws ParserConfigurationException, TransformerException, XPathExpressionException {
        NetsuiteDocumentFactory netsuiteDocumentFactory = new NetsuiteDocumentFactory(this.connection.getWsdlVersion().orElse(WsdlVersion.getDefaultWsdlVersion()).getValue(), null, null);
        Document getListRequestDoc = netsuiteDocumentFactory.getListRequest(baseRefs);
        InputStream message = netsuiteDocumentFactory.transformToInputStream(getListRequestDoc);
        Result<InputStream, NetsuiteSoapAttributes> getListResult = this.recordOperations.getList(this.config, this.connection, new RecordRefAndTypeParameterGroup(), message);
        Document getListResultDocument = netsuiteDocumentFactory.transformToDocument((InputStream)getListResult.getOutput());
        List<Node> customizationRecords = XmlUtils.toList((NodeList)XmlUtils.executeXPath("//*[local-name()='record']", getListResultDocument, XPathConstants.NODESET));
        return this.convertCustomizationRecordToMetadataType(customizationRecords, recordType, isCustomRecord);
    }

    private Document retrieveCustomRecordByTypeFromNetsuite(String recordType) throws ParserConfigurationException, TransformerException {
        NetsuiteDocumentFactory netsuiteDocumentFactory = new NetsuiteDocumentFactory(this.connection.getWsdlVersion().orElse(WsdlVersion.getDefaultWsdlVersion()).getValue(), null, null);
        Document getRecordRequest = netsuiteDocumentFactory.getRecord(recordType, this.separator);
        InputStream message = netsuiteDocumentFactory.transformToInputStream(getRecordRequest);
        Result<InputStream, NetsuiteSoapAttributes> getCustomRecord = this.recordOperations.get(this.config, this.connection, new RecordRefAndTypeParameterGroup("CustomRecordRef", recordType), message);
        return netsuiteDocumentFactory.transformToDocument((InputStream)getCustomRecord.getOutput());
    }

    protected List<ObjectFieldType> convertCustomizationRecordToMetadataType(List<Node> customizationRecords, String recordType, boolean isCustomRecord) {
        return customizationRecords.stream().map(node -> {
            try {
                String appliesToRecordType = XmlUtils.executeXPath("./*[starts-with(local-name(), 'appliesTo') and (contains(local-name(), '" + recordType + "') or (contains(local-name(), '" + StringUtils.capitalize((String)recordType) + "')))]", node);
                if (isCustomRecord || Boolean.parseBoolean(appliesToRecordType)) {
                    String internalId = XmlUtils.executeXPath("./@*[local-name() = 'internalId']", node);
                    String fieldType = XmlUtils.executeXPath("./*[local-name() = 'fieldType']", node);
                    String scriptId = XmlUtils.executeXPath("./*[local-name() = 'scriptId']", node);
                    String label = XmlUtils.executeXPath("./*[local-name() = 'label']", node);
                    String description = XmlUtils.executeXPath("./*[local-name() = 'description']", node);
                    String isMandatory = XmlUtils.executeXPath("./*[local-name() = 'isMandatory']", node);
                    String accessLevel = XmlUtils.executeXPath("./*[local-name() = 'accessLevel']", node);
                    String searchLevel = XmlUtils.executeXPath("./*[local-name() = 'searchLevel']", node);
                    Optional<CustomFieldRefType> customFieldRefType = CustomFieldType.refTypeFromNetSuiteName(fieldType);
                    if (scriptId.isEmpty() || fieldType.isEmpty()) {
                        String customizationData = String.format("internalId: '%s' fieldType:'%s' label:'%s' description:'%s' isMandatory:'%s' accessLevel:'%s' searchLevel:'%s'", internalId, fieldType, label, description, isMandatory, accessLevel, searchLevel);
                        logger.warn("Could not recognize field with values :: {}", (Object)customizationData);
                        return null;
                    }
                    if (customFieldRefType.isPresent()) {
                        return this.createMetadataKeyFromCustomFieldRefType(customFieldRefType.get(), scriptId, internalId, this.separator);
                    }
                }
            }
            catch (XPathExpressionException | MetadataResolvingException e) {
                logger.error(String.format("Could not generate metadata for node %s", node), e);
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public ObjectFieldType createMetadataKeyFromCustomFieldRefType(CustomFieldRefType customFieldRefType, String scriptId, String internalId, String separator) throws MetadataResolvingException {
        String metadataFieldKey = CustomKey.fromCustomFieldRefType(customFieldRefType, scriptId, internalId, separator).getMetadataFieldKey(Utils.shouldOmitInternalIdCustomFieldNames(this.config, this.connection.getWsdlVersion()));
        logger.debug(metadataFieldKey);
        MetadataType typeRefMetadata = this.getMetadataTypeFromXmlTypeLoader(Utils.toLowerCamelCase(customFieldRefType.getNetsuiteValue()));
        Optional result = ((DefaultObjectType)typeRefMetadata).getFields().stream().findFirst();
        if (result.isPresent()) {
            QName qname = new QName(metadataFieldKey);
            ObjectFieldType myResult = this.getDuplicateObjectFieldType((ObjectFieldType)result.get(), qname);
            this.replaceObjectFieldKeyName(myResult, Optional.of(qname));
            return myResult;
        }
        return null;
    }

    public ObjectFieldType getDuplicateObjectFieldType(ObjectFieldType objectFieldType, QName metadataFieldKey) {
        ObjectFieldTypeBuilder objectFieldTypeBuilder = new ObjectFieldTypeBuilder(objectFieldType.getMetadataFormat());
        objectFieldTypeBuilder.key(metadataFieldKey);
        objectFieldTypeBuilder.value(objectFieldType.getValue());
        return objectFieldTypeBuilder.build();
    }

    @VisibleForTesting
    protected Map<String, List<Node>> retrieveAndExtractCustomizationRefNodesToMap(List<String> customizationTypes) {
        return customizationTypes.stream().collect(Collectors.toMap(v -> v, customizationId -> {
            try {
                return this.retrieveCustomizationRefNodes((String)customizationId);
            }
            catch (NetSuiteSoapModuleException | ParserConfigurationException | TransformerException | XPathExpressionException e) {
                logger.error(String.format("Could not obtain custom Fields from Netsuite for customizationId %s", customizationId), (Throwable)e);
                return Collections.emptyList();
            }
        }));
    }

    @VisibleForTesting
    protected List<Node> retrieveCustomizationRefNodes(String customizationId) throws ParserConfigurationException, TransformerException, XPathExpressionException {
        NetsuiteDocumentFactory netsuiteDocumentFactory = new NetsuiteDocumentFactory(this.connection.getWsdlVersion().orElse(WsdlVersion.getDefaultWsdlVersion()).getValue(), null, null);
        Document customizationRequestDoc = netsuiteDocumentFactory.getCustomizationRequest(customizationId);
        Result<InputStream, NetsuiteSoapAttributes> customizationIdsResponse = this.itemOperations.getCustomizationId(this.config, this.connection, netsuiteDocumentFactory.transformToInputStream(customizationRequestDoc));
        NodeList customizationRefNodes = (NodeList)XmlUtils.executeXPath("//*[local-name()='customizationRef']", (InputStream)customizationIdsResponse.getOutput(), XPathConstants.NODESET);
        return XmlUtils.toList(customizationRefNodes);
    }

    private <T> List<List<T>> partitionList(List<T> customizationRefElements, int partitionSize) {
        ArrayList<List<T>> results = new ArrayList<List<T>>();
        ArrayList<T> listOfElements = null;
        for (T each : customizationRefElements) {
            if (listOfElements == null || listOfElements.size() >= partitionSize) {
                listOfElements = new ArrayList<T>();
                results.add(listOfElements);
            }
            listOfElements.add(each);
        }
        return results;
    }

    private XmlTypeLoader loadXmlTypeLoader() {
        return XmlTypeLoaderFactory.createCachedXmlTypeLoaderWithLocalDefinitions(this.connection.getDefinitions(), this.connection.getWsdlVersion());
    }

    private XmlTypeLoader getXmlTypeLoader() throws MetadataResolvingException {
        try {
            return (XmlTypeLoader)this.xmlTypeLoader.get();
        }
        catch (RuntimeException e) {
            throw new MetadataResolvingException("", FailureCode.UNKNOWN, (Throwable)e);
        }
    }

    private void setFieldValue(Object object, Object fieldValue, String fieldName) throws IllegalAccessException, NoSuchFieldException {
        Field field = object.getClass().getDeclaredField(fieldName);
        field.setAccessible(true);
        field.set(object, fieldValue);
    }

    public Set<MetadataKey> getGetAllMetadataKeys() {
        return this.definitionsQuery.getGetAllTypes().stream().map(e -> MetadataKeyBuilder.newKey((String)e).build()).collect(Collectors.toSet());
    }

    public Set<MetadataKey> getCustomRecordKeys() {
        List<String> customizationTypes = Stream.of(CustomizationTypeEnum.CUSTOM_RECORD_TYPE).map(CustomizationTypeEnum::getNetsuiteValue).collect(Collectors.toList());
        Map<String, List<Node>> customizationMappings = this.retrieveAndExtractCustomizationRefNodesToMap(customizationTypes);
        List nodes = customizationMappings.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        return nodes.stream().map(node -> {
            try {
                String type = node.getAttributes().getNamedItem("type").getNodeValue();
                String scriptId = node.getAttributes().getNamedItem("scriptId").getNodeValue();
                String internalId = node.getAttributes().getNamedItem("internalId").getNodeValue();
                String keyName = CustomKey.fromParts(type, scriptId, internalId, this.separator).getKeyForCustomRecord();
                String name = XmlUtils.executeXPath("./*[local-name() = 'name']", node);
                return MetadataKeyBuilder.newKey((String)keyName).withDisplayName(StringUtils.capitalize((String)name)).build();
            }
            catch (XPathExpressionException e) {
                logger.error("Could not generate metadata for some customizationIds", (Throwable)e);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toSet());
    }
}

