/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.netsuite.internal.metadata.factory;

import com.mulesoft.connector.netsuite.api.WsdlVersion;
import com.mulesoft.connector.netsuite.internal.metadata.factory.CachedXmlTypeLoader;
import com.predic8.schema.Import;
import com.predic8.wsdl.Definitions;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.metadata.xml.api.SchemaCollector;
import org.mule.metadata.xml.api.XmlTypeLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlTypeLoaderFactory {
    private static final Logger logger = LoggerFactory.getLogger(XmlTypeLoaderFactory.class);

    private XmlTypeLoaderFactory() {
    }

    public static XmlTypeLoader createCachedXmlTypeLoaderWithLocalDefinitions(Definitions definitions, Optional<WsdlVersion> wsdlVersion) {
        Map<String, String> schemaLocations = definitions.getSchemas().stream().flatMap(e -> e.getImports().stream()).collect(Collectors.toMap(Import::getNamespace, v -> WsdlVersion.getBaseDir(wsdlVersion) + "/" + v.getSchemaLocation(), (a, b) -> a));
        schemaLocations.put("connectorCommons", WsdlVersion.getBaseDir(wsdlVersion) + "/connector.xsd");
        ArrayList<URL> schemaUrls = new ArrayList<URL>();
        for (Map.Entry<String, String> entry : schemaLocations.entrySet()) {
            schemaUrls.add(Thread.currentThread().getContextClassLoader().getResource(entry.getValue()));
        }
        SchemaCollector schemaCollector = SchemaCollector.getInstance();
        schemaUrls.forEach(arg_0 -> ((SchemaCollector)schemaCollector).addSchema(arg_0));
        CachedXmlTypeLoader xmlTypeLoader = new CachedXmlTypeLoader(schemaCollector);
        logger.debug("finished creating XmlTypeLoader");
        return xmlTypeLoader;
    }
}

